/*
 * Decompiled with CFR 0.152.
 */
package org.ccbr.bader.yeast;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import cytoscape.task.util.TaskManager;
import cytoscape.view.CyNetworkView;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualStyle;
import ding.view.NodeContextMenuListener;
import giny.model.Node;
import giny.view.NodeView;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.ccbr.bader.geneassociation.GeneAssociationReaderUtil;
import org.ccbr.bader.yeast.GONamespace;
import org.ccbr.bader.yeast.GOSlimPanel;
import org.ccbr.bader.yeast.GOSlimmerUtil;
import org.ccbr.bader.yeast.GOSlimmerVisualStyle;
import org.ccbr.bader.yeast.controller.GOSlimmerController;
import org.ccbr.bader.yeast.model.GOSlimmerCoverageStatBean;
import org.ccbr.bader.yeast.view.gui.NodeContextMenuActionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GOSlimmerSession {
    private CyNetwork molFunSubGraph = null;
    private CyNetwork bioProSubGraph = null;
    private CyNetwork celComSubGraph = null;
    private final String bio_pro_name = "biological_process";
    private final String mol_fun_name = "molecular_function";
    private final String cel_com_name = "cellular_component";
    private GOSlimmerController molFunController = null;
    private GOSlimmerController bioProController = null;
    private GOSlimmerController celComController = null;
    private boolean userGeneSetImported = false;
    private Collection<String> userSpecifiedGeneIdSet;
    private String ontologyName;
    private GeneAssociationReaderUtil garu;
    private final CyAttributes nodeAtt = Cytoscape.getNodeAttributes();
    private Map<GONamespace, GOSlimmerController> namespaceToController = new HashMap<GONamespace, GOSlimmerController>();
    private Collection<String> userGeneSet;
    private Collection<String> unmatchedUserGeneIds;
    private GOSlimPanel goSlimPanel;

    public GeneAssociationReaderUtil getGaru() {
        return this.garu;
    }

    public void setGaru(GeneAssociationReaderUtil garu) {
        this.garu = garu;
    }

    public GOSlimmerSession(CyNetwork goNetwork) {
        VisualMappingManager vmm = Cytoscape.getVisualMappingManager();
        if (!vmm.getCalculatorCatalog().getVisualStyleNames().contains("GOSLIMMERVS")) {
            vmm.getCalculatorCatalog().addVisualStyle((VisualStyle)new GOSlimmerVisualStyle(vmm.getVisualStyle(), "GOSLIMMERVS"));
        }
        vmm.setVisualStyle("GOSLIMMERVS");
        CyNetworkView networkView = Cytoscape.getCurrentNetworkView();
        CyNetwork network = Cytoscape.getCurrentNetwork();
        ArrayList<CyNetwork> subNetworks = new ArrayList<CyNetwork>();
        this.ontologyName = network.getTitle();
        CyAttributes nodeAtt = Cytoscape.getNodeAttributes();
        boolean associatedGeneCount = false;
        this.createOntologyNamespaceSubGraphs(network);
        subNetworks.add(this.molFunSubGraph);
        subNetworks.add(this.bioProSubGraph);
        subNetworks.add(this.celComSubGraph);
        for (final CyNetwork subNetwork : subNetworks) {
            TaskManager.executeTask((Task)new Task(){

                public String getTitle() {
                    return "Creating Views for GO Subgraphs";
                }

                public void halt() {
                }

                public void run() {
                    CyNetworkView subNetworkView = Cytoscape.createNetworkView((CyNetwork)subNetwork);
                    VisualStyle vs = Cytoscape.getVisualMappingManager().setVisualStyle("GOSLIMMERVS");
                    subNetworkView.redrawGraph(false, false);
                    subNetworkView.setVisualStyle("GOSLIMMERVS");
                }

                public void setTaskMonitor(TaskMonitor arg0) throws IllegalThreadStateException {
                }
            }, null);
        }
        this.initializeControllersForSubGraphs();
        Cytoscape.getNetworkView((String)this.molFunSubGraph.getIdentifier()).addNodeContextMenuListener(this.getGOSlimmerNodeContextMenuListener(this.molFunController));
        Cytoscape.getNetworkView((String)this.bioProSubGraph.getIdentifier()).addNodeContextMenuListener(this.getGOSlimmerNodeContextMenuListener(this.bioProController));
        Cytoscape.getNetworkView((String)this.celComSubGraph.getIdentifier()).addNodeContextMenuListener(this.getGOSlimmerNodeContextMenuListener(this.celComController));
        for (GOSlimmerController controller : this.namespaceToController.values()) {
            Node rootNode = GOSlimmerUtil.getRootNode(controller.getNetwork());
            controller.showNode(rootNode);
            controller.collapseNode(rootNode);
            controller.expandNodeToDepth(rootNode, 1, true);
            controller.getNetworkView().fitContent();
            controller.getNetworkView().updateView();
        }
    }

    private List<CyNetwork> createOntologyNamespaceSubGraphs(CyNetwork network) {
        HashSet<Node> molFunNodes = new HashSet<Node>();
        HashSet molFunEdges = new HashSet();
        HashSet<Node> bioProNodes = new HashSet<Node>();
        HashSet bioProEdges = new HashSet();
        HashSet<Node> celComNodes = new HashSet<Node>();
        HashSet celComEdges = new HashSet();
        Iterator nodeIterator = network.nodesIterator();
        Node node = null;
        while (nodeIterator.hasNext()) {
            node = (Node)nodeIterator.next();
            String name = this.nodeAtt.getStringAttribute(node.getIdentifier(), "ontology.name");
            this.nodeAtt.setAttribute(node.getIdentifier(), "GOSlimmer.FORMATTED_NAME", this.formatName(name));
            String nodeOntologyNamespace = this.nodeAtt.getStringAttribute(node.getIdentifier(), "ontology.namespace");
            if ("biological_process".equalsIgnoreCase(nodeOntologyNamespace)) {
                bioProNodes.add(node);
                continue;
            }
            if ("molecular_function".equalsIgnoreCase(nodeOntologyNamespace)) {
                molFunNodes.add(node);
                continue;
            }
            if (!"cellular_component".equalsIgnoreCase(nodeOntologyNamespace)) continue;
            celComNodes.add(node);
        }
        bioProEdges.addAll(network.getConnectingEdges(new ArrayList(bioProNodes)));
        molFunEdges.addAll(network.getConnectingEdges(new ArrayList(molFunNodes)));
        celComEdges.addAll(network.getConnectingEdges(new ArrayList(celComNodes)));
        String networkTitle = network.getTitle();
        CyNetwork molFunNetwork = Cytoscape.createNetwork(molFunNodes, molFunEdges, (String)(networkTitle + "_molecular_function"), (CyNetwork)network, (boolean)false);
        CyNetwork bioProNetwork = Cytoscape.createNetwork(bioProNodes, bioProEdges, (String)(networkTitle + "_biological_process"), (CyNetwork)network, (boolean)false);
        CyNetwork celComNetwork = Cytoscape.createNetwork(celComNodes, celComEdges, (String)(networkTitle + "_cellular_component"), (CyNetwork)network, (boolean)false);
        ArrayList<CyNetwork> subNetworks = new ArrayList<CyNetwork>();
        subNetworks.add(molFunNetwork);
        subNetworks.add(bioProNetwork);
        subNetworks.add(celComNetwork);
        this.molFunSubGraph = molFunNetwork;
        this.bioProSubGraph = bioProNetwork;
        this.celComSubGraph = celComNetwork;
        return subNetworks;
    }

    private NodeContextMenuListener getGOSlimmerNodeContextMenuListener(final GOSlimmerController controller) {
        return new NodeContextMenuListener(){

            public void addNodeContextMenuItems(NodeView node, JPopupMenu menu) {
                Color itemColor;
                NodeContextMenuActionListener listener = new NodeContextMenuActionListener(node.getNode(), controller);
                for (String menuItemName : new String[]{"Collapse", "Prune", "Expand"}) {
                    JMenuItem menuItem = new JMenuItem(menuItemName);
                    menuItem.addActionListener(listener);
                    menu.add(menuItem);
                }
                String itemName = "Select";
                int numAssociatedTermsStr = GOSlimmerSession.this.nodeAtt.getIntegerAttribute(node.getNode().getIdentifier(), "GOSlimmer.NUMBER_DIRECTLY_ANNOTATED_GENES");
                if (numAssociatedTermsStr == 0) {
                    itemName = itemName + " (No Associated Genes)";
                    itemColor = new Color(255, 0, 0);
                } else {
                    itemColor = new Color(0, 0, 0);
                }
                JMenuItem selectMenuItem = new JMenuItem(itemName);
                selectMenuItem.setForeground(itemColor);
                selectMenuItem.addActionListener(listener);
                menu.add(selectMenuItem);
                JMenuItem deselectMenuItem = new JMenuItem("Deselect");
                deselectMenuItem.addActionListener(listener);
                menu.add(deselectMenuItem);
            }
        };
    }

    private void initializeControllersForSubGraphs() {
        this.molFunController = new GOSlimmerController(GONamespace.MolFun, this.molFunSubGraph, Cytoscape.getNetworkView((String)this.molFunSubGraph.getIdentifier()), new GOSlimmerCoverageStatBean(1, this), this);
        this.bioProController = new GOSlimmerController(GONamespace.BioPro, this.bioProSubGraph, Cytoscape.getNetworkView((String)this.bioProSubGraph.getIdentifier()), new GOSlimmerCoverageStatBean(1, this), this);
        this.celComController = new GOSlimmerController(GONamespace.CelCom, this.celComSubGraph, Cytoscape.getNetworkView((String)this.celComSubGraph.getIdentifier()), new GOSlimmerCoverageStatBean(1, this), this);
        this.namespaceToController.put(GONamespace.BioPro, this.bioProController);
        this.namespaceToController.put(GONamespace.CelCom, this.celComController);
        this.namespaceToController.put(GONamespace.MolFun, this.molFunController);
        this.molFunController.setExpansionDepth(1);
        this.molFunController.setUseFiniteExpansionDepth(true);
        this.bioProController.setExpansionDepth(1);
        this.bioProController.setUseFiniteExpansionDepth(true);
        this.celComController.setExpansionDepth(1);
        this.celComController.setUseFiniteExpansionDepth(true);
    }

    public Map<GONamespace, GOSlimmerController> getNamespaceToController() {
        return this.namespaceToController;
    }

    public String getOntologyName() {
        return this.ontologyName;
    }

    public void setOntologyName(String ontologyName) {
        this.ontologyName = ontologyName;
    }

    public boolean isUserGeneSetImported() {
        return this.userGeneSetImported;
    }

    public void setUserGeneSetImported(boolean userGeneSetImported) {
        this.userGeneSetImported = userGeneSetImported;
    }

    public Collection<String> getUserSpecifiedGeneIdSet() {
        return this.userSpecifiedGeneIdSet;
    }

    public void setUserSpecifiedGeneIdSet(Collection<String> userSpecifiedGeneIdSet) {
        this.userSpecifiedGeneIdSet = userSpecifiedGeneIdSet;
    }

    public void setUserGeneSet(Collection<String> userGeneSet) {
        this.userGeneSet = userGeneSet;
    }

    public Collection<String> getUserGeneSet() {
        return this.userGeneSet;
    }

    public Collection<String> getUnmatchedUserGeneIds() {
        return this.unmatchedUserGeneIds;
    }

    public void setUnmatchedUserGeneIds(Collection<String> unmatchedUserGeneIds) {
        this.unmatchedUserGeneIds = unmatchedUserGeneIds;
    }

    public void setGOSlimPanel(GOSlimPanel goSlimPanel) {
        this.goSlimPanel = goSlimPanel;
    }

    public GOSlimPanel getGOSlimPanel() {
        return this.goSlimPanel;
    }

    private String formatName(String name) {
        int curLength = 0;
        String newName = "";
        int maxSize = 15;
        Pattern pattern = Pattern.compile("[ \t\n\f\r]");
        Matcher matcher = pattern.matcher(name);
        int index = 0;
        while (matcher.find(index)) {
            String word = name.substring(index, matcher.start());
            String whiteSpace = name.substring(matcher.start(), matcher.end());
            if (curLength + word.length() + whiteSpace.length() < maxSize) {
                newName = newName + word + whiteSpace;
                curLength = curLength + word.length() + whiteSpace.length();
            } else if (curLength + word.length() < maxSize) {
                newName = newName + word + "\n";
                curLength = 0;
            } else {
                newName = newName + "\n" + word + whiteSpace;
                curLength = word.length() + whiteSpace.length();
            }
            index = matcher.end();
        }
        String lastWord = name.substring(index);
        newName = curLength + lastWord.length() > maxSize ? newName + "\n" + lastWord : newName + lastWord;
        return newName;
    }
}

