/*
 * Decompiled with CFR 0.152.
 */
package org.ccbr.bader.yeast.controller;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.task.TaskMonitor;
import cytoscape.view.CyNetworkView;
import giny.model.Node;
import giny.view.EdgeView;
import giny.view.NodeView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import org.ccbr.bader.yeast.GONamespace;
import org.ccbr.bader.yeast.GOSlimmerSession;
import org.ccbr.bader.yeast.GOSlimmerUtil;
import org.ccbr.bader.yeast.model.GOSlimmerCoverageStatBean;
import org.ccbr.bader.yeast.view.gui.GOSlimmerGUIViewSettings;
import org.ccbr.bader.yeast.view.gui.SelectedGOTermsPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GOSlimmerController {
    private CyNetwork network;
    private CyNetworkView networkView;
    private GOSlimmerCoverageStatBean statBean;
    private JLabel inferredCoverageStatisticViewLabel;
    private SelectedGOTermsPanel selectedGOTermsPanel;
    private Set<Node> visibleNodes;
    private Set<Integer> visibleEdges;
    private Set<Node> prunedNodes;
    private GONamespace namespace;
    private GOSlimmerSession session;
    private static final String lsep = System.getProperty("line.separator");
    private String collapseButtonText = "Collapse";
    private String expandButtonText = "Expand";
    private String pruneButtonText = "Prune";
    private String cancelButtonText = "Cancel";
    private boolean useFiniteExpansionDepth = false;
    private int nodeExpansionDepth = 1;
    private static final CyAttributes nodeAtt = Cytoscape.getNodeAttributes();
    DecimalFormat formatter = new DecimalFormat("00.00%");
    JLabel directCoverageStatisticViewLabel;
    private boolean displayUserGeneCoverageStatistics = false;

    public GOSlimmerController(GONamespace namespace, CyNetwork network, CyNetworkView networkView, GOSlimmerCoverageStatBean statBean, GOSlimmerSession session) {
        this.namespace = namespace;
        this.network = network;
        this.networkView = networkView;
        this.statBean = statBean;
        this.session = session;
        this.visibleNodes = new HashSet<Node>();
        this.visibleEdges = new HashSet<Integer>();
        this.prunedNodes = new HashSet<Node>();
    }

    public void collapseNode(Node snode) {
        HashSet<Object> nodesToIterate = new HashSet<Object>();
        HashSet<Node> nodesToIterateNextLevel = new HashSet<Node>();
        nodesToIterate.add(snode);
        while (!nodesToIterate.isEmpty()) {
            for (Node node : nodesToIterate) {
                int[] incomingEdges;
                for (int incomingEdge : incomingEdges = this.network.getAdjacentEdgeIndicesArray(node.getRootGraphIndex(), false, true, false)) {
                    int[] parentEdges;
                    this.hideEdge(incomingEdge);
                    Node childNode = this.network.getEdge(incomingEdge).getSource();
                    boolean hideNode = true;
                    for (int parentEdge : parentEdges = this.network.getAdjacentEdgeIndicesArray(childNode.getRootGraphIndex(), false, false, true)) {
                        if (!this.isVisibleEdge(parentEdge) || parentEdge == incomingEdge) continue;
                        hideNode = false;
                        break;
                    }
                    if (!hideNode) continue;
                    nodesToIterateNextLevel.add(childNode);
                    this.removeNodeFromSlimSet(childNode);
                    this.hideNode(childNode);
                }
            }
            nodesToIterate.clear();
            nodesToIterate.addAll(nodesToIterateNextLevel);
            nodesToIterateNextLevel.clear();
        }
    }

    public void pruneNode(Node snode) {
        int[] outgoingEdges;
        this.collapseNode(snode);
        this.removeNodeFromSlimSet(snode);
        this.hideNode(snode);
        for (int outgoingEdge : outgoingEdges = this.network.getAdjacentEdgeIndicesArray(snode.getRootGraphIndex(), false, false, true)) {
            this.hideEdge(outgoingEdge);
        }
        this.prunedNodes.add(snode);
    }

    public void expandNode(Node snode, boolean fullExpand) {
        if (this.useFiniteExpansionDepth) {
            this.expandNodeToDepth(snode, this.nodeExpansionDepth, fullExpand);
        } else {
            this.expandNodeToDepth(snode, Integer.MAX_VALUE, fullExpand);
        }
    }

    public void expandNodeToDepth(Node snode, int depth, boolean fullExpand) {
        if (depth <= 0) {
            return;
        }
        HashSet<Object> nodesToIterate = new HashSet<Object>();
        HashSet<Node> nodesToIterateNextLevel = new HashSet<Node>();
        int curDepth = depth;
        boolean expandNodesWithGenes = GOSlimmerGUIViewSettings.expandNodesWithGenes;
        ArrayList<NodeView> childNodeViews = new ArrayList<NodeView>();
        HashMap<NodeView, Dimension> nodeSizes = new HashMap<NodeView, Dimension>();
        Component component = this.networkView.getComponent();
        nodesToIterate.add(snode);
        while (!nodesToIterate.isEmpty() && curDepth > 0) {
            for (Node node : nodesToIterate) {
                int[] incomingEdges;
                double maxNodeHeight = 0.0;
                childNodeViews.clear();
                nodeSizes.clear();
                double maxXAlreadyVisible = Double.MIN_VALUE;
                for (int incomingEdge : incomingEdges = this.network.getAdjacentEdgeIndicesArray(node.getRootGraphIndex(), false, true, false)) {
                    Node childNode = this.network.getEdge(incomingEdge).getSource();
                    if (this.prunedNodes.contains(childNode)) {
                        if (!fullExpand) continue;
                        this.prunedNodes.remove(childNode);
                    }
                    if (nodeAtt.hasAttribute(childNode.getIdentifier(), "GOSlimmer.NUMBER_DIRECTLY_ANNOTATED_GENES")) {
                        int directGenes = nodeAtt.getIntegerAttribute(childNode.getIdentifier(), "GOSlimmer.NUMBER_DIRECTLY_ANNOTATED_GENES");
                        int inferredGenes = nodeAtt.getIntegerAttribute(childNode.getIdentifier(), "GOSlimmer.NUMBER_INFERRED_ANNOTATED_GENES");
                        if (expandNodesWithGenes && directGenes + inferredGenes == 0) continue;
                    }
                    this.showEdge(incomingEdge);
                    nodesToIterateNextLevel.add(childNode);
                    NodeView childNodeV = this.networkView.getNodeView(childNode.getRootGraphIndex());
                    FontMetrics metrics = component.getFontMetrics(childNodeV.getLabel().getFont());
                    String labelText = childNodeV.getLabel().getText();
                    String[] lines = labelText.split("\n");
                    int labelWidth = 0;
                    for (String line : lines) {
                        int length = metrics.stringWidth(line);
                        if (length <= labelWidth) continue;
                        labelWidth = length;
                    }
                    double totalWidth = Math.max((double)labelWidth, childNodeV.getWidth());
                    int labelHeight = metrics.getHeight() * lines.length;
                    double totalHeight = Math.max((double)labelHeight, childNodeV.getHeight());
                    if (!this.isVisibleNode(childNode)) {
                        this.showNode(childNode);
                        maxNodeHeight = Math.max(maxNodeHeight, totalHeight);
                        childNodeViews.add(childNodeV);
                        Dimension d = new Dimension();
                        d.setSize(totalWidth, totalHeight);
                        nodeSizes.put(childNodeV, d);
                        continue;
                    }
                    if (!(childNodeV.getXPosition() + totalWidth / 2.0 > maxXAlreadyVisible)) continue;
                    maxXAlreadyVisible = childNodeV.getXPosition() + totalWidth / 2.0;
                }
                this.layoutChildren(node, childNodeViews, nodeSizes, maxNodeHeight, maxXAlreadyVisible);
            }
            nodesToIterate.clear();
            nodesToIterate.addAll(nodesToIterateNextLevel);
            nodesToIterateNextLevel.clear();
            if (curDepth == Integer.MAX_VALUE) continue;
            --curDepth;
        }
    }

    public void layoutChildren(Node parent, List<NodeView> childNodeViews, HashMap<NodeView, Dimension> nodeSizes, double maxNodeHeight, double startX) {
        NodeView pView = this.networkView.getNodeView(parent);
        double x = pView.getXPosition();
        double y = pView.getYPosition();
        double h = pView.getHeight();
        double nodeSpacingX = 2.0;
        double nodeSpacingY = 5.0;
        double baseY = y + h / 2.0 + maxNodeHeight / 2.0 + nodeSpacingY;
        baseY = Math.max(baseY, y + 50.0);
        double lastCx = 0.0;
        double lastCw = 0.0;
        double lastCy = baseY;
        double lastCh = 0.0;
        double startLine = 0.0;
        double maxRightEdge = 0.0;
        HashMap<NodeView, Dimension> positions = new HashMap<NodeView, Dimension>();
        for (int i = 0; i < childNodeViews.size(); ++i) {
            double cx;
            double cy;
            NodeView childNodeV = childNodeViews.get(i);
            double cw = nodeSizes.get(childNodeV).getWidth();
            double ch = nodeSizes.get(childNodeV).getHeight();
            if (i % 5 == 0) {
                cy = baseY + ch / 2.0;
                cx = startLine + lastCw / 2.0 + cw / 2.0;
            } else {
                cy = lastCy + lastCh / 2.0 + nodeSpacingY + ch / 2.0;
                cx = lastCx + lastCw / 2.0 + nodeSpacingX + cw / 2.0;
            }
            double rightEdge = cx + cw / 2.0;
            if (rightEdge > maxRightEdge) {
                maxRightEdge = rightEdge;
            }
            Dimension pos = new Dimension();
            pos.setSize(cx, cy);
            positions.put(childNodeV, pos);
            lastCw = cw;
            lastCx = cx;
            lastCh = ch;
            lastCy = cy;
            if ((i % 5 + 1) % 3 != 0) continue;
            startLine = lastCx;
        }
        double totalChildWidth = maxRightEdge;
        double startPos = startX == Double.MIN_VALUE ? x - totalChildWidth / 2.0 : startX + nodeSpacingX;
        for (NodeView childV : positions.keySet()) {
            Dimension pos = (Dimension)positions.get(childV);
            childV.setXPosition(pos.getWidth() + startPos);
            childV.setYPosition(pos.getHeight());
        }
    }

    public void addNodeToSlimSet(Node node) {
        nodeAtt.setAttribute(node.getIdentifier(), "GOSlimmer.INSET", Boolean.valueOf(true));
        this.statBean.addToSlimSet(node);
        this.updateViewStatistics();
    }

    public void removeNodeFromSlimSet(Node node, TaskMonitor taskMonitor) {
        if (this.statBean.getSlimGoNodes().contains(node)) {
            nodeAtt.setAttribute(node.getIdentifier(), "GOSlimmer.INSET", Boolean.valueOf(false));
            this.statBean.removeFromSlimSet(node, taskMonitor);
            this.updateViewStatistics();
        }
    }

    public void removeNodeFromSlimSet(Node node) {
        this.removeNodeFromSlimSet(node, null);
    }

    private void updateViewStatistics() {
        double directCoverage;
        double inferredCoverage = this.displayUserGeneCoverageStatistics ? this.statBean.fractionInferredCoveredUserGenes() : this.statBean.fractionInferredCovered();
        double d = directCoverage = this.displayUserGeneCoverageStatistics ? this.statBean.fractionDirectlyCoveredUserGenes() : this.statBean.fractionDirectlyCovered();
        if (this.inferredCoverageStatisticViewLabel != null) {
            this.inferredCoverageStatisticViewLabel.setText("Inferred Coverage: " + this.formatter.format(inferredCoverage));
        }
        if (this.directCoverageStatisticViewLabel != null) {
            this.directCoverageStatisticViewLabel.setText("Direct Coverage: " + this.formatter.format(directCoverage));
        }
        if (this.selectedGOTermsPanel != null) {
            String[] listGOTerms = this.statBean.getListSelectedGONodes();
            this.selectedGOTermsPanel.setList(listGOTerms);
        }
    }

    public GOSlimmerCoverageStatBean getStatBean() {
        return this.statBean;
    }

    public void setStatBean(GOSlimmerCoverageStatBean statBean) {
        this.statBean = statBean;
    }

    public CyNetwork getNetwork() {
        return this.network;
    }

    public void setNetwork(CyNetwork network) {
        this.network = network;
    }

    public CyNetworkView getNetworkView() {
        return this.networkView;
    }

    public void setNetworkView(CyNetworkView networkView) {
        this.networkView = networkView;
    }

    public JLabel getInferredCoverageStatisticViewLabel() {
        return this.inferredCoverageStatisticViewLabel;
    }

    public void setInferredCoverageStatisticViewLabel(JLabel coverageStatisticViewLabel) {
        this.inferredCoverageStatisticViewLabel = coverageStatisticViewLabel;
    }

    public JLabel getDirectCoverageStatisticViewLabel() {
        return this.directCoverageStatisticViewLabel;
    }

    public void setDirectCoverageStatisticViewLabel(JLabel directCoverageStatisticViewLabel) {
        this.directCoverageStatisticViewLabel = directCoverageStatisticViewLabel;
    }

    public SelectedGOTermsPanel getSelectedGOTermsPanel() {
        return this.selectedGOTermsPanel;
    }

    public void setSelectedGOTermsPanel(SelectedGOTermsPanel selectedGOTermsPanel) {
        this.selectedGOTermsPanel = selectedGOTermsPanel;
    }

    public void removeCoverageAttributes() {
        Iterator nodeI = this.network.nodesIterator();
        boolean daganAttDefined = false;
        boolean iaganAttDefined = false;
        if (nodeAtt.getMultiHashMapDefinition().getAttributeValueType("GOSlimmer.DIRECTLY_ANNOTATED_GENES") > 0) {
            daganAttDefined = true;
        }
        if (nodeAtt.getMultiHashMapDefinition().getAttributeValueType("GOSlimmer.INFERRED_ANNOTATED_GENES") > 0) {
            iaganAttDefined = true;
        }
        while (nodeI.hasNext()) {
            Node node = (Node)nodeI.next();
            if (daganAttDefined) {
                nodeAtt.deleteAttribute(node.getIdentifier(), "GOSlimmer.DIRECTLY_ANNOTATED_GENES");
            }
            if (!iaganAttDefined) continue;
            nodeAtt.deleteAttribute(node.getIdentifier(), "GOSlimmer.INFERRED_ANNOTATED_GENES");
        }
    }

    public void assignCoverageAttributesToNetworks(Map<String, List<String>> goIdToGeneIdMap) {
        Node node;
        Iterator nodeI = this.network.nodesIterator();
        while (nodeI.hasNext()) {
            node = (Node)nodeI.next();
            String nodeGoId = node.getIdentifier();
            List<String> nodeAnnotatedGeneIds = goIdToGeneIdMap.get(nodeGoId);
            if (nodeAnnotatedGeneIds == null || nodeAnnotatedGeneIds.size() <= 0) continue;
            nodeAtt.setListAttribute(nodeGoId, "GOSlimmer.DIRECTLY_ANNOTATED_GENES", nodeAnnotatedGeneIds);
        }
        nodeI = this.network.nodesIterator();
        while (nodeI.hasNext()) {
            node = (Node)nodeI.next();
            List inferredCoveredGenesL = nodeAtt.getListAttribute(node.getIdentifier(), "GOSlimmer.INFERRED_ANNOTATED_GENES");
            if (inferredCoveredGenesL != null && inferredCoveredGenesL.size() != 0) continue;
            Set<String> inferredCoveredGenesS = GOSlimmerUtil.getGenesCoveredByChildren(node, this.network);
            nodeAtt.setListAttribute(node.getIdentifier(), "GOSlimmer.INFERRED_ANNOTATED_GENES", GOSlimmerUtil.setToList(inferredCoveredGenesS));
        }
    }

    private void assignCoverageAttributesToNetworks(Map<String, List<String>> goIdToAttValMap, String directCoverageAttributeName, String inferredCoverageAttributeName) {
        Node node;
        Iterator nodeI = this.network.nodesIterator();
        while (nodeI.hasNext()) {
            node = (Node)nodeI.next();
            String nodeGoId = node.getIdentifier();
            List<String> nodeAnnotatedGeneIds = goIdToAttValMap.get(nodeGoId);
            if (nodeAnnotatedGeneIds == null || nodeAnnotatedGeneIds.size() <= 0) continue;
            nodeAtt.setListAttribute(nodeGoId, directCoverageAttributeName, nodeAnnotatedGeneIds);
        }
        nodeI = this.network.nodesIterator();
        while (nodeI.hasNext()) {
            node = (Node)nodeI.next();
            List inferredCoveredGenesL = nodeAtt.getListAttribute(node.getIdentifier(), inferredCoverageAttributeName);
            if (inferredCoveredGenesL != null && inferredCoveredGenesL.size() != 0) continue;
            Set<String> inferredCoveredGenesS = GOSlimmerUtil.getGenesCoveredByChildren(node, this.network, directCoverageAttributeName, inferredCoverageAttributeName);
            nodeAtt.setListAttribute(node.getIdentifier(), inferredCoverageAttributeName, GOSlimmerUtil.setToList(inferredCoveredGenesS));
        }
    }

    private void assignCoverageAttributesToNetworks(Map<String, List<String>> goIdToAttValMap, String directCoverageAttributeName, String inferredCoverageAttributeName, String directNumberAttributeName, String inferredNumberAttributeName) {
        String nodeGoId;
        Node node;
        Iterator nodeI = this.network.nodesIterator();
        while (nodeI.hasNext()) {
            node = (Node)nodeI.next();
            nodeGoId = node.getIdentifier();
            List<String> nodeAnnotatedGeneIds = goIdToAttValMap.get(nodeGoId);
            if (nodeAnnotatedGeneIds != null && nodeAnnotatedGeneIds.size() > 0) {
                nodeAtt.setListAttribute(nodeGoId, directCoverageAttributeName, nodeAnnotatedGeneIds);
                if (directNumberAttributeName == null || directNumberAttributeName.equals("")) continue;
                nodeAtt.setAttribute(nodeGoId, directNumberAttributeName, Integer.valueOf(nodeAnnotatedGeneIds.size()));
                continue;
            }
            if (directNumberAttributeName == null || directNumberAttributeName.equals("")) continue;
            nodeAtt.setAttribute(nodeGoId, directNumberAttributeName, Integer.valueOf(0));
        }
        nodeI = this.network.nodesIterator();
        while (nodeI.hasNext()) {
            node = (Node)nodeI.next();
            nodeGoId = node.getIdentifier();
            List inferredCoveredGenesL = nodeAtt.getListAttribute(node.getIdentifier(), inferredCoverageAttributeName);
            if (inferredCoveredGenesL == null || inferredCoveredGenesL.size() == 0) {
                Set<String> inferredCoveredGenesS = GOSlimmerUtil.getGenesCoveredByChildren(node, this.network, directCoverageAttributeName, inferredCoverageAttributeName);
                nodeAtt.setListAttribute(nodeGoId, inferredCoverageAttributeName, GOSlimmerUtil.setToList(inferredCoveredGenesS));
                if (inferredNumberAttributeName == null || inferredNumberAttributeName.equals("")) continue;
                nodeAtt.setAttribute(nodeGoId, inferredNumberAttributeName, Integer.valueOf(inferredCoveredGenesS.size()));
                continue;
            }
            if (inferredNumberAttributeName == null || inferredNumberAttributeName.equals("") || nodeAtt.hasAttribute(nodeGoId, inferredNumberAttributeName)) continue;
            nodeAtt.setAttribute(nodeGoId, inferredNumberAttributeName, Integer.valueOf(inferredCoveredGenesL.size()));
        }
    }

    public void resetAndRecalculateStatisticsBean(int maxGeneSetSize) {
        this.statBean = new GOSlimmerCoverageStatBean(maxGeneSetSize, this.session);
        Iterator nodeI = this.network.nodesIterator();
        while (nodeI.hasNext()) {
            Node node = (Node)nodeI.next();
            Boolean isInSlimSet = nodeAtt.getBooleanAttribute(node.getIdentifier(), "GOSlimmer.INSET");
            if (isInSlimSet != null && isInSlimSet.booleanValue()) {
                this.statBean.addToSlimSet(node);
            }
            if (!GOSlimmerUtil.areUserGeneAttributesDefined()) continue;
            GOSlimmerUtil.removeUserGeneAttributes(node);
        }
        this.updateViewStatistics();
    }

    public int getExpansionDepth() {
        return this.nodeExpansionDepth;
    }

    public void setExpansionDepth(int newExpansionDepth) {
        this.nodeExpansionDepth = newExpansionDepth;
    }

    public boolean isDisplayUserGeneCoverageStatistics() {
        return this.displayUserGeneCoverageStatistics;
    }

    public void setDisplayUserGeneCoverageStatistics(boolean displayUserGeneCoverageStatistics) {
        this.displayUserGeneCoverageStatistics = displayUserGeneCoverageStatistics;
        this.updateViewStatistics();
    }

    public void setUseFiniteExpansionDepth(boolean useFiniteExpansionDepth) {
        this.useFiniteExpansionDepth = useFiniteExpansionDepth;
    }

    public void attachInferredAnnotatedUserGenesToTerms(Collection<String> geneIds) {
        Iterator nodeI = this.network.nodesIterator();
        while (nodeI.hasNext()) {
            Node node = (Node)nodeI.next();
            List inferredCoveredGenesL = nodeAtt.getListAttribute(node.getIdentifier(), "GOSlimmer.INFERRED_ANNOTATED_USER_GENES");
            if (inferredCoveredGenesL != null && inferredCoveredGenesL.size() != 0) continue;
            Set<String> inferredCoveredGenesS = GOSlimmerUtil.getGenesCoveredByChildren(node, this.network, true);
            nodeAtt.setListAttribute(node.getIdentifier(), "GOSlimmer.INFERRED_ANNOTATED_USER_GENES", GOSlimmerUtil.setToList(inferredCoveredGenesS));
        }
    }

    public void attachDirectlyAnnotatedUserGenesToTerms(Collection<String> geneIds) {
        Iterator nodeI = this.network.nodesIterator();
        while (nodeI.hasNext()) {
            Node node = (Node)nodeI.next();
            List<String> directlyCoveredGenesAndSynonyms = GOSlimmerUtil.getDirectlyCoveredGenes(node);
            directlyCoveredGenesAndSynonyms.addAll(GOSlimmerUtil.getDirectlyCoveredGeneSynonyms(node));
            ArrayList<String> matchingIds = new ArrayList<String>(geneIds);
            matchingIds.retainAll(directlyCoveredGenesAndSynonyms);
            nodeAtt.setListAttribute(node.getIdentifier(), "GOSlimmer.DIRECTLY_ANNOTATED_USER_GENES", matchingIds);
        }
    }

    public Collection<String> applyUserGeneSet(Collection<String> userGeneSet) {
        this.session.setUserGeneSet(userGeneSet);
        this.attachDirectlyAnnotatedUserGenesToTerms(userGeneSet);
        this.attachInferredAnnotatedUserGenesToTerms(userGeneSet);
        HashSet<String> matchedIds = new HashSet<String>();
        matchedIds.addAll(GOSlimmerUtil.getGenesCoveredByGoNode(GOSlimmerUtil.getRootNode(this.network), true, true));
        return matchedIds;
    }

    public void setupUserGeneStatistics(int newUserGeneCount) {
        this.statBean.setupUserGeneStatistics(newUserGeneCount);
        this.updateViewStatistics();
    }

    public void assignGeneSynonymCoverageAttributesToNetworks(Map<String, List<String>> goIdToGeneSynonymMap) {
        this.assignCoverageAttributesToNetworks(goIdToGeneSynonymMap, "GOSlimmer.DIRECTLY_ANNOTATED_GENE_SYNONYMS", "GOSlimmer.INFERRED_ANNOTATED_GENE_SYNONYMS", null, null);
    }

    public void assignGeneIdCoverageAttributesToNetworks(Map<String, List<String>> goIdToGeneIdMap) {
        this.assignCoverageAttributesToNetworks(goIdToGeneIdMap, "GOSlimmer.DIRECTLY_ANNOTATED_GENES", "GOSlimmer.INFERRED_ANNOTATED_GENES", "GOSlimmer.NUMBER_DIRECTLY_ANNOTATED_GENES", "GOSlimmer.NUMBER_INFERRED_ANNOTATED_GENES");
    }

    public GONamespace getNamespace() {
        return this.namespace;
    }

    public boolean appendSlimSetList(File exportFile) throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(exportFile, true));
        for (Node slimNode : this.statBean.getSlimGoNodes()) {
            String name = nodeAtt.getStringAttribute(slimNode.getIdentifier(), "ontology.name");
            out.write(slimNode.getIdentifier() + "\t" + name + lsep);
        }
        out.close();
        return true;
    }

    public boolean isVisibleNode(Node node) {
        return this.visibleNodes.contains(node);
    }

    public boolean isVisibleEdge(int edge) {
        return this.visibleEdges.contains(edge);
    }

    public void hideNode(Node node) {
        NodeView nodeView = this.networkView.getNodeView(node);
        this.networkView.hideGraphObject((Object)nodeView);
        this.visibleNodes.remove(node);
    }

    public void showNode(Node node) {
        NodeView nodeView = this.networkView.getNodeView(node);
        this.networkView.showGraphObject((Object)nodeView);
        this.visibleNodes.add(node);
    }

    public void hideEdge(int edge) {
        EdgeView edgeView = this.networkView.getEdgeView(edge);
        this.networkView.hideGraphObject((Object)edgeView);
        this.visibleEdges.remove(edge);
    }

    public void showEdge(int edge) {
        EdgeView edgeView = this.networkView.getEdgeView(edge);
        this.networkView.showGraphObject((Object)edgeView);
        this.visibleEdges.add(edge);
    }

    public void displayNode(Node node) {
        HashMap<Node, Set<Node>> parentChildList = new HashMap<Node, Set<Node>>();
        Set<List<Node>> allLines = this.getParentLines(node, parentChildList);
        for (List<Node> line : allLines) {
            for (int i = 1; i < line.size(); ++i) {
                int[] edges;
                Node childNode = line.get(i);
                Node parentNode = line.get(i - 1);
                if (!this.isVisibleNode(childNode)) {
                    FontMetrics metrics;
                    double maxXAlreadyVisible = Double.MIN_VALUE;
                    Component component = this.networkView.getComponent();
                    if (i == 1) {
                        int[] incomingEdges;
                        for (int incomingEdge : incomingEdges = this.network.getAdjacentEdgeIndicesArray(parentNode.getRootGraphIndex(), false, true, false)) {
                            EdgeView ev = this.networkView.getEdgeView(incomingEdge);
                            Node child = ev.getEdge().getSource();
                            if (!this.isVisibleNode(child)) continue;
                            NodeView cNodeView = this.networkView.getNodeView(child);
                            metrics = component.getFontMetrics(cNodeView.getLabel().getFont());
                            String labelText = cNodeView.getLabel().getText();
                            String[] textLines = labelText.split("\n");
                            int labelWidth = 0;
                            for (String textLine : textLines) {
                                int length = metrics.stringWidth(textLine);
                                if (length <= labelWidth) continue;
                                labelWidth = length;
                            }
                            double totalWidth = Math.max((double)labelWidth, cNodeView.getWidth());
                            if (!(cNodeView.getXPosition() + totalWidth / 2.0 > maxXAlreadyVisible)) continue;
                            maxXAlreadyVisible = cNodeView.getXPosition() + totalWidth / 2.0;
                        }
                    }
                    Set<Node> childrenToDraw = parentChildList.get(parentNode);
                    double maxNodeHeight = 0.0;
                    ArrayList<NodeView> childNodeViews = new ArrayList<NodeView>();
                    HashMap<NodeView, Dimension> nodeSizes = new HashMap<NodeView, Dimension>();
                    for (Node thisChild : childrenToDraw) {
                        int[] edges2;
                        NodeView cView = this.networkView.getNodeView(thisChild);
                        this.showNode(thisChild);
                        int[] nodesToConnect = new int[]{thisChild.getRootGraphIndex(), parentNode.getRootGraphIndex()};
                        for (int edge : edges2 = this.network.getConnectingEdgeIndicesArray(nodesToConnect)) {
                            this.showEdge(edge);
                        }
                        metrics = component.getFontMetrics(cView.getLabel().getFont());
                        String labelText = cView.getLabel().getText();
                        String[] textLines = labelText.split("\n");
                        int labelWidth = 0;
                        for (String textLine : textLines) {
                            int length = metrics.stringWidth(textLine);
                            if (length <= labelWidth) continue;
                            labelWidth = length;
                        }
                        double totalWidth = Math.max((double)labelWidth, cView.getWidth());
                        int labelHeight = metrics.getHeight() * textLines.length;
                        double totalHeight = Math.max((double)labelHeight, cView.getHeight());
                        maxNodeHeight = Math.max(maxNodeHeight, totalHeight);
                        childNodeViews.add(cView);
                        Dimension d = new Dimension();
                        d.setSize(totalWidth, totalHeight);
                        nodeSizes.put(cView, d);
                    }
                    this.layoutChildren(parentNode, childNodeViews, nodeSizes, maxNodeHeight, maxXAlreadyVisible);
                    continue;
                }
                int[] nodesToConnect = new int[]{childNode.getRootGraphIndex(), parentNode.getRootGraphIndex()};
                for (int edge : edges = this.network.getConnectingEdgeIndicesArray(nodesToConnect)) {
                    this.showEdge(edge);
                }
            }
        }
    }

    private Set<List<Node>> getParentLines(Node node, HashMap<Node, Set<Node>> parentChildList) {
        int[] outgoingEdges;
        HashSet<List<Node>> allpaths = new HashSet<List<Node>>();
        if (this.isVisibleNode(node)) {
            return allpaths;
        }
        for (int outgoingEdge : outgoingEdges = this.network.getAdjacentEdgeIndicesArray(node.getRootGraphIndex(), false, false, true)) {
            Set<List<Node>> parentLines;
            EdgeView ev = this.networkView.getEdgeView(outgoingEdge);
            Node parentNode = ev.getEdge().getTarget();
            if (parentChildList.containsKey(parentNode)) {
                parentChildList.get(parentNode).add(node);
            } else {
                HashSet<Node> childSet = new HashSet<Node>();
                childSet.add(node);
                parentChildList.put(parentNode, childSet);
            }
            if (!this.isVisibleNode(parentNode)) {
                parentLines = this.getParentLines(parentNode, parentChildList);
            } else {
                ArrayList<Node> singleList = new ArrayList<Node>();
                singleList.add(parentNode);
                parentLines = new HashSet<List<Node>>();
                parentLines.add(singleList);
            }
            for (List<Node> thisList : parentLines) {
                thisList.add(node);
                allpaths.add(thisList);
            }
        }
        return allpaths;
    }
}

