/*
 * Decompiled with CFR 0.152.
 */
package org.ccbr.bader.yeast.export;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.ccbr.bader.yeast.GONamespace;
import org.ccbr.bader.yeast.export.GOFormatException;
import org.ccbr.bader.yeast.export.OBOFormatException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GOOBOWriter {
    private static final String lsep = System.getProperty("line.separator");
    private BufferedWriter w;
    boolean headerIsWriten = false;

    public GOOBOWriter(BufferedWriter writer) {
        this.w = writer;
    }

    public void writeGOTermEntry(GOTermEntry entry) throws OBOFormatException, GOFormatException, IOException {
        GOTermEntry e = entry;
        if (entry.getId() == null) {
            throw new OBOFormatException("ID cannot be null");
        }
        if (entry.getNamespace() == null) {
            throw new GOFormatException("Namespace cannot be null");
        }
        if (!(entry.getIs_a() != null && entry.getIs_a().size() != 0 || entry.getPart_of_relationship() != null && entry.getPart_of_relationship().size() != 0 || entry.getId().equals(entry.getNamespace().getRootTermId()))) {
            throw new GOFormatException("Term '" + entry.getId() + "' has no parents, but is not equal to the root term for it's namespace '" + entry.getNamespace().getName() + "'");
        }
        this.w.write("[TERM]");
        this.w.write(lsep);
        this.w.write("id: " + e.id + lsep);
        if (e.id_is_anonymous) {
            this.w.write("is_anonymous: true" + lsep);
        }
        if (e.name != null) {
            this.w.write("name: " + e.name + lsep);
        }
        this.w.write("namespace: " + (Object)((Object)e.ns) + lsep);
        if (e.alt_id != null) {
            for (String alt_id : e.alt_id) {
                this.w.write("alt_id: " + alt_id + lsep);
            }
        }
        if (e.def != null) {
            this.w.write("def: " + e.def + lsep);
        }
        if (e.subset != null) {
            this.w.write("subset: " + e.subset + lsep);
        }
        if (e.synonym != null) {
            this.w.write("synonym: " + e.synonym + lsep);
        }
        this.writeTag("xref", e.xref);
        this.writeTag("is_a", e.is_a);
        if (e.is_obsolete) {
            this.writeTag("is_obsolete", "true");
        }
        if (e.part_of_relationship != null) {
            for (String part_of : e.part_of_relationship) {
                this.w.write("relationship: part_of " + part_of + lsep);
            }
        }
    }

    private void writeTag(String termName, String termValue) throws IOException {
        if (termValue != null) {
            StringBuffer buf = new StringBuffer(termName);
            buf.append(":");
            buf.append(termValue);
            buf.append(lsep);
            this.w.write(buf.toString());
        }
    }

    private void writeTag(String termName, List<String> termValues) throws IOException {
        if (termValues != null) {
            for (String termValue : termValues) {
                this.w.write(termName + ":" + termValue + lsep);
            }
        }
    }

    public class GOOBOHeader {
        String format_version;
        String data_version;
        String date;
        String saved_by;
        String auto_generated_by;
        String subsetdef;
        String import_url;
        String synonymtypedef;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class GOTermEntry {
        private String name;
        String id;
        GONamespace ns;
        boolean id_is_anonymous = false;
        List<String> alt_id = new ArrayList<String>();
        String def;
        List<String> is_a = new ArrayList<String>();
        String synonym;
        String subset;
        List<String> xref = new ArrayList<String>();
        List<String> part_of_relationship = new ArrayList<String>();
        boolean is_obsolete;

        public List<String> getAlt_id() {
            return this.alt_id;
        }

        public void setAlt_id(List<String> alt_id) {
            this.alt_id = alt_id;
        }

        public void addAlt_id(String alt_id) {
            this.alt_id.add(alt_id);
        }

        public String getDef() {
            return this.def;
        }

        public void setDef(String def) {
            this.def = def;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public boolean isId_is_anonymous() {
            return this.id_is_anonymous;
        }

        public void setId_is_anonymous(boolean id_is_anonymous) {
            this.id_is_anonymous = id_is_anonymous;
        }

        public List<String> getIs_a() {
            return this.is_a;
        }

        public void setIs_a(List<String> is_a) {
            this.is_a = is_a;
        }

        public void addIs_a(String is_a_id) {
            this.is_a.add(is_a_id);
        }

        public boolean isIs_obsolete() {
            return this.is_obsolete;
        }

        public void setIs_obsolete(boolean is_obsolete) {
            this.is_obsolete = is_obsolete;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public GONamespace getNamespace() {
            return this.ns;
        }

        public void setNamespace(GONamespace ns) {
            this.ns = ns;
        }

        public String getSubset() {
            return this.subset;
        }

        public void setSubset(String subset) {
            this.subset = subset;
        }

        public String getSynonym() {
            return this.synonym;
        }

        public void setSynonym(String synonym) {
            this.synonym = synonym;
        }

        public List<String> getXref() {
            return this.xref;
        }

        public void setXref(List<String> xref) {
            this.xref = xref;
        }

        public void addXref(String xref) {
            this.xref.add(xref);
        }

        public List<String> getPart_of_relationship() {
            return this.part_of_relationship;
        }

        public void setPart_of_relationship(List<String> part_of_relationship) {
            this.part_of_relationship = part_of_relationship;
        }

        public void addPart_of_relationship(String part_of_relation_id) {
            this.part_of_relationship.add(part_of_relation_id);
        }
    }
}

