/*
 * Decompiled with CFR 0.152.
 */
package org.ccbr.bader.yeast.view.gui;

import cytoscape.Cytoscape;
import ding.view.DGraphView;
import giny.model.Edge;
import giny.model.Node;
import giny.view.NodeView;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.ccbr.bader.yeast.controller.GOSlimmerController;

public class ExpandedState {
    protected Map<Node, Point2D.Double> points;
    protected Map<Node, Boolean> visibleNodes;
    protected Map<Integer, Boolean> visibleEdges;
    protected Map<Node, Boolean> selected;
    protected DGraphView view;
    protected GOSlimmerController controller;

    public ExpandedState(GOSlimmerController controller) {
        this.controller = controller;
        this.view = (DGraphView)controller.getNetworkView();
        this.points = new HashMap<Node, Point2D.Double>();
        this.visibleNodes = new HashMap<Node, Boolean>();
        this.visibleEdges = new HashMap<Integer, Boolean>();
        this.selected = new HashMap<Node, Boolean>();
        this.points.clear();
        this.visibleNodes.clear();
        this.visibleEdges.clear();
        this.selected.clear();
        Set<Node> selectedNodes = controller.getStatBean().getSlimGoNodes();
        Iterator nodes_i = controller.getNetwork().nodesIterator();
        while (nodes_i.hasNext()) {
            Node node = (Node)nodes_i.next();
            NodeView nv = this.view.getNodeView(node);
            this.points.put(node, new Point2D.Double(nv.getXPosition(), nv.getYPosition()));
            this.visibleNodes.put(node, controller.isVisibleNode(node));
            this.selected.put(node, selectedNodes.contains(node));
        }
        Iterator edges_i = controller.getNetwork().edgesIterator();
        while (edges_i.hasNext()) {
            Edge edge = (Edge)edges_i.next();
            int edgeIndex = edge.getRootGraphIndex();
            this.visibleEdges.put(edgeIndex, controller.isVisibleEdge(edgeIndex));
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof ExpandedState)) {
            return false;
        }
        ExpandedState es = (ExpandedState)o;
        if (this.view != es.view) {
            return false;
        }
        Iterator nodes_i = this.controller.getNetwork().nodesIterator();
        while (nodes_i.hasNext()) {
            Node node = (Node)nodes_i.next();
            if (!this.points.get(node).equals(es.points.get(node))) {
                return false;
            }
            if (!this.visibleNodes.get(node).equals(es.visibleNodes.get(node))) {
                return false;
            }
            if (this.selected.get(node).equals(es.selected.get(node))) continue;
            return false;
        }
        Iterator edges_i = this.controller.getNetwork().edgesIterator();
        while (edges_i.hasNext()) {
            Edge edge = (Edge)edges_i.next();
            int edgeIndex = edge.getRootGraphIndex();
            if (this.visibleEdges.get(edgeIndex).equals(es.visibleEdges.get(edgeIndex))) continue;
            return false;
        }
        return true;
    }

    public void apply() {
        Set<Node> selectedNodes = this.controller.getStatBean().getSlimGoNodes();
        Iterator nodes_i = this.controller.getNetwork().nodesIterator();
        while (nodes_i.hasNext()) {
            Node node = (Node)nodes_i.next();
            NodeView nv = this.view.getNodeView(node);
            if (this.visibleNodes.get(node).booleanValue()) {
                this.controller.showNode(node);
                Point2D.Double p = this.points.get(node);
                nv.setXPosition(p.getX());
                nv.setYPosition(p.getY());
            } else {
                this.controller.hideNode(node);
            }
            if (this.selected.get(node).booleanValue()) {
                if (selectedNodes.contains(node)) continue;
                this.controller.addNodeToSlimSet(node);
                continue;
            }
            if (!selectedNodes.contains(node)) continue;
            this.controller.removeNodeFromSlimSet(node);
        }
        Iterator edges_i = this.controller.getNetwork().edgesIterator();
        while (edges_i.hasNext()) {
            Edge edge = (Edge)edges_i.next();
            int edgeIndex = edge.getRootGraphIndex();
            if (this.visibleEdges.get(edgeIndex).booleanValue()) {
                this.controller.showEdge(edgeIndex);
                continue;
            }
            this.controller.hideEdge(edgeIndex);
        }
        Cytoscape.getCurrentNetworkView().redrawGraph(false, false);
    }
}

