/*
 * Decompiled with CFR 0.152.
 */
package org.ccbr.bader.yeast.view.gui;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import cytoscape.task.util.TaskManager;
import cytoscape.view.CyNetworkView;
import giny.model.Node;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.ccbr.bader.geneassociation.GeneAssociationReaderUtil;
import org.ccbr.bader.yeast.GOSlimmerException;
import org.ccbr.bader.yeast.GOSlimmerSession;
import org.ccbr.bader.yeast.GOSlimmerUtil;
import org.ccbr.bader.yeast.controller.GOSlimmerController;
import org.ccbr.bader.yeast.export.GeneAnnotationRemapWriter;
import org.ccbr.bader.yeast.export.RootNodeNotSelectedException;
import org.ccbr.bader.yeast.view.gui.misc.JButtonMod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileExportPanel
extends JPanel
implements ActionListener {
    private Collection<GOSlimmerController> controllers;
    private GOSlimmerSession session;
    private static final String lsep = System.getProperty("line.separator");
    JButton exportAnnotationFileButton;
    private static final String exportAnnotationFileButtonText = "Export Remapped Gene Association File";
    private static final String exportAnnotationFileButtonToolTip = "A new version of the imported gene annotation file will be " + lsep + " created where the GO Terms for unselected entries will be " + lsep + "remapped to ancestor terms which were selected.  Note that " + lsep + "only terms which exist within this GO tree will be exported" + lsep + "or remapped;  all others will be ommitted from the output.";
    JButton exportSlimSetFileButton;
    private static final String exportSlimSetFileButtonText = "Export Slim Set Term List File";
    private static final String exportSlimSetFileButtonToolTip = "Create a file containing a newline delimited list of your  " + lsep + "selected GO Slim Set terms.";
    JButton importSlimSetFileButton;
    private static final String importSlimSetFileButtonText = "Import Slim Set Term List File";
    private static final String importSlimSetFileButtonToolTip = "Import a file containing a newline delimited list of your  " + lsep + "selected GO Slim Set terms.";

    public FileExportPanel(Collection<GOSlimmerController> controllers, GOSlimmerSession session) {
        this.initComponents();
        this.controllers = controllers;
        this.session = session;
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createTitledBorder("Import/Export"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.getExportAnnotationFileButton(), c);
        c.gridx = 0;
        c.gridy = 1;
        this.add((Component)this.getExportSlimSetFileButton(), c);
        c.gridx = 0;
        c.gridy = 2;
        this.add((Component)this.getImportSlimSetFileButton(), c);
    }

    private JButton getExportAnnotationFileButton() {
        if (this.exportAnnotationFileButton == null) {
            this.exportAnnotationFileButton = new JButtonMod(exportAnnotationFileButtonText);
            this.exportAnnotationFileButton.addActionListener(this);
            this.exportAnnotationFileButton.setToolTipText(exportAnnotationFileButtonToolTip);
        }
        return this.exportAnnotationFileButton;
    }

    private JButton getExportSlimSetFileButton() {
        if (this.exportSlimSetFileButton == null) {
            this.exportSlimSetFileButton = new JButtonMod(exportSlimSetFileButtonText);
            this.exportSlimSetFileButton.addActionListener(this);
            this.exportSlimSetFileButton.setToolTipText(exportSlimSetFileButtonToolTip);
        }
        return this.exportSlimSetFileButton;
    }

    private JButton getImportSlimSetFileButton() {
        if (this.importSlimSetFileButton == null) {
            this.importSlimSetFileButton = new JButtonMod(importSlimSetFileButtonText);
            this.importSlimSetFileButton.addActionListener(this);
            this.importSlimSetFileButton.setToolTipText(importSlimSetFileButtonToolTip);
        }
        return this.importSlimSetFileButton;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src instanceof JButton) {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(0);
            if (src == this.importSlimSetFileButton) {
                int retval = chooser.showOpenDialog(this);
                if (retval == 0) {
                    final File slimSetFile = chooser.getSelectedFile();
                    TaskManager.executeTask((Task)new Task(){
                        private TaskMonitor taskMonitor = null;

                        public String getTitle() {
                            return "Importing slim set term list file and building slim set";
                        }

                        public void halt() {
                        }

                        public void run() {
                            try {
                                Collection goTermIds = FileExportPanel.this.parseSlimSetFile(slimSetFile);
                                FileExportPanel.this.buildSlimSet(goTermIds);
                            }
                            catch (FileNotFoundException e) {
                                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "Failed to import slim set;  Could not find specified file", "Error", 0);
                                return;
                            }
                            catch (IOException e) {
                                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "Failed to import slim Set;  Error while reading file", "Error", 0);
                                e.printStackTrace();
                                return;
                            }
                            catch (RuntimeException e) {
                                this.taskMonitor.setException((Throwable)e, e.getMessage());
                                return;
                            }
                        }

                        public void setTaskMonitor(TaskMonitor taskMonitor) throws IllegalThreadStateException {
                            this.taskMonitor = taskMonitor;
                        }
                    }, null);
                }
            } else {
                int retval = chooser.showSaveDialog(this);
                if (retval == 0) {
                    File exportFile = chooser.getSelectedFile();
                    if (src == this.exportAnnotationFileButton) {
                        int appendName;
                        if (!exportFile.getName().startsWith("gene_association") && (appendName = JOptionPane.showConfirmDialog(this, "For this file to be re-imported as a gene annotation file" + lsep + "the file name must begin with 'gene_association'." + lsep + "Would you like to prefix your file name by 'gene_association'?", "Confirm File Name", 0)) == 0) {
                            exportFile = new File(exportFile.getParentFile(), "gene_association_" + exportFile.getName());
                        }
                        HashMap<String, Set<String>> goTermRemap = new HashMap<String, Set<String>>();
                        for (GOSlimmerController controller : this.controllers) {
                            try {
                                try {
                                    goTermRemap.putAll(GOSlimmerUtil.createGoTermMultipleRemap(controller.getNetwork()));
                                }
                                catch (RootNodeNotSelectedException e) {
                                    int rv = JOptionPane.showConfirmDialog(this, "Root node of GO namespace " + controller.getNamespace().getName() + " must be included in slim set for export.  Include root node and continue?", "Warning:  root term not selected", 0);
                                    if (rv == 0) {
                                        controller.addNodeToSlimSet(GOSlimmerUtil.getRootNode(controller.getNetwork()));
                                        goTermRemap.putAll(GOSlimmerUtil.createGoTermMultipleRemap(controller.getNetwork()));
                                        continue;
                                    }
                                    JOptionPane.showMessageDialog(this, "File export has been aborted");
                                    break;
                                }
                            }
                            catch (GOSlimmerException e) {
                                JOptionPane.showMessageDialog(this, "Failed to remap terms due to exception: " + e.getMessage(), "Error", 0);
                                return;
                            }
                        }
                        try {
                            if (this.session.getGaru() == null) {
                                JOptionPane.showMessageDialog(this, "You must load an annotation file first", "Error", 0);
                                return;
                            }
                            this.createRemappedGeneAnnotationFile(this.session.getGaru(), exportFile, goTermRemap);
                        }
                        catch (IOException e) {
                            JOptionPane.showMessageDialog(this, "Failed to create remapped Gene Annotation File due to IO Error: " + e.getMessage(), "Error", 0);
                            return;
                        }
                    } else if (src == this.exportSlimSetFileButton) {
                        if (exportFile.exists() && !exportFile.delete()) {
                            JOptionPane.showMessageDialog(this, "Failed to overwrite selected export file '" + exportFile.getName() + "'.");
                        }
                        boolean writeSuccess = true;
                        for (GOSlimmerController controller : this.controllers) {
                            try {
                                writeSuccess &= controller.appendSlimSetList(exportFile);
                            }
                            catch (IOException e) {
                                JOptionPane.showMessageDialog(this, "Failed to create file listing selected Slim Set terms due to exception: " + e.getMessage(), "Error", 0);
                                return;
                            }
                        }
                        if (!writeSuccess) {
                            JOptionPane.showMessageDialog(this, "Failed to create file listing selected Slim Set terms ", "Error", 0);
                        }
                    }
                }
            }
        }
    }

    private void createRemappedGeneAnnotationFile(GeneAssociationReaderUtil originalFileReader, File remapFile, Map<String, Set<String>> goTermRemap) throws IOException {
        BufferedWriter w = new BufferedWriter(new FileWriter(remapFile));
        GeneAnnotationRemapWriter gaw = new GeneAnnotationRemapWriter(w, goTermRemap);
        gaw.write("!This Gene Annotation File contains entries which have been remapped onto a smaller set of GO terms" + lsep);
        Collection<String[]> entries = originalFileReader.getAnnotationEntries();
        for (String[] entry : entries) {
            gaw.writeRemappedEntry(entry);
        }
        w.close();
    }

    private Collection<String> parseSlimSetFile(File slimSetFile) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(slimSetFile));
        HashSet<String> GOIds = new HashSet<String>();
        String line = null;
        while ((line = in.readLine()) != null) {
            String GOId = this.parseSlimSetLine(line);
            if (GOId == null) continue;
            GOIds.add(GOId);
        }
        return GOIds;
    }

    private String parseSlimSetLine(String line) {
        if (line == null || line.matches("\\s*")) {
            return null;
        }
        line = line.trim();
        String[] parts = line.split("\t");
        return parts[0];
    }

    private void buildSlimSet(Collection<String> goTermIds) {
        HashSet<String> remainingGOIds = new HashSet<String>(goTermIds);
        for (GOSlimmerController controller : this.controllers) {
            CyNetwork network = controller.getNetwork();
            CyNetworkView view = controller.getNetworkView();
            Iterator nodes_i = network.nodesIterator();
            Object curNode = null;
            while (nodes_i.hasNext() && remainingGOIds.size() > 0) {
                Node node = (Node)nodes_i.next();
                if (!remainingGOIds.contains(node.toString())) continue;
                remainingGOIds.remove(node.toString());
                if (!controller.isVisibleNode(node)) {
                    controller.displayNode(node);
                }
                controller.addNodeToSlimSet(node);
            }
            view.redrawGraph(false, false);
        }
        if (remainingGOIds.size() > 0) {
            JOptionPane.showMessageDialog(this, "The following GO ids were invalid: " + lsep + ((Object)remainingGOIds).toString(), "Invalid GO term Ids", 2);
            System.out.println("the following GO ids were invalid:" + ((Object)remainingGOIds).toString());
        }
    }
}

