/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;

public class GreedyPlusAligner
extends Aligner {
    public GreedyPlusAligner(HashSet<Node> d1Set, HashSet<Node> b1Set, EdgeList edges1, HashSet<Node> d2Set, HashSet<Node> b2Set, EdgeList edges2, ScoringMatrix pMatrix, ScoringMatrix dMatrix, ScoringMatrix bMatrix, ScoringMatrix ecMatrix, ArrayList<ScoringMatrix> pMatrices, ArrayList<ScoringMatrix> dMatrices, ArrayList<ScoringMatrix> bMatrices, ArrayList<Double> pWeights, ArrayList<Double> dWeights, ArrayList<Double> bWeights, double ecWeight, ArrayList<Double> pThresholds, ArrayList<Double> dThresholds, ArrayList<Double> bThresholds) throws Exception {
        super(d1Set, b1Set, edges1, d2Set, b2Set, edges2, pMatrix, dMatrix, bMatrix, ecMatrix, pMatrices, dMatrices, bMatrices, pWeights, dWeights, bWeights, ecWeight, pThresholds, dThresholds, bThresholds);
        this.alignerName = "GreedyPlus";
    }

    @Override
    public void alignSub() throws Exception {
        AlignedPair newPair;
        HashMap tracker = new HashMap();
        HashSet<AlignedPair> toBeAligned = new HashSet<AlignedPair>();
        for (Node node1 : this.d1Set) {
            for (Node node2 : this.d2Set) {
                if (!this.checkThresholds(node1, node2)) continue;
                newPair = new AlignedPair(node1, node2, this.calcEdgeScore(node1, node2));
                toBeAligned.add(newPair);
                if (tracker.get(node1) == null) {
                    tracker.put(node1, new HashSet());
                }
                ((HashSet)tracker.get(node1)).add(newPair);
                if (tracker.get(node2) == null) {
                    tracker.put(node2, new HashSet());
                }
                ((HashSet)tracker.get(node2)).add(newPair);
            }
        }
        for (Node node1 : this.b1Set) {
            for (Node node2 : this.b2Set) {
                if (!this.checkThresholds(node1, node2)) continue;
                newPair = new AlignedPair(node1, node2, this.calcEdgeScore(node1, node2));
                toBeAligned.add(newPair);
                if (tracker.get(node1) == null) {
                    tracker.put(node1, new HashSet());
                }
                ((HashSet)tracker.get(node1)).add(newPair);
                if (tracker.get(node2) == null) {
                    tracker.put(node2, new HashSet());
                }
                ((HashSet)tracker.get(node2)).add(newPair);
            }
        }
        while (!toBeAligned.isEmpty()) {
            AlignedPair newPair2 = (AlignedPair)Collections.max(toBeAligned);
            boolean seed = false;
            if (this.calcEdgeECScore(newPair2.node1, newPair2.node2) == 0.0) {
                seed = true;
            }
            this.addEdgeToAlignment(newPair2.node1, newPair2.node2, seed);
            toBeAligned.removeAll((Collection)tracker.get(newPair2.node1));
            toBeAligned.removeAll((Collection)tracker.get(newPair2.node2));
            for (Node node1 : this.edges1.getAdjacent(newPair2.node1)) {
                for (Node node2 : this.edges2.getAdjacent(newPair2.node2)) {
                    if (!toBeAligned.contains(new AlignedPair(node1, node2, 0.0))) continue;
                    toBeAligned.remove(new AlignedPair(node1, node2, 0.0));
                    toBeAligned.add(new AlignedPair(node1, node2, this.calcEdgeScore(node1, node2)));
                }
            }
        }
    }

    @Override
    protected void addEdgeToAlignment(Node node1, Node node2, boolean seed) throws Exception {
        this.alignment.add(node1, node2, seed);
        if (this.ecWeight != 0.0) {
            this.updateECMatrix(node1, node2);
        }
        if (seed) {
            Static.debugOutput(String.valueOf(this.alignment.forward.size()) + "\t" + node1.name + " - " + node2.name + "\t" + Static.fourDecimals.format(this.calcEdgeScore(node1, node2)) + "\t" + Static.fourDecimals.format(this.calcEdgeScore(node1, node2) - this.calcEdgeECScore(node1, node2)) + "\tseed");
        } else {
            StringBuffer temp = new StringBuffer();
            for (Node neighbour1 : this.edges1.getAdjacent(node1)) {
                if (!this.alignment.contains(neighbour1) || !this.edges2.areAdjacent(node2, this.alignment.get(neighbour1))) continue;
                temp.append(String.valueOf(neighbour1.name) + " - " + this.alignment.get((Node)neighbour1).name + "\t");
            }
            Static.debugOutput(String.valueOf(this.alignment.forward.size()) + "\t" + node1.name + " - " + node2.name + "\t" + Static.fourDecimals.format(this.calcEdgeScore(node1, node2)) + "\t" + Static.fourDecimals.format(this.calcEdgeScore(node1, node2) - this.calcEdgeECScore(node1, node2)) + "\t" + temp.toString());
        }
    }

    private void updateECMatrix(Node node1, Node node2) throws Exception {
        HashSet<Node> adj1 = this.edges1.getAdjacent(node1);
        HashSet<Node> adj2 = this.edges2.getAdjacent(node2);
        for (Node firstNeighbour : adj1) {
            for (Node secondNeighbour : adj2) {
                this.ecMatrix.set(firstNeighbour, secondNeighbour, this.ecMatrix.get(firstNeighbour, secondNeighbour) + 1.0);
            }
        }
    }
}

