/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Alignment {
    HashMap<Node, Node> forward;
    HashMap<Node, Node> backward;
    ArrayList<Node> order;
    HashSet<Node> seed = new HashSet();
    double score = 0.0;
    double ecScore = 0.0;

    public Alignment() {
        this.forward = new HashMap();
        this.backward = new HashMap();
        this.order = new ArrayList();
    }

    public Alignment(Alignment align) {
        this.forward = (HashMap)align.forward.clone();
        this.backward = (HashMap)align.backward.clone();
        this.order = (ArrayList)align.order.clone();
        this.score = align.score;
        this.ecScore = align.ecScore;
    }

    public Alignment(String filename) throws Exception {
        this.forward = new HashMap();
        this.backward = new HashMap();
        this.order = new ArrayList();
        this.seed = new HashSet();
        BufferedReader in = new BufferedReader(new FileReader(filename));
        String line = "";
        Pattern pattern = Pattern.compile("<att name=\"label\" type=\"string\" value=\"Species 1: (.*) - Species 2: (.*)\" />");
        while ((line = Static.skipCommentLines(in)) != null) {
            Matcher matcher;
            Pattern pattern2;
            Matcher matcher2;
            line = line.trim();
            if (this.score == 0.0 && line.startsWith("<att name=\"score\"") && (matcher2 = (pattern2 = Pattern.compile("value=\"(.*)\" />")).matcher(line)).find()) {
                this.score = Double.parseDouble(matcher2.group(1));
            }
            if (!(matcher = pattern.matcher(line)).find()) continue;
            Node node1 = new Node(matcher.group(1), 1);
            Node node2 = new Node(matcher.group(2), 2);
            Pattern pattern22 = Pattern.compile("<att name=\"seed\" type=\"boolean\" value=\"(.*)\" />");
            Matcher matcher22 = null;
            while ((line = Static.skipCommentLines(in)) != null) {
                matcher22 = pattern22.matcher(line);
                if (matcher22.find()) break;
            }
            boolean seed = Boolean.valueOf(matcher22.group(1));
            this.add(node1, node2, seed);
        }
        in.close();
    }

    public void add(Node node1, Node node2, boolean seed) throws Exception {
        if (this.forward.containsKey(node1) || this.backward.containsKey(node2)) {
            throw new Exception(String.valueOf(node1.name) + " or " + node2.name + " already aligned.");
        }
        this.forward.put(node1, node2);
        this.backward.put(node2, node1);
        this.order.add(node1);
        if (seed) {
            this.seed.add(node1);
        }
    }

    public Node get(Node node) {
        if (this.forward.containsKey(node)) {
            return this.forward.get(node);
        }
        if (this.backward.containsKey(node)) {
            return this.backward.get(node);
        }
        return null;
    }

    public boolean contains(Node node) {
        return this.get(node) != null;
    }

    public HashMap<String, HashSet<String>> proteinMapping() throws Exception {
        HashMap<String, HashSet<String>> result = new HashMap<String, HashSet<String>>();
        for (Node node1 : this.forward.keySet()) {
            Node node2 = this.forward.get(node1);
            if (!result.containsKey(node1.getProteinName())) {
                result.put(node1.getProteinName(), new HashSet());
            }
            result.get(node1.getProteinName()).add(node2.getProteinName());
        }
        return result;
    }

    public static double calcSimilarity(Alignment first, Alignment second) throws Exception {
        int correct = 0;
        Alignment align1 = first;
        Alignment align2 = second;
        if (first.forward.size() > second.forward.size()) {
            align1 = second;
            align2 = first;
        }
        for (Node node1 : align1.forward.keySet()) {
            Node node2;
            if (node1.compareTo(node2 = align1.get(node1)) > 0 || align2.get(node1) == null || !align2.get(node1).equals(node2)) continue;
            ++correct;
        }
        return (double)correct / (double)(align1.forward.size() / 2);
    }

    public Double getScore() {
        return this.score;
    }

    public static String sum(Set<Alignment> alignments) {
        HashMap<AlignedPair, Integer> tempContainer = new HashMap<AlignedPair, Integer>();
        for (Alignment alignment : alignments) {
            for (Node node1 : alignment.forward.keySet()) {
                if (node1.species == 2) continue;
                Node node2 = alignment.forward.get(node1);
                AlignedPair ap = new AlignedPair(node1, node2);
                if (tempContainer.containsKey(ap)) {
                    tempContainer.put(ap, (Integer)tempContainer.get(ap) + 1);
                    continue;
                }
                tempContainer.put(ap, 1);
            }
        }
        ArrayList<AlignedPair> aps = new ArrayList<AlignedPair>();
        for (AlignedPair ap : tempContainer.keySet()) {
            ap.score = ((Integer)tempContainer.get(ap)).intValue();
            aps.add(ap);
        }
        Collections.sort(aps, Collections.reverseOrder());
        StringBuffer output = new StringBuffer();
        int i = 0;
        while (i < aps.size()) {
            output.append(((AlignedPair)aps.get((int)i)).node1 + " - " + ((AlignedPair)aps.get((int)i)).node2 + " - Count: " + ((AlignedPair)aps.get((int)i)).score + "\n");
            ++i;
        }
        return output.toString();
    }

    public static String diff(Alignment alignment1, Alignment alignment2) {
        StringBuffer output = new StringBuffer();
        for (Node node1 : alignment1.forward.keySet()) {
            if (alignment2.get(node1) != null && alignment2.get(node1).equals(alignment1.get(node1))) continue;
            output.append(node1 + " - " + alignment1.get(node1) + "\n");
        }
        for (Node node1 : alignment2.forward.keySet()) {
            if (alignment1.get(node1) != null && alignment1.get(node1).equals(alignment2.get(node1))) continue;
            output.append(node1 + " - " + alignment2.get(node1) + "\n");
        }
        return output.toString();
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        for (Node node : this.order) {
            Node node2 = this.forward.get(node);
            output.append(String.valueOf(node.toString()) + "\t" + node2.toString() + "\n");
        }
        output.append("Score: " + this.score + "\n");
        output.append("Edge correctness: " + this.ecScore + "\n");
        return output.toString();
    }
}

