/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public class EdgeList {
    HashMap<Node, HashSet<Node>> edges;
    String filename;
    int size = 0;

    public EdgeList() {
        this.edges = new HashMap();
    }

    public EdgeList(String filename, int species) throws Exception {
        this.filename = filename;
        this.edges = new HashMap();
        BufferedReader in = new BufferedReader(new FileReader(filename));
        String line = "";
        while ((line = in.readLine()) != null) {
            String[] entries = line.split("\t");
            if (entries[0].matches(".*,.*,.*,.*")) {
                entries[0] = String.valueOf(entries[0].split(",")[0]) + "," + entries[0].split(",")[2] + "," + entries[0].split(",")[3];
            }
            if (entries[1].matches(".*,.*,.*,.*")) {
                entries[1] = String.valueOf(entries[1].split(",")[0]) + "," + entries[1].split(",")[2] + "," + entries[1].split(",")[3];
            }
            this.addEdge(new Node(entries[0], species), new Node(entries[1], species));
        }
        in.close();
    }

    public EdgeList(EdgeList orig) {
        this.filename = orig.filename;
        this.edges = new HashMap();
        for (Node node1 : orig.edges.keySet()) {
            for (Node node2 : orig.edges.get(node1)) {
                this.addEdge(node1, node2);
            }
        }
    }

    public boolean checkEdge(Node node1, Node node2) {
        return this.edges.containsKey(node1) && this.edges.get(node1).contains(node2);
    }

    public void addEdge(Node node1, Node node2) {
        if (!this.edges.containsKey(node1)) {
            this.edges.put(node1, new HashSet());
        }
        if (!this.edges.containsKey(node2)) {
            this.edges.put(node2, new HashSet());
        }
        if (!this.checkEdge(node1, node2)) {
            this.edges.get(node1).add(node2);
            this.edges.get(node2).add(node1);
            ++this.size;
        }
    }

    public void deleteEdge(Node node1, Node node2) {
        this.edges.get(node1).remove(node2);
        this.edges.get(node2).remove(node1);
        --this.size;
    }

    public HashSet<Node> getAdjacent(Node node) {
        if (this.edges.containsKey(node)) {
            return new HashSet<Node>((Collection)this.edges.get(node));
        }
        return new HashSet<Node>();
    }

    public int getDegree(Node node) {
        return this.edges.get(node).size();
    }

    public boolean areAdjacent(Node node1, Node node2) {
        return this.edges.get(node1).contains(node2);
    }
}

