/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.PriorityQueue;

public class GreedyAligner
extends Aligner {
    public GreedyAligner(HashSet<Node> d1Set, HashSet<Node> b1Set, EdgeList edges1, HashSet<Node> d2Set, HashSet<Node> b2Set, EdgeList edges2, ScoringMatrix pMatrix, ScoringMatrix dMatrix, ScoringMatrix bMatrix, ScoringMatrix ecMatrix, ArrayList<ScoringMatrix> pMatrices, ArrayList<ScoringMatrix> dMatrices, ArrayList<ScoringMatrix> bMatrices, ArrayList<Double> pWeights, ArrayList<Double> dWeights, ArrayList<Double> bWeights, double ecWeight, ArrayList<Double> pThresholds, ArrayList<Double> dThresholds, ArrayList<Double> bThresholds) throws Exception {
        super(d1Set, b1Set, edges1, d2Set, b2Set, edges2, pMatrix, dMatrix, bMatrix, ecMatrix, pMatrices, dMatrices, bMatrices, pWeights, dWeights, bWeights, ecWeight, pThresholds, dThresholds, bThresholds);
        this.alignerName = "Greedy";
    }

    @Override
    public void alignSub() throws Exception {
        AlignedPair newPair;
        HashSet<Node> alignedNodes = new HashSet<Node>();
        PriorityQueue toBeAligned = new PriorityQueue(this.d1Set.size() * this.d2Set.size() + (this.b1Set.size() + this.b2Set.size()), Collections.reverseOrder());
        for (Node node1 : this.d1Set) {
            for (Node node2 : this.d2Set) {
                if (!this.checkThresholds(node1, node2)) continue;
                newPair = new AlignedPair(node1, node2, this.calcEdgeScore(node1, node2));
                toBeAligned.add(newPair);
            }
        }
        for (Node node1 : this.b1Set) {
            for (Node node2 : this.b2Set) {
                if (!this.checkThresholds(node1, node2)) continue;
                newPair = new AlignedPair(node1, node2, this.calcEdgeScore(node1, node2));
                toBeAligned.add(newPair);
            }
        }
        while (!toBeAligned.isEmpty()) {
            AlignedPair newPair2 = (AlignedPair)toBeAligned.poll();
            if (alignedNodes.contains(newPair2.node1) || alignedNodes.contains(newPair2.node2)) continue;
            alignedNodes.add(newPair2.node1);
            alignedNodes.add(newPair2.node2);
            this.addEdgeToAlignment(newPair2.node1, newPair2.node2, true);
        }
    }
}

