/*
 * Decompiled with CFR 0.152.
 */
import java.util.Arrays;

public class HungarianAlgorithm {
    public double[][] costMatrix;
    private final int rows;
    private final int cols;
    private final int dim;
    private final double[] labelByWorker;
    private final double[] labelByJob;
    private final int[] minSlackWorkerByJob;
    private final double[] minSlackValueByJob;
    public int[] matchJobByWorker;
    public int[] matchWorkerByJob;
    private final int[] parentWorkerByCommittedJob;
    private final boolean[] committedWorkers;

    public HungarianAlgorithm(double[][] costMatrix) {
        this.dim = Math.max(costMatrix.length, costMatrix[0].length);
        this.rows = costMatrix.length;
        this.cols = costMatrix[0].length;
        this.costMatrix = new double[this.dim][this.dim];
        int w = 0;
        while (w < this.dim) {
            if (w < costMatrix.length) {
                if (costMatrix[w].length != this.cols) {
                    throw new IllegalArgumentException("Irregular cost matrix");
                }
                this.costMatrix[w] = Arrays.copyOf(costMatrix[w], this.dim);
            } else {
                this.costMatrix[w] = new double[this.dim];
            }
            ++w;
        }
        this.labelByWorker = new double[this.dim];
        this.labelByJob = new double[this.dim];
        this.minSlackWorkerByJob = new int[this.dim];
        this.minSlackValueByJob = new double[this.dim];
        this.committedWorkers = new boolean[this.dim];
        this.parentWorkerByCommittedJob = new int[this.dim];
        this.matchJobByWorker = new int[this.dim];
        Arrays.fill(this.matchJobByWorker, -1);
        this.matchWorkerByJob = new int[this.dim];
        Arrays.fill(this.matchWorkerByJob, -1);
    }

    protected void computeInitialFeasibleSolution() {
        int j = 0;
        while (j < this.dim) {
            this.labelByJob[j] = Double.POSITIVE_INFINITY;
            ++j;
        }
        int w = 0;
        while (w < this.dim) {
            int j2 = 0;
            while (j2 < this.dim) {
                if (this.costMatrix[w][j2] < this.labelByJob[j2]) {
                    this.labelByJob[j2] = this.costMatrix[w][j2];
                }
                ++j2;
            }
            ++w;
        }
    }

    public int[] execute() {
        this.reduce();
        this.computeInitialFeasibleSolution();
        this.greedyMatch();
        int w = this.fetchUnmatchedWorker();
        while (w < this.dim) {
            this.initializePhase(w);
            this.executePhase();
            w = this.fetchUnmatchedWorker();
        }
        int[] result = Arrays.copyOf(this.matchJobByWorker, this.rows);
        w = 0;
        while (w < result.length) {
            if (result[w] >= this.cols) {
                result[w] = -1;
            }
            ++w;
        }
        return result;
    }

    protected void executePhase() {
        block0: while (true) {
            int minSlackWorker = -1;
            int minSlackJob = -1;
            double minSlackValue = Double.POSITIVE_INFINITY;
            int j = 0;
            while (j < this.dim) {
                if (this.parentWorkerByCommittedJob[j] == -1 && this.minSlackValueByJob[j] < minSlackValue) {
                    minSlackValue = this.minSlackValueByJob[j];
                    minSlackWorker = this.minSlackWorkerByJob[j];
                    minSlackJob = j;
                }
                ++j;
            }
            if (minSlackValue > 0.0) {
                this.updateLabeling(minSlackValue);
            }
            this.parentWorkerByCommittedJob[minSlackJob] = minSlackWorker;
            if (this.matchWorkerByJob[minSlackJob] == -1) {
                int committedJob = minSlackJob;
                int parentWorker = this.parentWorkerByCommittedJob[committedJob];
                while (true) {
                    int temp = this.matchJobByWorker[parentWorker];
                    this.match(parentWorker, committedJob);
                    committedJob = temp;
                    if (committedJob == -1) break;
                    parentWorker = this.parentWorkerByCommittedJob[committedJob];
                }
                return;
            }
            int worker = this.matchWorkerByJob[minSlackJob];
            this.committedWorkers[worker] = true;
            int j2 = 0;
            while (true) {
                double slack;
                if (j2 >= this.dim) continue block0;
                if (this.parentWorkerByCommittedJob[j2] == -1 && this.minSlackValueByJob[j2] > (slack = this.costMatrix[worker][j2] - this.labelByWorker[worker] - this.labelByJob[j2])) {
                    this.minSlackValueByJob[j2] = slack;
                    this.minSlackWorkerByJob[j2] = worker;
                }
                ++j2;
            }
            break;
        }
    }

    protected int fetchUnmatchedWorker() {
        int w = 0;
        while (w < this.dim) {
            if (this.matchJobByWorker[w] == -1) break;
            ++w;
        }
        return w;
    }

    protected void greedyMatch() {
        int w = 0;
        while (w < this.dim) {
            int j = 0;
            while (j < this.dim) {
                if (this.matchJobByWorker[w] == -1 && this.matchWorkerByJob[j] == -1 && this.costMatrix[w][j] - this.labelByWorker[w] - this.labelByJob[j] == 0.0) {
                    this.match(w, j);
                }
                ++j;
            }
            ++w;
        }
    }

    protected void initializePhase(int w) {
        Arrays.fill(this.committedWorkers, false);
        Arrays.fill(this.parentWorkerByCommittedJob, -1);
        this.committedWorkers[w] = true;
        int j = 0;
        while (j < this.dim) {
            this.minSlackValueByJob[j] = this.costMatrix[w][j] - this.labelByWorker[w] - this.labelByJob[j];
            this.minSlackWorkerByJob[j] = w;
            ++j;
        }
    }

    protected void match(int w, int j) {
        this.matchJobByWorker[w] = j;
        this.matchWorkerByJob[j] = w;
    }

    protected void reduce() {
        int j;
        int w = 0;
        while (w < this.dim) {
            double min = Double.POSITIVE_INFINITY;
            int j2 = 0;
            while (j2 < this.dim) {
                if (this.costMatrix[w][j2] < min) {
                    min = this.costMatrix[w][j2];
                }
                ++j2;
            }
            j2 = 0;
            while (j2 < this.dim) {
                double[] dArray = this.costMatrix[w];
                int n = j2++;
                dArray[n] = dArray[n] - min;
            }
            ++w;
        }
        double[] min = new double[this.dim];
        int j3 = 0;
        while (j3 < this.dim) {
            min[j3] = Double.POSITIVE_INFINITY;
            ++j3;
        }
        int w2 = 0;
        while (w2 < this.dim) {
            j = 0;
            while (j < this.dim) {
                if (this.costMatrix[w2][j] < min[j]) {
                    min[j] = this.costMatrix[w2][j];
                }
                ++j;
            }
            ++w2;
        }
        w2 = 0;
        while (w2 < this.dim) {
            j = 0;
            while (j < this.dim) {
                double[] dArray = this.costMatrix[w2];
                int n = j;
                dArray[n] = dArray[n] - min[j];
                ++j;
            }
            ++w2;
        }
    }

    protected void updateLabeling(double slack) {
        int w = 0;
        while (w < this.dim) {
            if (this.committedWorkers[w]) {
                int n = w;
                this.labelByWorker[n] = this.labelByWorker[n] + slack;
            }
            ++w;
        }
        int j = 0;
        while (j < this.dim) {
            if (this.parentWorkerByCommittedJob[j] != -1) {
                int n = j;
                this.labelByJob[n] = this.labelByJob[n] - slack;
            } else {
                int n = j;
                this.minSlackValueByJob[n] = this.minSlackValueByJob[n] - slack;
            }
            ++j;
        }
    }
}

