/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashSet;

public class NatalieAligner
extends Aligner {
    public NatalieAligner(HashSet<Node> d1Set, HashSet<Node> b1Set, EdgeList edges1, HashSet<Node> d2Set, HashSet<Node> b2Set, EdgeList edges2, ScoringMatrix pMatrix, ScoringMatrix dMatrix, ScoringMatrix bMatrix, ScoringMatrix ecMatrix, ArrayList<ScoringMatrix> pMatrices, ArrayList<ScoringMatrix> dMatrices, ArrayList<ScoringMatrix> bMatrices, ArrayList<Double> pWeights, ArrayList<Double> dWeights, ArrayList<Double> bWeights, double ecWeight, ArrayList<Double> pThresholds, ArrayList<Double> dThresholds, ArrayList<Double> bThresholds) {
        super(d1Set, b1Set, edges1, d2Set, b2Set, edges2, pMatrix, dMatrix, bMatrix, ecMatrix, pMatrices, dMatrices, bMatrices, pWeights, dWeights, bWeights, ecWeight, pThresholds, dThresholds, bThresholds);
        this.alignerName = "Natalie";
    }

    @Override
    public void alignSub() throws Exception {
        String fileName = "Natalie/Natalie.worm_yeast.sif";
        BufferedReader in = new BufferedReader(new FileReader(fileName));
        String line = "";
        while ((line = Static.skipCommentLines(in)) != null) {
            String[] split = line.split(" pp ");
            Node node1 = new Node(split[0], 1);
            Node node2 = new Node(split[1], 2);
            this.addEdgeToAlignment(node1, node2, false);
        }
        in.close();
    }

    public void outputScoringFile(String outputFile) throws Exception {
        String scoreString;
        Double score;
        BufferedWriter out = new BufferedWriter(new FileWriter(outputFile));
        for (Node node1 : this.d1Set) {
            for (Node node2 : this.d2Set) {
                score = this.calcEdgeScore(node1, node2);
                scoreString = Static.fourDecimals.format(score);
                out.write(String.valueOf(node1.name) + "\t" + node2.name + "\t0\t0\t0\t0\t0\t0\t0\t0\t0\t" + scoreString + "\n");
            }
            for (Node node2 : this.b2Set) {
                out.write(String.valueOf(node1.name) + "\t" + node2.name + "\t0\t0\t0\t0\t0\t0\t0\t0\t0\t-1000\n");
            }
        }
        for (Node node1 : this.b1Set) {
            for (Node node2 : this.d2Set) {
                out.write(String.valueOf(node1.name) + "\t" + node2.name + "\t0\t0\t0\t0\t0\t0\t0\t0\t0\t-1000\n");
            }
            for (Node node2 : this.b2Set) {
                score = this.calcEdgeScore(node1, node2);
                scoreString = Static.fourDecimals.format(score);
                out.write(String.valueOf(node1.name) + "\t" + node2.name + "\t0\t0\t0\t0\t0\t0\t0\t0\t0\t" + scoreString + "\n");
            }
        }
        out.close();
    }
}

