/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.HashMap;

public class ScoringMatrix {
    HashMap<Node, HashMap<Node, Double>> forward;
    public String name = "";

    public ScoringMatrix(String name) {
        this.forward = new HashMap();
        this.name = name;
    }

    public ScoringMatrix(String name, String filename) throws Exception {
        this.name = name;
        this.forward = new HashMap();
        BufferedReader in = new BufferedReader(new FileReader(filename));
        String line = in.readLine();
        String[] xHeaders = line.split("\t");
        int i = 1;
        while (i < xHeaders.length) {
            this.forward.put(new Node(xHeaders[i], 1), new HashMap());
            ++i;
        }
        while ((line = in.readLine()) != null) {
            String[] entries = line.split("\t");
            int i2 = 1;
            while (i2 < entries.length) {
                this.forward.get(new Node(xHeaders[i2], 1)).put(new Node(entries[0], 2), new Double(entries[i2]));
                ++i2;
            }
        }
        in.close();
    }

    public ScoringMatrix(ScoringMatrix old) {
        this.forward = new HashMap();
        for (Node node1 : old.forward.keySet()) {
            this.forward.put(node1, new HashMap());
            for (Node node2 : old.forward.get(node1).keySet()) {
                this.forward.get(node1).put(node2, old.forward.get(node1).get(node2));
            }
        }
    }

    public void reset() {
        for (Node node1 : this.forward.keySet()) {
            for (Node node2 : this.forward.get(node1).keySet()) {
                this.forward.get(node1).put(node2, 0.0);
            }
        }
    }

    public void addMatrix(ScoringMatrix newMatrix, double weight) throws Exception {
        if (this.forward.isEmpty()) {
            for (Node key1 : newMatrix.forward.keySet()) {
                this.forward.put(key1, new HashMap());
                for (Node key2 : newMatrix.forward.get(key1).keySet()) {
                    this.forward.get(key1).put(key2, newMatrix.forward.get(key1).get(key2) * weight);
                }
            }
            return;
        }
        if (!this.forward.keySet().equals(newMatrix.forward.keySet()) || !this.forward.values().iterator().next().keySet().equals(newMatrix.forward.values().iterator().next().keySet())) {
            throw new Exception("Scoring matrices do not operate on the same nodes.");
        }
        for (Node key1 : this.forward.keySet()) {
            for (Node key2 : this.forward.get(key1).keySet()) {
                this.forward.get(key1).put(key2, this.forward.get(key1).get(key2) + weight * newMatrix.get(key1, key2));
            }
        }
    }

    public boolean contains(Node node1, Node node2) {
        return this.forward.containsKey(node1) && this.forward.get(node1).containsKey(node2) || this.forward.containsKey(node2) && this.forward.get(node1).containsKey(node1);
    }

    public double get(Node node1, Node node2) throws Exception {
        if (this.forward.containsKey(node1) && this.forward.get(node1).containsKey(node2)) {
            return this.forward.get(node1).get(node2);
        }
        if (this.forward.containsKey(node2) && this.forward.get(node2).containsKey(node1)) {
            return this.forward.get(node2).get(node1);
        }
        throw new Exception(String.valueOf(node1.toString()) + "," + node2.toString() + " not found in this scoring matrix.");
    }

    public void set(Node node1, Node node2, double newScore) {
        if (!this.forward.containsKey(node1)) {
            this.forward.put(node1, new HashMap());
        }
        this.forward.get(node1).put(node2, newScore);
    }

    public int getSize() {
        return this.forward.size() * this.forward.get(this.forward.keySet().iterator().next()).size();
    }

    public void outputValues(boolean labels) throws Exception {
        StringBuffer output = new StringBuffer();
        for (Node node1 : this.forward.keySet()) {
            for (Node node2 : this.forward.get(node1).keySet()) {
                if (labels) {
                    output.append(String.valueOf(node1.name) + " - " + node2.name + "\t");
                }
                output.append(String.valueOf(Static.fourDecimals.format(this.forward.get(node1).get(node2))) + "\n");
            }
        }
        String returnValue = output.toString();
        returnValue = returnValue.substring(0, returnValue.length() - 1);
        BufferedWriter out = new BufferedWriter(new FileWriter(String.valueOf(this.name.substring(0, this.name.lastIndexOf(46))) + ".flattened.txt"));
        out.write(returnValue);
        out.close();
    }

    public String toString() {
        return this.forward.toString();
    }

    public static double getEditDistance(ScoringMatrix first, ScoringMatrix second) throws Exception {
        if (!first.forward.keySet().equals(second.forward.keySet()) || !first.forward.values().iterator().next().keySet().equals(second.forward.values().iterator().next().keySet())) {
            throw new Exception("Scoring matrices do not operate on the same nodes.");
        }
        double diff = 0.0;
        for (Node node1 : first.forward.keySet()) {
            for (Node node2 : first.forward.get(node1).keySet()) {
                diff += Math.abs(first.get(node1, node2) - second.get(node1, node2));
            }
        }
        return diff;
    }

    public static double getEuclideanDistance(ScoringMatrix first, ScoringMatrix second) throws Exception {
        if (!first.forward.keySet().equals(second.forward.keySet()) || !first.forward.values().iterator().next().keySet().equals(second.forward.values().iterator().next().keySet())) {
            throw new Exception("Scoring matrices do not operate on the same nodes.");
        }
        double diff = 0.0;
        for (Node node1 : first.forward.keySet()) {
            for (Node node2 : first.forward.get(node1).keySet()) {
                diff += Math.pow(first.get(node1, node2) - second.get(node1, node2), 2.0);
            }
        }
        return Math.sqrt(diff / (double)first.getSize());
    }

    public static void main(String[] args) throws Exception {
        String[] matrices;
        String[] stringArray = matrices = new String[]{"human_worm/aslp_human_worm_binding_site.txt", "human_worm/aslp_human_worm_domain.txt", "human_worm/betweenness_human_worm_binding_site.txt", "human_worm/betweenness_human_worm_domain.txt", "human_worm/closeness_human_worm_binding_site.txt", "human_worm/closeness_human_worm_domain.txt", "human_worm/degree_human_worm_binding_site.txt", "human_worm/degree_human_worm_domain.txt", "human_worm/eccentricity_human_worm_binding_site.txt", "human_worm/eccentricity_human_worm_domain.txt", "human_worm/nc_human_worm_binding_site.txt", "human_worm/nc_human_worm_domain.txt", "human_worm/radiality_human_worm_binding_site.txt", "human_worm/radiality_human_worm_domain.txt", "human_worm/stress_human_worm_binding_site.txt", "human_worm/stress_human_worm_domain.txt", "human_worm/tc_human_worm_binding_site.txt", "human_worm/tc_human_worm_domain.txt", "human_worm/graphlet_human_worm_binding_site.txt", "human_worm/graphlet_human_worm_domain.txt", "human_worm/tcss_bp.human_worm.txt", "human_worm/tcss_cc.human_worm.txt", "human_worm/tcss_mf.human_worm.txt", "human_worm/blast_human_worm_domain_coverage.raw.txt", "human_worm/blast_human_worm_domain_score.raw.txt", "human_worm/blast_human_worm_protein_coverage.raw.txt", "human_worm/blast_human_worm_protein_score.raw.txt", "human_worm/smith_waterman_human_worm_binding_site_coverage.raw.txt", "human_worm/smith_waterman_human_worm_binding_site_score.raw.txt"};
        int n = matrices.length;
        int n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            System.out.println(filename);
            ScoringMatrix matrix = new ScoringMatrix(filename, filename);
            matrix.outputValues(true);
            ++n2;
        }
    }
}

