/*
 * Decompiled with CFR 0.152.
 */
package DomainAlignment;

import DomainAlignment.Aligner;
import DomainAlignment.Alignment;
import DomainAlignment.CGraalAligner;
import DomainAlignment.EdgeList;
import DomainAlignment.GraalAligner;
import DomainAlignment.GreedyAligner;
import DomainAlignment.GreedyPlusAligner;
import DomainAlignment.HGraalAligner;
import DomainAlignment.IsoRankAligner;
import DomainAlignment.NatalieAligner;
import DomainAlignment.NetAligner;
import DomainAlignment.Node;
import DomainAlignment.SSEAligner;
import DomainAlignment.ScoringMatrix;
import DomainAlignment.Static;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class AlignerWrapper {
    private EdgeList edges1 = null;
    private EdgeList edges2 = null;
    private HashMap<String, HashSet<String>> allOrthologies = new HashMap();
    private HashMap<String, HashSet<String>> allOrthologousNodes = new HashMap();
    private int numOrthologies = 0;
    private int numOrthologousNodes = 0;
    private HashMap<String, HashSet<String>> orthologiesFound = new HashMap();
    private HashMap<Node, HashSet<Node>> orthologousNodesFound = new HashMap();
    public int numOrthologiesFound = 0;
    public int numOrthologousNodesFound = 0;
    private String outputName = null;
    private String parameters = null;
    HashSet<Node> p1Set = new HashSet();
    HashSet<Node> p2Set = new HashSet();
    HashSet<Node> d1Set = new HashSet();
    HashSet<Node> d2Set = new HashSet();
    HashSet<Node> b1Set = new HashSet();
    HashSet<Node> b2Set = new HashSet();
    private ArrayList<ScoringMatrix> pMatrices = new ArrayList();
    private ArrayList<ScoringMatrix> dMatrices = new ArrayList();
    private ArrayList<ScoringMatrix> bMatrices = new ArrayList();
    private ScoringMatrix pMatrix = null;
    private ScoringMatrix dMatrix = null;
    private ScoringMatrix bMatrix = null;
    private ScoringMatrix ecMatrix = new ScoringMatrix("ecMatrix");
    private ArrayList<Double> pWeights = new ArrayList();
    private ArrayList<Double> dWeights = new ArrayList();
    private ArrayList<Double> bWeights = new ArrayList();
    private double ecWeight = 0.0;
    private ArrayList<Double> pThresholds = new ArrayList();
    private ArrayList<Double> dThresholds = new ArrayList();
    private ArrayList<Double> bThresholds = new ArrayList();
    public Aligner aligner = null;

    public AlignerWrapper(String filename, String alignerType) throws Exception {
        BufferedReader in = new BufferedReader(new FileReader(filename));
        StringBuffer param = new StringBuffer();
        String line = Static.skipCommentLines(in);
        param.append("\tAdjacency File 1: " + line + "\n");
        this.edges1 = new EdgeList(line, 1);
        line = Static.skipCommentLines(in);
        param.append("\tAdjacency File 2: " + line + "\n");
        this.edges2 = new EdgeList(line, 2);
        line = Static.skipCommentLines(in);
        param.append("\tOrthology File: " + line + "\n");
        this.buildOrthologies(line);
        line = Static.skipCommentLines(in);
        param.append("\tOrthologous Nodes File: " + line + "\n");
        this.buildOrthologousNodes(line);
        line = Static.skipCommentLines(in);
        this.outputName = line.replace("<aligner>", alignerType);
        line = Static.skipCommentLines(in);
        if (line.length() > 0) {
            this.ecWeight = Double.valueOf(line);
        }
        while ((line = in.readLine()) != null) {
            if (line.length() == 0 || line.charAt(0) == '!') continue;
            String[] values = line.split("\t");
            Static.debugOutput(values[0]);
            param.append("\tMatrix file: " + values[0] + "\tType: " + values[1] + "\tWeight: " + values[2] + "\tThreshold " + values[3] + "\n");
            if (values[1].equals("p")) {
                if (this.pMatrix == null) {
                    this.pMatrix = new ScoringMatrix("pmatrix");
                }
                this.addMatrixToAligner(values, this.pMatrices, this.pMatrix, this.pThresholds, this.pWeights);
                Static.populateNodeLists(this.p1Set, this.p2Set, values[0]);
                continue;
            }
            if (values[1].equals("d")) {
                if (this.dMatrix == null) {
                    this.dMatrix = new ScoringMatrix("dmatrix");
                }
                this.addMatrixToAligner(values, this.dMatrices, this.dMatrix, this.dThresholds, this.dWeights);
                Static.populateNodeLists(this.d1Set, this.d2Set, values[0]);
                continue;
            }
            if (!values[1].equals("b")) continue;
            if (this.bMatrix == null) {
                this.bMatrix = new ScoringMatrix("bmatrix");
            }
            this.addMatrixToAligner(values, this.bMatrices, this.bMatrix, this.bThresholds, this.bWeights);
            Static.populateNodeLists(this.b1Set, this.b2Set, values[0]);
        }
        for (Node node1 : this.d1Set) {
            for (Node node2 : this.d2Set) {
                this.ecMatrix.set(node1, node2, 0.0);
            }
        }
        for (Node node1 : this.b1Set) {
            for (Node node2 : this.b2Set) {
                this.ecMatrix.set(node1, node2, 0.0);
            }
        }
        param.append("\tEdge Weight: " + this.ecWeight + "\n");
        this.parameters = param.toString();
        in.close();
        if (alignerType.equals("GreedyPlus")) {
            this.aligner = new GreedyPlusAligner(this.d1Set, this.b1Set, this.edges1, this.d2Set, this.b2Set, this.edges2, this.pMatrix, this.dMatrix, this.bMatrix, this.ecMatrix, this.pMatrices, this.dMatrices, this.bMatrices, this.pWeights, this.dWeights, this.bWeights, this.ecWeight, this.pThresholds, this.dThresholds, this.bThresholds);
        } else if (alignerType.equals("Greedy")) {
            this.aligner = new GreedyAligner(this.d1Set, this.b1Set, this.edges1, this.d2Set, this.b2Set, this.edges2, this.pMatrix, this.dMatrix, this.bMatrix, this.ecMatrix, this.pMatrices, this.dMatrices, this.bMatrices, this.pWeights, this.dWeights, this.bWeights, this.ecWeight, this.pThresholds, this.dThresholds, this.bThresholds);
        } else if (alignerType.equals("SSE")) {
            this.aligner = new SSEAligner(this.d1Set, this.b1Set, this.edges1, this.d2Set, this.b2Set, this.edges2, this.pMatrix, this.dMatrix, this.bMatrix, this.ecMatrix, this.pMatrices, this.dMatrices, this.bMatrices, this.pWeights, this.dWeights, this.bWeights, this.ecWeight, this.pThresholds, this.dThresholds, this.bThresholds);
        } else if (alignerType.equals("CGraal")) {
            this.aligner = new CGraalAligner(this.d1Set, this.b1Set, this.edges1, this.d2Set, this.b2Set, this.edges2, this.pMatrix, this.dMatrix, this.bMatrix, this.ecMatrix, this.pMatrices, this.dMatrices, this.bMatrices, this.pWeights, this.dWeights, this.bWeights, this.ecWeight, this.pThresholds, this.dThresholds, this.bThresholds);
        } else if (alignerType.equals("Graal")) {
            this.aligner = new GraalAligner(this.d1Set, this.b1Set, this.edges1, this.d2Set, this.b2Set, this.edges2, this.pMatrix, this.dMatrix, this.bMatrix, this.ecMatrix, this.pMatrices, this.dMatrices, this.bMatrices, this.pWeights, this.dWeights, this.bWeights, this.ecWeight, this.pThresholds, this.dThresholds, this.bThresholds);
        } else if (alignerType.equals("HGraal")) {
            this.aligner = new HGraalAligner(this.d1Set, this.b1Set, this.edges1, this.d2Set, this.b2Set, this.edges2, this.pMatrix, this.dMatrix, this.bMatrix, this.ecMatrix, this.pMatrices, this.dMatrices, this.bMatrices, this.pWeights, this.dWeights, this.bWeights, this.ecWeight, this.pThresholds, this.dThresholds, this.bThresholds);
        } else if (alignerType.equals("IsoRank")) {
            this.aligner = new IsoRankAligner(this.d1Set, this.b1Set, this.edges1, this.d2Set, this.b2Set, this.edges2, this.pMatrix, this.dMatrix, this.bMatrix, this.ecMatrix, this.pMatrices, this.dMatrices, this.bMatrices, this.pWeights, this.dWeights, this.bWeights, this.ecWeight, this.pThresholds, this.dThresholds, this.bThresholds);
        } else if (alignerType.equals("Natalie")) {
            this.aligner = new NatalieAligner(this.d1Set, this.b1Set, this.edges1, this.d2Set, this.b2Set, this.edges2, this.pMatrix, this.dMatrix, this.bMatrix, this.ecMatrix, this.pMatrices, this.dMatrices, this.bMatrices, this.pWeights, this.dWeights, this.bWeights, this.ecWeight, this.pThresholds, this.dThresholds, this.bThresholds);
        } else if (alignerType.equals("NetAlign")) {
            this.aligner = new NetAligner(this.d1Set, this.b1Set, this.edges1, this.d2Set, this.b2Set, this.edges2, this.pMatrix, this.dMatrix, this.bMatrix, this.ecMatrix, this.pMatrices, this.dMatrices, this.bMatrices, this.pWeights, this.dWeights, this.bWeights, this.ecWeight, this.pThresholds, this.dThresholds, this.bThresholds);
        }
    }

    private void buildOrthologies(String filename) throws Exception {
        if (filename.length() == 0) {
            return;
        }
        BufferedReader in = new BufferedReader(new FileReader(filename));
        String line = "";
        while ((line = Static.skipCommentLines(in)) != null) {
            String[] split = line.split("\t");
            String protein1 = split[0];
            String protein2 = split[1];
            if (!this.allOrthologies.containsKey(protein1)) {
                this.allOrthologies.put(protein1, new HashSet());
            }
            this.allOrthologies.get(protein1).add(protein2);
            ++this.numOrthologies;
        }
        in.close();
    }

    private void buildOrthologousNodes(String filename) throws Exception {
        if (filename.length() == 0) {
            return;
        }
        BufferedReader in = new BufferedReader(new FileReader(filename));
        String line = "";
        while ((line = Static.skipCommentLines(in)) != null) {
            String[] split = line.split("\t");
            String node1 = split[0];
            String node2 = split[1];
            if (!this.allOrthologousNodes.containsKey(node1)) {
                this.allOrthologousNodes.put(node1, new HashSet());
            }
            this.allOrthologousNodes.get(node1).add(node2);
            ++this.numOrthologousNodes;
        }
        in.close();
    }

    public void addMatrixToAligner(String[] inputLine, List<ScoringMatrix> matrixList, ScoringMatrix masterMatrix, List<Double> thresholdList, List<Double> weightList) throws Exception {
        Double value = null;
        matrixList.add(new ScoringMatrix(inputLine[0], inputLine[0]));
        try {
            value = Double.valueOf(inputLine[2]);
            masterMatrix.addMatrix(matrixList.get(matrixList.size() - 1), value);
        }
        catch (NumberFormatException exception1) {
            value = 0.0;
        }
        weightList.add(value);
        try {
            thresholdList.add(Double.parseDouble(inputLine[3]));
        }
        catch (NumberFormatException except) {
            thresholdList.add(0.0);
        }
    }

    public void debug() throws Exception {
        if (this.aligner.alignment == null) {
            throw new Exception("Debug() cannot be run until an alignment has been produced.");
        }
        StringBuffer output = new StringBuffer();
        ArrayList<ArrayList<ScoringMatrix>> matrixListList = new ArrayList<ArrayList<ScoringMatrix>>();
        matrixListList.add(this.pMatrices);
        matrixListList.add(this.dMatrices);
        matrixListList.add(this.bMatrices);
        output.append("Species 1\tSpecies 2");
        int i = 0;
        while (i < matrixListList.size()) {
            int j = 0;
            while (j < ((ArrayList)matrixListList.get(i)).size()) {
                output.append("\t" + ((ScoringMatrix)((ArrayList)matrixListList.get((int)i)).get((int)j)).name);
                ++j;
            }
            ++i;
        }
        output.append("\tECScore\tTotal Score\tOrthologous");
        output.append("\n");
        for (Node node1 : this.aligner.alignment.order) {
            Node node2 = this.aligner.alignment.get(node1);
            output.append(String.valueOf(this.debugSub(node1, node2)) + "\n");
        }
        System.out.println(output.toString());
    }

    private String debugSub(Node node1, Node node2) throws Exception {
        StringBuffer output = new StringBuffer();
        double totalScore = 0.0;
        ArrayList<ArrayList<ScoringMatrix>> matrixListList = new ArrayList<ArrayList<ScoringMatrix>>();
        ArrayList<ArrayList<Double>> weightListList = new ArrayList<ArrayList<Double>>();
        matrixListList.add(this.pMatrices);
        matrixListList.add(this.dMatrices);
        matrixListList.add(this.bMatrices);
        weightListList.add(this.pWeights);
        weightListList.add(this.dWeights);
        weightListList.add(this.bWeights);
        output.append(String.valueOf(node1.name) + "\t" + node2.name);
        String protein1 = node1.getProteinName();
        String protein2 = node2.getProteinName();
        int i = 0;
        while (i < matrixListList.size()) {
            int j = 0;
            while (j < ((ArrayList)matrixListList.get(i)).size()) {
                ScoringMatrix m = (ScoringMatrix)((ArrayList)matrixListList.get(i)).get(j);
                if (m.contains(node1, node2)) {
                    output.append("\t" + Static.fourDecimals.format((Double)((ArrayList)weightListList.get(i)).get(j) * m.get(node1, node2)));
                    totalScore += (Double)((ArrayList)weightListList.get(i)).get(j) * m.get(node1, node2);
                } else {
                    Node pNode1 = new Node(protein1, 1);
                    Node pNode2 = new Node(protein2, 2);
                    if (m.contains(pNode1, pNode2)) {
                        output.append("\t" + Static.fourDecimals.format((Double)((ArrayList)weightListList.get(i)).get(j) * m.get(pNode1, pNode2)));
                        totalScore += (Double)((ArrayList)weightListList.get(i)).get(j) * m.get(pNode1, pNode2);
                    } else {
                        output.append("\t0");
                    }
                }
                ++j;
            }
            ++i;
        }
        output.append("\t" + Static.fourDecimals.format(this.ecWeight * this.ecMatrix.get(node1, node2)));
        output.append("\t" + Static.fourDecimals.format(totalScore += this.ecWeight * this.ecMatrix.get(node1, node2)));
        output.append("\t" + (this.allOrthologies.containsKey(protein1) && this.allOrthologies.get(protein1).contains(protein2) || this.allOrthologies.containsKey(protein2) && this.allOrthologies.get(protein2).contains(protein1)));
        return output.toString();
    }

    private void align() throws Exception {
        this.aligner.align();
        this.computeOrthologiesFound();
    }

    public void alignmentToFiles() throws Exception {
        String nodeName2;
        String nodeName1;
        String aligned;
        if (this.aligner.alignment == null) {
            throw new Exception("Alignment must be generated first!");
        }
        HashMap countedEdges = new HashMap();
        Alignment a = this.aligner.alignment;
        StringBuffer headerOutput = new StringBuffer();
        StringBuffer alignmentOutput = new StringBuffer();
        headerOutput.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n");
        headerOutput.append("<graph label=\"" + this.outputName + "\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:cy=\"http://www.cytoscape.org\" xmlns=\"http://www.cs.rpi.edu/XGMML\"  directed=\"0/\">\n");
        headerOutput.append("<att name=\"score\" type=\"string\" value=\"" + this.calcAlignmentScore() + "\" />\n");
        headerOutput.append("<att name=\"orthologies preserved\" type=\"string\" value=\"" + this.numOrthologiesFound + "/" + this.numOrthologies + " RPO; " + this.numOrthologousNodesFound + "/" + this.numOrthologousNodes + " OVP\" />\n");
        headerOutput.append("<!--\n" + this.getOrthologousNodes(this.orthologousNodesFound) + "-->\n");
        String edgesAligned = Arrays.toString(this.aligner.calcEdgeCorrectness());
        edgesAligned = edgesAligned.substring(1, edgesAligned.length() - 1);
        headerOutput.append("<att name=\"Edges correctly aligned, incorrectly aligned, max possible\" type=\"string\" value=\"" + edgesAligned + "\" />\n");
        headerOutput.append("<!--\n" + this.parameters + "-->\n");
        for (Node node1 : a.order) {
            Node node2 = a.get(node1);
            Object aligned2 = "aligned";
            if (this.orthologousNodesFound.containsKey(node1) && this.orthologousNodesFound.get(node1).contains(node2)) {
                aligned2 = "orthologous";
            }
            double edgeScore = this.aligner.calcEdgeScore(node1, node2);
            alignmentOutput.append("\t<node label=\"" + node1.name + " - " + node2.name + "\">\n" + "\t\t<att name=\"aligned\" type=\"string\" value=\"" + (String)aligned2 + "\" />\n" + "\t\t<att name=\"score\" type=\"real\" value=\"" + edgeScore + "\" />\n");
            if (this.d1Set.contains(node1) || this.d2Set.contains(node2)) {
                alignmentOutput.append("\t\t<att name=\"type\" type=\"string\" value=\"domain\" />\n");
            } else {
                alignmentOutput.append("\t\t<att name=\"type\" type=\"string\" value=\"ligand\" />\n");
            }
            alignmentOutput.append("\t\t<att name=\"seed\" type=\"boolean\" value=\"" + this.aligner.alignment.seed.contains(node1) + "\" />\n");
            alignmentOutput.append("\t</node>\n");
        }
        ArrayList<Node> d1List = new ArrayList<Node>(this.d1Set);
        Collections.sort(d1List, Collections.reverseOrder());
        for (Node node : d1List) {
            if (a.get(node) != null) continue;
            alignmentOutput.append("\t<node label=\"" + node.name + "\">\n" + "\t\t<att name=\"aligned\" type=\"string\" value=\"species1\" />\n" + "\t\t<att name=\"score\" type=\"real\" value=\"0\" />\n" + "\t\t<att name=\"type\" type=\"string\" value=\"domain\" />\n" + "\t\t<att name=\"seed\" type=\"boolean\" value=\"false\" />\n" + "\t</node>\n");
        }
        ArrayList<Node> b1List = new ArrayList<Node>(this.b1Set);
        Collections.sort(b1List, Collections.reverseOrder());
        for (Node node : b1List) {
            if (a.get(node) != null) continue;
            alignmentOutput.append("\t<node label=\"" + node.name + "\">\n" + "\t\t<att name=\"aligned\" type=\"string\" value=\"species1\" />\n" + "\t\t<att name=\"score\" type=\"real\" value=\"0\" />\n" + "\t\t<att name=\"type\" type=\"string\" value=\"binding site\" />\n" + "\t\t<att name=\"seed\" type=\"boolean\" value=\"false\" />\n" + "\t</node>\n");
        }
        ArrayList<Node> d2List = new ArrayList<Node>(this.d2Set);
        Collections.sort(d2List, Collections.reverseOrder());
        for (Node node : d2List) {
            if (a.get(node) != null) continue;
            alignmentOutput.append("\t<node label=\"" + node.name + "\">\n" + "\t\t<att name=\"aligned\" type=\"string\" value=\"species2\" />\n" + "\t\t<att name=\"score\" type=\"real\" value=\"0\" />\n" + "\t\t<att name=\"type\" type=\"string\" value=\"domain\" />\n" + "\t\t<att name=\"seed\" type=\"boolean\" value=\"false\" />\n" + "\t</node>\n");
        }
        ArrayList<Node> b2List = new ArrayList<Node>(this.d2Set);
        Collections.sort(b2List, Collections.reverseOrder());
        for (Node node : b2List) {
            if (a.get(node) != null) continue;
            alignmentOutput.append("\t<node label=\"" + node.name + "\">\n" + "\t\t<att name=\"aligned\" type=\"string\" value=\"species2\" />\n" + "\t\t<att name=\"score\" type=\"real\" value=\"0\" />\n" + "\t\t<att name=\"type\" type=\"string\" value=\"binding site\" />\n" + "\t\t<att name=\"seed\" type=\"boolean\" value=\"false\" />\n" + "\t</node>\n");
        }
        for (Node node1 : this.edges1.edges.keySet()) {
            for (Node node2 : this.edges1.getAdjacent(node1)) {
                if (countedEdges.containsKey(node1) && ((HashSet)countedEdges.get(node1)).contains(node2) || countedEdges.containsKey(node2) && ((HashSet)countedEdges.get(node2)).contains(node1)) continue;
                aligned = "species1";
                nodeName1 = node1.name;
                nodeName2 = node2.name;
                if (a.get(node1) != null) {
                    nodeName1 = String.valueOf(node1.name) + " - " + a.get((Node)node1).name;
                }
                if (a.get(node2) != null) {
                    nodeName2 = String.valueOf(node2.name) + " - " + a.get((Node)node2).name;
                }
                if (a.get(node1) != null && a.get(node2) != null && this.edges2.checkEdge(a.get(node1), a.get(node2))) {
                    aligned = "aligned";
                }
                if (!countedEdges.containsKey(node1)) {
                    countedEdges.put(node1, new HashSet());
                }
                ((HashSet)countedEdges.get(node1)).add(node2);
                alignmentOutput.append("\t<edge source=\"" + nodeName1 + "\" target=\"" + nodeName2 + "\" label=\"" + nodeName1 + " === " + nodeName2 + "\">\n" + "\t\t<att name=\"edgeCorrect\" type=\"string\" value=\"" + aligned + "\" />\n" + "\t</edge>\n");
            }
        }
        for (Node node1 : this.edges2.edges.keySet()) {
            for (Node node2 : this.edges2.getAdjacent(node1)) {
                if (countedEdges.containsKey(node1) && ((HashSet)countedEdges.get(node1)).contains(node2) || countedEdges.containsKey(node2) && ((HashSet)countedEdges.get(node2)).contains(node1)) continue;
                aligned = "species2";
                nodeName1 = node1.name;
                nodeName2 = node2.name;
                if (a.get(node1) != null) {
                    nodeName1 = String.valueOf(a.get((Node)node1).name) + " - " + node1.name;
                }
                if (a.get(node2) != null) {
                    nodeName2 = String.valueOf(a.get((Node)node2).name) + " - " + node2.name;
                }
                if (a.get(node1) != null && a.get(node2) != null && this.edges1.checkEdge(a.get(node1), a.get(node2))) continue;
                if (!countedEdges.containsKey(node1)) {
                    countedEdges.put(node1, new HashSet());
                }
                ((HashSet)countedEdges.get(node1)).add(node2);
                alignmentOutput.append("\t<edge source=\"" + nodeName1 + "\" target=\"" + nodeName2 + "\" label=\"" + nodeName1 + " === " + nodeName2 + "\">\n" + "\t\t<att name=\"edgeCorrect\" type=\"string\" value=\"" + aligned + "\" />\n" + "\t</edge>\n");
            }
        }
        alignmentOutput.append("</graph>");
        BufferedWriter out = new BufferedWriter(new FileWriter(String.valueOf(this.outputName.replace("<aligner>", this.aligner.alignerName)) + ".xgmml"));
        out.write(headerOutput.toString());
        out.write(alignmentOutput.toString());
        out.close();
    }

    private double calcAlignmentScore() throws Exception {
        Alignment a = this.aligner.alignment;
        double score = 0.0;
        for (Node node1 : a.forward.keySet()) {
            Node node2 = a.forward.get(node1);
            Node protein1 = new Node(node1.getProteinName(), 1);
            Node protein2 = new Node(node2.getProteinName(), 2);
            if (this.pMatrix != null) {
                score += this.pMatrix.get(protein1, protein2);
            }
            if (this.dMatrix.contains(node1, node2)) {
                score += this.dMatrix.get(node1, node2);
            }
            if (!this.bMatrix.contains(node1, node2)) continue;
            score += this.bMatrix.get(node1, node2);
        }
        return score;
    }

    public void computeOrthologiesFound() throws Exception {
        this.orthologiesFound = new HashMap();
        this.orthologousNodesFound = new HashMap();
        this.numOrthologiesFound = 0;
        this.numOrthologousNodesFound = 0;
        Alignment a = this.aligner.alignment;
        for (Node node1 : a.forward.keySet()) {
            Node node2 = a.forward.get(node1);
            String pName1 = node1.getProteinName();
            String pName2 = node2.getProteinName();
            if (!this.allOrthologies.containsKey(pName1) || !this.allOrthologies.get(pName1).contains(pName2)) continue;
            if (!this.orthologiesFound.containsKey(pName1)) {
                this.orthologiesFound.put(pName1, new HashSet());
            }
            if (!this.orthologiesFound.get(pName1).contains(pName2)) {
                this.orthologiesFound.get(pName1).add(pName2);
                ++this.numOrthologiesFound;
            }
            if (!this.orthologousNodesFound.containsKey(node1)) {
                this.orthologousNodesFound.put(node1, new HashSet());
            }
            this.orthologousNodesFound.get(node1).add(node2);
            ++this.numOrthologousNodesFound;
        }
    }

    private String getOrthologousNodes(HashMap<Node, HashSet<Node>> orthologousNodes) throws Exception {
        StringBuffer returnBuffer = new StringBuffer();
        ArrayList<Node> keyOrder = new ArrayList<Node>(orthologousNodes.keySet());
        Collections.sort(keyOrder);
        for (Node node1 : keyOrder) {
            ArrayList valueOrder = new ArrayList(orthologousNodes.get(node1));
            Collections.sort(valueOrder);
            for (Node node2 : valueOrder) {
                String score = Static.fourDecimals.format(this.aligner.calcEdgeScore(node1, node2));
                returnBuffer.append(node1 + " | " + node2 + " | " + score + "\n");
            }
        }
        return returnBuffer.toString();
    }

    public static void main(String[] args) throws Exception {
        Static.debug = false;
        String filename = "worm_yeast/best.reduced_max.params";
        String aligner = "GreedyPlus";
        if (args.length > 0) {
            filename = args[0];
        }
        if (args.length > 1) {
            aligner = args[1];
        }
        System.out.println("Parameter file: " + filename);
        System.out.println("Align setup: " + new Date().toString());
        AlignerWrapper aw = new AlignerWrapper(filename, aligner);
        System.out.println("Align start: " + new Date().toString());
        long timeStart = System.currentTimeMillis();
        aw.align();
        System.out.println("Alignment time (ms): " + (System.currentTimeMillis() - timeStart));
        System.out.println("Align end: " + new Date().toString());
        aw.alignmentToFiles();
        System.out.println("Align complete: " + new Date().toString());
    }
}

