/*
 * Decompiled with CFR 0.152.
 */
package DomainAlignment;

import DomainAlignment.AlignedPair;
import DomainAlignment.Aligner;
import DomainAlignment.EdgeList;
import DomainAlignment.Node;
import DomainAlignment.ScoringMatrix;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.PriorityQueue;

public class IsoRankAligner
extends Aligner {
    String species1;
    String species2;
    double eNormValue;
    double alpha;
    HashMap<Node, HashMap<Node, Double>> R = new HashMap();
    HashMap<Node, HashMap<Node, Double>> A = new HashMap();

    public IsoRankAligner(HashSet<Node> d1Set, HashSet<Node> b1Set, EdgeList edges1, HashSet<Node> d2Set, HashSet<Node> b2Set, EdgeList edges2, ScoringMatrix pMatrix, ScoringMatrix dMatrix, ScoringMatrix bMatrix, ScoringMatrix ecMatrix, ArrayList<ScoringMatrix> pMatrices, ArrayList<ScoringMatrix> dMatrices, ArrayList<ScoringMatrix> bMatrices, ArrayList<Double> pWeights, ArrayList<Double> dWeights, ArrayList<Double> bWeights, double ecWeight, ArrayList<Double> pThresholds, ArrayList<Double> dThresholds, ArrayList<Double> bThresholds) throws Exception {
        super(d1Set, b1Set, edges1, d2Set, b2Set, edges2, pMatrix, dMatrix, bMatrix, ecMatrix, pMatrices, dMatrices, bMatrices, pWeights, dWeights, bWeights, ecWeight, pThresholds, dThresholds, bThresholds);
        this.alignerName = "IsoRank";
        this.alpha = 0.6;
        this.setUpR();
        this.setUpA();
    }

    @Override
    public void alignSub() throws Exception {
        AlignedPair newPair;
        boolean stop = false;
        double threshold = 1.0E-4;
        int runs = 0;
        int K = 50;
        while (!stop) {
            HashMap R2 = new HashMap();
            double L1Norm = 0.0;
            for (Node nodeI : this.R.keySet()) {
                R2.put(nodeI, new HashMap());
                for (Node nodeJ : this.R.get(nodeI).keySet()) {
                    double E;
                    double newValue = 0.0;
                    for (Node nodeU : this.edges1.getAdjacent(nodeI)) {
                        for (Node nodeV : this.edges2.getAdjacent(nodeJ)) {
                            newValue += this.getA(nodeI, nodeJ, nodeU, nodeV) * this.R.get(nodeU).get(nodeV);
                        }
                    }
                    try {
                        E = this.calcEdgeScore(nodeI, nodeJ) / this.eNormValue;
                    }
                    catch (Exception e) {
                        E = 0.0;
                    }
                    ((HashMap)R2.get(nodeI)).put(nodeJ, this.alpha * newValue + (1.0 - this.alpha) * E);
                    L1Norm += Math.abs(this.R.get(nodeI).get(nodeJ) - (Double)((HashMap)R2.get(nodeI)).get(nodeJ));
                }
            }
            if (L1Norm < threshold || ++runs >= K) {
                stop = true;
            }
            if (runs >= K) {
                System.out.println("Runs: " + runs);
            }
            this.R = R2;
        }
        HashSet<Node> alignedNodes = new HashSet<Node>();
        PriorityQueue toBeAligned = new PriorityQueue(1, Collections.reverseOrder());
        for (Node node1 : this.d1Set) {
            for (Node node2 : this.d2Set) {
                if (!this.checkThresholds(node1, node2)) continue;
                newPair = new AlignedPair(node1, node2, this.R.get(node1).get(node2));
                toBeAligned.add(newPair);
            }
        }
        for (Node node1 : this.b1Set) {
            for (Node node2 : this.b2Set) {
                if (!this.checkThresholds(node1, node2)) continue;
                newPair = new AlignedPair(node1, node2, this.R.get(node1).get(node2));
                toBeAligned.add(newPair);
            }
        }
        while (!toBeAligned.isEmpty()) {
            AlignedPair newPair2 = (AlignedPair)toBeAligned.poll();
            if (alignedNodes.contains(newPair2.node1) || alignedNodes.contains(newPair2.node2)) continue;
            alignedNodes.add(newPair2.node1);
            alignedNodes.add(newPair2.node2);
            this.addEdgeToAlignment(newPair2.node1, newPair2.node2, false);
        }
    }

    public static void printMatrix(Double[][] matrix) {
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[i].length) {
                System.out.print(matrix[i][j] + " ");
                ++j;
            }
            System.out.println("");
            ++i;
        }
    }

    private void setUpR() {
        Iterator it2;
        for (Node node1 : this.d1Set) {
            this.R.put(node1, new HashMap());
            it2 = this.d2Set.iterator();
            while (it2.hasNext()) {
                this.R.get(node1).put((Node)it2.next(), Math.random());
            }
            it2 = this.b2Set.iterator();
            while (it2.hasNext()) {
                this.R.get(node1).put((Node)it2.next(), Math.random());
            }
        }
        for (Node node1 : this.b1Set) {
            this.R.put(node1, new HashMap());
            it2 = this.d2Set.iterator();
            while (it2.hasNext()) {
                this.R.get(node1).put((Node)it2.next(), Math.random());
            }
            it2 = this.b2Set.iterator();
            while (it2.hasNext()) {
                this.R.get(node1).put((Node)it2.next(), Math.random());
            }
        }
    }

    private void setUpA() throws Exception {
        this.eNormValue = 0.0;
        for (Node node1 : this.d1Set) {
            this.A.put(node1, new HashMap());
            for (Node node2 : this.d2Set) {
                this.A.get(node1).put(node2, 1.0 / (double)(this.edges1.getAdjacent(node1).size() * this.edges2.getAdjacent(node2).size()));
                this.eNormValue += this.calcEdgeScore(node1, node2);
            }
            for (Node node2 : this.b2Set) {
                this.A.get(node1).put(node2, 1.0 / (double)(this.edges1.getAdjacent(node1).size() * this.edges2.getAdjacent(node2).size()));
            }
        }
        for (Node node1 : this.b1Set) {
            this.A.put(node1, new HashMap());
            for (Node node2 : this.d2Set) {
                this.A.get(node1).put(node2, 1.0 / (double)(this.edges1.getAdjacent(node1).size() * this.edges2.getAdjacent(node2).size()));
            }
            for (Node node2 : this.b2Set) {
                this.A.get(node1).put(node2, 1.0 / (double)(this.edges1.getAdjacent(node1).size() * this.edges2.getAdjacent(node2).size()));
                this.eNormValue += this.calcEdgeScore(node1, node2);
            }
        }
    }

    private double getA(Node i, Node j, Node u, Node v) {
        if (this.edges1.areAdjacent(i, u) && this.edges2.areAdjacent(j, v)) {
            return this.A.get(u).get(v);
        }
        return 0.0;
    }

    public static void main(String[] args) throws Exception {
    }
}

