/*
 * Decompiled with CFR 0.152.
 */
package DomainAlignment;

public class Node
implements Comparable<Node> {
    public String name;
    int species;

    public Node(String name, int species) {
        this.name = name;
        this.species = species;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof Node)) {
            return false;
        }
        Node otherNode = (Node)other;
        return this.name.equals(otherNode.name) && this.species == otherNode.species;
    }

    @Override
    public int compareTo(Node other) {
        if (this.species != other.species) {
            return this.species - other.species;
        }
        return this.name.compareTo(other.name);
    }

    public int hashCode() {
        return (String.valueOf(this.name) + String.valueOf(this.species)).hashCode();
    }

    public String getProteinName() throws Exception {
        if (this.name.indexOf(44) == -1) {
            throw new Exception("Can't get the protein name of " + this.toString());
        }
        return this.name.substring(0, this.name.indexOf(44));
    }

    public String toString() {
        return "Species " + this.species + ": " + this.name;
    }
}

