/*
 * Decompiled with CFR 0.152.
 */
package DomainAlignment;

import DomainAlignment.AlignedPair;
import DomainAlignment.Aligner;
import DomainAlignment.EdgeList;
import DomainAlignment.Node;
import DomainAlignment.ScoringMatrix;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;

public class SSEAligner
extends Aligner {
    public SSEAligner(HashSet<Node> d1Set, HashSet<Node> b1Set, EdgeList edges1, HashSet<Node> d2Set, HashSet<Node> b2Set, EdgeList edges2, ScoringMatrix pMatrix, ScoringMatrix dMatrix, ScoringMatrix bMatrix, ScoringMatrix ecMatrix, ArrayList<ScoringMatrix> pMatrices, ArrayList<ScoringMatrix> dMatrices, ArrayList<ScoringMatrix> bMatrices, ArrayList<Double> pWeights, ArrayList<Double> dWeights, ArrayList<Double> bWeights, double ecWeight, ArrayList<Double> pThresholds, ArrayList<Double> dThresholds, ArrayList<Double> bThresholds) throws Exception {
        super(d1Set, b1Set, edges1, d2Set, b2Set, edges2, pMatrix, dMatrix, bMatrix, ecMatrix, pMatrices, dMatrices, bMatrices, pWeights, dWeights, bWeights, ecWeight, pThresholds, dThresholds, bThresholds);
        this.alignerName = "SSE";
    }

    @Override
    public void alignSub() throws Exception {
        HashSet<AlignedPair> toBeAligned = new HashSet<AlignedPair>();
        Node bestNode1 = null;
        Node bestNode2 = null;
        double maxScore = Double.MIN_VALUE;
        for (Node node1 : this.d1Set) {
            for (Node node2 : this.d2Set) {
                if (!(this.calcEdgeScore(node1, node2) > maxScore) || !this.checkThresholds(node1, node2)) continue;
                bestNode1 = node1;
                bestNode2 = node2;
                maxScore = this.calcEdgeScore(node1, node2);
            }
        }
        for (Node node1 : this.b1Set) {
            for (Node node2 : this.b2Set) {
                if (!(this.calcEdgeScore(node1, node2) > maxScore) || !this.checkThresholds(node1, node2)) continue;
                bestNode1 = node1;
                bestNode2 = node2;
                maxScore = this.calcEdgeScore(node1, node2);
            }
        }
        this.addEdgeToAlignment(bestNode1, bestNode2, true);
        this.singleSeedAndExtendHelper(bestNode1, bestNode2, toBeAligned);
        while (!toBeAligned.isEmpty()) {
            AlignedPair newPair = Collections.max(toBeAligned);
            Iterator<Object> it2 = toBeAligned.iterator();
            HashSet<AlignedPair> toBeRemoved = new HashSet<AlignedPair>();
            while (it2.hasNext()) {
                AlignedPair tempPair = (AlignedPair)it2.next();
                if (tempPair.contains(newPair.node1) || tempPair.contains(newPair.node2)) {
                    toBeRemoved.add(tempPair);
                    continue;
                }
                if (!this.edges1.checkEdge(tempPair.node1, newPair.node1) || !this.edges2.checkEdge(tempPair.node2, newPair.node2)) continue;
                this.ecMatrix.set(tempPair.node1, tempPair.node2, this.ecMatrix.get(tempPair.node1, tempPair.node2) + 1.0);
                tempPair.score += this.ecWeight;
            }
            toBeAligned.removeAll(toBeRemoved);
            this.addEdgeToAlignment(newPair.node1, newPair.node2, false);
            this.singleSeedAndExtendHelper(newPair.node1, newPair.node2, toBeAligned);
        }
    }

    private void singleSeedAndExtendHelper(Node node1, Node node2, HashSet<AlignedPair> toBeAligned) throws Exception {
        HashSet<Node> adj1 = this.edges1.getAdjacent(node1);
        HashSet<Node> adj2 = this.edges2.getAdjacent(node2);
        for (Node newNode1 : adj1) {
            for (Node newNode2 : adj2) {
                if (this.alignment.get(newNode1) != null || this.alignment.get(newNode2) != null || !this.checkThresholds(newNode1, newNode2)) continue;
                toBeAligned.add(new AlignedPair(newNode1, newNode2, this.calcEdgeScore(newNode1, newNode2) + this.calcEdgeECScore(newNode1, newNode2)));
            }
        }
    }
}

