/*
 * Decompiled with CFR 0.152.
 */
package DomainAlignment;

import DomainAlignment.Node;
import DomainAlignment.Static;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.HashMap;

public class ScoringMatrix {
    HashMap<Node, HashMap<Node, Double>> forward;
    public String name = "";

    public ScoringMatrix(String name) {
        this.forward = new HashMap();
        this.name = name;
    }

    public ScoringMatrix(String name, String filename) throws Exception {
        this.name = name;
        this.forward = new HashMap();
        BufferedReader in = new BufferedReader(new FileReader(filename));
        String line = in.readLine();
        String[] xHeaders = line.split("\t");
        int i = 1;
        while (i < xHeaders.length) {
            this.forward.put(new Node(xHeaders[i], 1), new HashMap());
            ++i;
        }
        while ((line = in.readLine()) != null) {
            String[] entries = line.split("\t");
            int i2 = 1;
            while (i2 < entries.length) {
                this.forward.get(new Node(xHeaders[i2], 1)).put(new Node(entries[0], 2), new Double(entries[i2]));
                ++i2;
            }
        }
        in.close();
    }

    public ScoringMatrix(ScoringMatrix old) {
        this.forward = new HashMap();
        for (Node node1 : old.forward.keySet()) {
            this.forward.put(node1, new HashMap());
            for (Node node2 : old.forward.get(node1).keySet()) {
                this.forward.get(node1).put(node2, old.forward.get(node1).get(node2));
            }
        }
    }

    public void reset() {
        for (Node node1 : this.forward.keySet()) {
            for (Node node2 : this.forward.get(node1).keySet()) {
                this.forward.get(node1).put(node2, 0.0);
            }
        }
    }

    public void addMatrix(ScoringMatrix newMatrix, double weight) throws Exception {
        if (this.forward.isEmpty()) {
            for (Node key1 : newMatrix.forward.keySet()) {
                this.forward.put(key1, new HashMap());
                for (Node key2 : newMatrix.forward.get(key1).keySet()) {
                    this.forward.get(key1).put(key2, newMatrix.forward.get(key1).get(key2) * weight);
                }
            }
            return;
        }
        if (!this.forward.keySet().equals(newMatrix.forward.keySet()) || !this.forward.values().iterator().next().keySet().equals(newMatrix.forward.values().iterator().next().keySet())) {
            throw new Exception("Scoring matrices do not operate on the same nodes.");
        }
        for (Node key1 : this.forward.keySet()) {
            for (Node key2 : this.forward.get(key1).keySet()) {
                this.forward.get(key1).put(key2, this.forward.get(key1).get(key2) + weight * newMatrix.get(key1, key2));
            }
        }
    }

    public boolean contains(Node node1, Node node2) {
        return this.forward.containsKey(node1) && this.forward.get(node1).containsKey(node2) || this.forward.containsKey(node2) && this.forward.get(node1).containsKey(node1);
    }

    public double get(Node node1, Node node2) throws Exception {
        if (this.forward.containsKey(node1) && this.forward.get(node1).containsKey(node2)) {
            return this.forward.get(node1).get(node2);
        }
        if (this.forward.containsKey(node2) && this.forward.get(node2).containsKey(node1)) {
            return this.forward.get(node2).get(node1);
        }
        throw new Exception(String.valueOf(node1.toString()) + "," + node2.toString() + " not found in this scoring matrix.");
    }

    public void set(Node node1, Node node2, double newScore) {
        if (!this.forward.containsKey(node1)) {
            this.forward.put(node1, new HashMap());
        }
        this.forward.get(node1).put(node2, newScore);
    }

    public int getSize() {
        return this.forward.size() * this.forward.get(this.forward.keySet().iterator().next()).size();
    }

    public void outputValues(boolean labels) throws Exception {
        StringBuffer output = new StringBuffer();
        for (Node node1 : this.forward.keySet()) {
            for (Node node2 : this.forward.get(node1).keySet()) {
                if (labels) {
                    output.append(String.valueOf(node1.name) + " - " + node2.name + "\t");
                }
                output.append(String.valueOf(Static.fourDecimals.format(this.forward.get(node1).get(node2))) + "\n");
            }
        }
        String returnValue = output.toString();
        returnValue = returnValue.substring(0, returnValue.length() - 1);
        BufferedWriter out = new BufferedWriter(new FileWriter(String.valueOf(this.name.substring(0, this.name.lastIndexOf(46))) + ".flattened.txt"));
        out.write(returnValue);
        out.close();
    }

    public String toString() {
        return this.forward.toString();
    }

    public static double getEditDistance(ScoringMatrix first, ScoringMatrix second) throws Exception {
        if (!first.forward.keySet().equals(second.forward.keySet()) || !first.forward.values().iterator().next().keySet().equals(second.forward.values().iterator().next().keySet())) {
            throw new Exception("Scoring matrices do not operate on the same nodes.");
        }
        double diff = 0.0;
        for (Node node1 : first.forward.keySet()) {
            for (Node node2 : first.forward.get(node1).keySet()) {
                diff += Math.abs(first.get(node1, node2) - second.get(node1, node2));
            }
        }
        return diff;
    }

    public static double getEuclideanDistance(ScoringMatrix first, ScoringMatrix second) throws Exception {
        if (!first.forward.keySet().equals(second.forward.keySet()) || !first.forward.values().iterator().next().keySet().equals(second.forward.values().iterator().next().keySet())) {
            throw new Exception("Scoring matrices do not operate on the same nodes.");
        }
        double diff = 0.0;
        for (Node node1 : first.forward.keySet()) {
            for (Node node2 : first.forward.get(node1).keySet()) {
                diff += Math.pow(first.get(node1, node2) - second.get(node1, node2), 2.0);
            }
        }
        return Math.sqrt(diff / (double)first.getSize());
    }

    public static void main(String[] args) throws Exception {
        String[] matrices;
        String[] stringArray = matrices = new String[]{"worm_yeast/aslp.worm_yeast.binding_site.txt", "worm_yeast/aslp.worm_yeast.domain.txt", "worm_yeast/betweenness.worm_yeast.binding_site.txt", "worm_yeast/betweenness.worm_yeast.domain.txt", "worm_yeast/closeness.worm_yeast.binding_site.txt", "worm_yeast/closeness.worm_yeast.domain.txt", "worm_yeast/degree.worm_yeast.binding_site.txt", "worm_yeast/degree.worm_yeast.domain.txt", "worm_yeast/eccentricity.worm_yeast.binding_site.txt", "worm_yeast/eccentricity.worm_yeast.domain.txt", "worm_yeast/nc.worm_yeast.binding_site.txt", "worm_yeast/nc.worm_yeast.domain.txt", "worm_yeast/radiality.worm_yeast.binding_site.txt", "worm_yeast/radiality.worm_yeast.domain.txt", "worm_yeast/stress.worm_yeast.binding_site.txt", "worm_yeast/stress.worm_yeast.domain.txt", "worm_yeast/tc.worm_yeast.binding_site.txt", "worm_yeast/tc.worm_yeast.domain.txt", "worm_yeast/graphlet.worm_yeast.binding_site.txt", "worm_yeast/graphlet.worm_yeast.domain.txt", "worm_yeast/tcss.worm_yeast.bp.txt", "worm_yeast/tcss.worm_yeast.cc.txt", "worm_yeast/tcss.worm_yeast.mf.txt", "worm_yeast/blast.worm_yeast.domain_coverage.txt", "worm_yeast/blast.worm_yeast.domain_score.txt", "worm_yeast/blast.worm_yeast.protein_coverage.txt", "worm_yeast/blast.worm_yeast.protein_score.txt", "worm_yeast/smith_waterman.worm_yeast.binding_site_coverage.txt", "worm_yeast/smith_waterman.worm_yeast.binding_site_score.txt"};
        int n = matrices.length;
        int n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            System.out.println(filename);
            ScoringMatrix matrix = new ScoringMatrix(filename, filename);
            matrix.outputValues(true);
            ++n2;
        }
    }
}

