/*
 * Decompiled with CFR 0.152.
 */
package DomainAlignment;

import DomainAlignment.Node;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Static {
    public static NumberFormat twoDecimals = new DecimalFormat("0.00");
    public static NumberFormat fourDecimals = new DecimalFormat("0.0000");
    public static NumberFormat twoDigits = new DecimalFormat("00");
    public static NumberFormat fourDigits = new DecimalFormat("0000");
    public static boolean debug;

    public static void adjListToXGMML(String inputFile) throws Exception {
        String outputName = inputFile.substring(Math.max(0, inputFile.lastIndexOf(47) + 1), inputFile.lastIndexOf(46));
        BufferedReader in = new BufferedReader(new FileReader(inputFile));
        BufferedWriter out = new BufferedWriter(new FileWriter(String.valueOf(inputFile.substring(0, inputFile.lastIndexOf(46))) + ".xgmml"));
        String line = "";
        StringBuffer output = new StringBuffer();
        StringBuffer output2 = new StringBuffer();
        HashMap<String, Integer> nodeMap = new HashMap<String, Integer>();
        int counter = (int)(-2.147483648E9 + Math.random() * 4.293967295E9);
        output.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n");
        output.append("<graph label=\"" + outputName + "\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:cy=\"http://www.cytoscape.org\" xmlns=\"http://www.cs.rpi.edu/XGMML\"  directed=\"0/\">\n");
        while ((line = Static.skipCommentLines(in)) != null) {
            String[] split = line.split("[,\t]+");
            String node1 = String.valueOf(split[0]) + " (" + split[2] + "/" + split[3] + ")";
            String node2 = String.valueOf(split[4]) + " (" + split[6] + "/" + split[7] + ")";
            if (!nodeMap.containsKey(node1)) {
                nodeMap.put(node1, counter);
                ++counter;
            }
            output.append("\t<node id=\"" + node1 + "\" label=\"" + node1 + "\">\n" + "\t\t<att name=\"label\" value=\"" + node1 + "\" />\n" + "\t</node>\n");
            if (!nodeMap.containsKey(node2)) {
                nodeMap.put(node2, counter);
                ++counter;
            }
            output.append("\t<node id=\"" + node2 + "\" label=\"" + node2 + "\">\n" + "\t\t<att name=\"label\" value=\"" + node2 + "\" />\n" + "\t</node>\n");
            output2.append("\t<edge source=\"" + node1 + "\" target=\"" + node2 + "\" label=\"" + nodeMap.get(node1) + nodeMap.get(node2) + "\">\n" + "\t\t<att name=\"label\" value=\"" + node1 + " - " + node2 + "\" />\n" + "\t</edge>\n");
        }
        output2.append("</graph>");
        out.write(String.valueOf(output.toString()) + output2.toString());
        in.close();
        out.close();
    }

    public static void createScoringMatrixFromLinearData(List<String> order1, List<String> order2, HashMap<String, Double> scores1, HashMap<String, Double> scores2, String filename) throws Exception {
        BufferedWriter out = new BufferedWriter(new FileWriter(filename));
        StringBuffer output = new StringBuffer();
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (String node1 : scores1.keySet()) {
            for (String node2 : scores2.keySet()) {
                if (!order1.contains(node1) || !order2.contains(node2)) continue;
                min = Math.min(min, Math.abs(scores1.get(node1) - scores2.get(node2)));
                max = Math.max(max, Math.abs(scores1.get(node1) - scores2.get(node2)));
            }
        }
        int i = 0;
        while (i < order1.size()) {
            output.append("\t" + order1.get(i));
            ++i;
        }
        output.append("\n");
        i = 0;
        while (i < order2.size()) {
            output.append(order2.get(i));
            String node2 = order2.get(i);
            int j = 0;
            while (j < order1.size()) {
                String node1 = order1.get(j);
                output.append("\t" + fourDecimals.format(1.0 - (Math.abs(scores1.get(node1) - scores2.get(node2)) - min) / (max - min)));
                ++j;
            }
            output.append("\n");
            ++i;
        }
        out.write(output.toString());
        out.close();
    }

    public static void createScoringMatrixFromLogData(List<String> order1, List<String> order2, HashMap<String, Double> scores1, HashMap<String, Double> scores2, String filename) throws Exception {
        BufferedWriter out = new BufferedWriter(new FileWriter(filename));
        StringBuffer output = new StringBuffer();
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (String node1 : scores1.keySet()) {
            for (String node2 : scores2.keySet()) {
                if (!order1.contains(node1) || !order2.contains(node2)) continue;
                min = Math.min(min, Math.log(Math.abs(scores1.get(node1) - scores2.get(node2)) + 1.0));
                max = Math.max(max, Math.log(Math.abs(scores1.get(node1) - scores2.get(node2)) + 1.0));
            }
        }
        int i = 0;
        while (i < order1.size()) {
            output.append("\t" + order1.get(i));
            ++i;
        }
        output.append("\n");
        i = 0;
        while (i < order2.size()) {
            output.append(order2.get(i));
            String node2 = order2.get(i);
            int j = 0;
            while (j < order1.size()) {
                String node1 = order1.get(j);
                output.append("\t" + fourDecimals.format(Math.log(Math.abs(scores1.get(node1) - scores2.get(node2)) + 1.0) / (max - min)));
                ++j;
            }
            output.append("\n");
            ++i;
        }
        out.write(output.toString());
        out.close();
    }

    public static void populateNodeLists(HashSet<Node> hashSet, HashSet<Node> hashSet2, String fileName) throws Exception {
        if (hashSet.isEmpty()) {
            BufferedReader in = new BufferedReader(new FileReader(fileName));
            String line = "";
            String[] values = in.readLine().split("\t");
            int i = 1;
            while (i < values.length) {
                hashSet.add(new Node(values[i], 1));
                ++i;
            }
            while ((line = in.readLine()) != null) {
                hashSet2.add(new Node(line.split("\t")[0], 2));
            }
            in.close();
        }
    }

    public static void shuffleAdjList(String filename) throws Exception {
        ArrayList<String> col1 = new ArrayList<String>();
        ArrayList<String> col2 = new ArrayList<String>();
        HashMap map = new HashMap();
        BufferedReader in = new BufferedReader(new FileReader(filename));
        String line = "";
        DecimalFormat formatter = new DecimalFormat("0000");
        while ((line = Static.skipCommentLines(in)) != null) {
            String[] split = line.split("\t");
            col1.add(split[0]);
            col2.add(split[1]);
            if (!map.containsKey(split[0])) {
                map.put(split[0], new HashSet());
            }
            ((HashSet)map.get(split[0])).add(split[1]);
        }
        in.close();
        int sims = 1;
        while (sims <= 1000) {
            int i = 0;
            while (i < col2.size()) {
                int j = 0;
                while (j < 1000) {
                    int index = (int)Math.ceil(Math.random() * (double)(col2.size() - i - 1)) + i;
                    if (!((HashSet)map.get(col1.get(index))).contains(col2.get(i)) && !((HashSet)map.get(col1.get(i))).contains(col2.get(index))) {
                        ((HashSet)map.get(col1.get(i))).remove(col2.get(i));
                        ((HashSet)map.get(col1.get(i))).add((String)col2.get(index));
                        ((HashSet)map.get(col1.get(index))).remove(col2.get(index));
                        ((HashSet)map.get(col1.get(index))).add((String)col2.get(i));
                        String temp = (String)col2.get(i);
                        col2.set(i, (String)col2.get(index));
                        col2.set(index, temp);
                        j = 1001;
                    }
                    ++j;
                }
                ++i;
            }
            BufferedWriter out = new BufferedWriter(new FileWriter("random/" + filename.substring(0, filename.lastIndexOf(46)) + "_randomized_" + formatter.format(sims) + ".txt"));
            StringBuffer output = new StringBuffer();
            for (String key : map.keySet()) {
                for (String match : (HashSet)map.get(key)) {
                    output.append(String.valueOf(key) + "\t" + match + "\n");
                }
            }
            out.write(output.toString());
            out.close();
            ++sims;
        }
    }

    public static String skipCommentLines(BufferedReader in) throws IOException {
        String line = in.readLine();
        while (line != null && line.length() > 0 && line.charAt(0) == '!') {
            line = in.readLine();
        }
        return line;
    }

    public static void clustalToFasta(String inputFile, String outputFile) throws Exception {
        BufferedReader in = new BufferedReader(new FileReader(inputFile));
        String line = "";
        StringBuffer output = new StringBuffer();
        while ((line = in.readLine()) != null) {
            String[] split = line.split(" +");
            output.append(">" + split[0].replace('_', ',') + "\n");
            output.append(String.valueOf(split[1]) + "\n");
        }
        in.close();
        BufferedWriter out = new BufferedWriter(new FileWriter(outputFile));
        out.write(output.toString());
        out.close();
    }

    private static void cytoscapeFormat() throws Exception {
        BufferedReader in = new BufferedReader(new FileReader("yeast/Yeast_Adjacency_List.Merged_Final.txt"));
        StringBuffer output = new StringBuffer();
        String line = "";
        while ((line = in.readLine()) != null) {
            String[] split = line.split("[,\t]+");
            output.append(String.valueOf(split[0]) + " (" + split[2] + "/" + split[3] + ")\t" + split[4] + " (" + split[6] + "/" + split[7] + ")\n");
        }
        in.close();
        BufferedWriter out = new BufferedWriter(new FileWriter("yeast/Yeast_Adjacency_List.Merged_Final.cytoscape.txt"));
        out.write(output.toString());
        out.close();
    }

    public static HashMap<String, Set<String>> uniprot2genes(String interactionFile, String uniprot2enspFile, String domainFile) throws IOException {
        BufferedReader in = null;
        String line = "";
        HashMap uniprot2ensembl = new HashMap();
        HashMap<String, Set<String>> uniprot2names = new HashMap<String, Set<String>>();
        if (uniprot2enspFile == null) {
            return uniprot2names;
        }
        in = new BufferedReader(new FileReader(uniprot2enspFile));
        in.readLine();
        while ((line = in.readLine()) != null) {
            String[] split = line.split("\t");
            if (!uniprot2ensembl.containsKey(split[0])) {
                uniprot2ensembl.put(split[0], new HashSet());
            }
            ((HashSet)uniprot2ensembl.get(split[0])).add(split[1]);
        }
        in.close();
        in = new BufferedReader(new FileReader(domainFile));
        in.readLine();
        HashMap gsToPs = new HashMap();
        while ((line = in.readLine()) != null) {
            String[] split = line.replace("*", "").split("\t");
            if (!gsToPs.containsKey(split[2])) {
                gsToPs.put(split[2], new HashSet());
            }
            ((HashSet)gsToPs.get(split[2])).add(split[3].replace("*", ""));
        }
        in.close();
        HashMap<String, String> ensembl2names = new HashMap<String, String>();
        in = new BufferedReader(new FileReader(interactionFile));
        while ((line = in.readLine()) != null) {
            String[] split = line.split("[,\t]");
            ensembl2names.put(split[1], split[0]);
            ensembl2names.put(split[5], split[4]);
        }
        in.close();
        for (String uniprot : uniprot2ensembl.keySet()) {
            for (String ensembl : (HashSet)uniprot2ensembl.get(uniprot)) {
                if (!ensembl2names.containsKey(ensembl)) continue;
                if (!uniprot2names.containsKey(uniprot)) {
                    uniprot2names.put(uniprot, new HashSet());
                }
                uniprot2names.get(uniprot).add((String)ensembl2names.get(ensembl));
            }
        }
        return uniprot2names;
    }

    public static void addTo2WayMultiMap(HashMap<String, HashSet<String>> map, String item1, String item2) {
        if (!map.containsKey(item1)) {
            map.put(item1, new HashSet());
        }
        if (!map.containsKey(item2)) {
            map.put(item2, new HashSet());
        }
        map.get(item1).add(item2);
        map.get(item2).add(item1);
    }

    public static double[][] deepCopy(double[][] oldCopy) {
        double[][] newCopy = new double[oldCopy.length][oldCopy[0].length];
        int i = 0;
        while (i < oldCopy.length) {
            int j = 0;
            while (j < oldCopy[i].length) {
                newCopy[i][j] = oldCopy[i][j];
                ++j;
            }
            ++i;
        }
        return newCopy;
    }

    public static void debugOutput(String text) {
        if (debug) {
            System.out.println(text);
        }
    }

    public static void main(String[] args) throws Exception {
    }
}

