/*
 * Decompiled with CFR 0.152.
 */
package DomainAlignment;

import DomainAlignment.AlignedPair;
import DomainAlignment.Alignment;
import DomainAlignment.EdgeList;
import DomainAlignment.Node;
import DomainAlignment.ScoringMatrix;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.PriorityQueue;

public abstract class Aligner {
    Alignment alignment;
    String alignerName;
    public ArrayList<ScoringMatrix> pMatrices = null;
    public ArrayList<ScoringMatrix> dMatrices = null;
    public ArrayList<ScoringMatrix> bMatrices = null;
    ScoringMatrix pMatrix = null;
    ScoringMatrix dMatrix = null;
    ScoringMatrix bMatrix = null;
    ScoringMatrix ecMatrix = null;
    ArrayList<Double> pWeights = null;
    ArrayList<Double> dWeights = null;
    ArrayList<Double> bWeights = null;
    double ecWeight = 0.0;
    ArrayList<Double> pThresholds = null;
    ArrayList<Double> dThresholds = null;
    ArrayList<Double> bThresholds = null;
    EdgeList edges1;
    EdgeList edges2;
    HashSet<Node> p1List = null;
    HashSet<Node> p2List = null;
    HashSet<Node> d1Set = null;
    HashSet<Node> d2Set = null;
    HashSet<Node> b1Set = null;
    HashSet<Node> b2Set = null;

    public Aligner(HashSet<Node> d1Set, HashSet<Node> b1Set, EdgeList edges1, HashSet<Node> d2Set, HashSet<Node> b2Set, EdgeList edges2, ScoringMatrix pMatrix, ScoringMatrix dMatrix, ScoringMatrix bMatrix, ScoringMatrix ecMatrix, ArrayList<ScoringMatrix> pMatrices, ArrayList<ScoringMatrix> dMatrices, ArrayList<ScoringMatrix> bMatrices, ArrayList<Double> pWeights, ArrayList<Double> dWeights, ArrayList<Double> bWeights, double ecWeight, ArrayList<Double> pThresholds, ArrayList<Double> dThresholds, ArrayList<Double> bThresholds) {
        this.d1Set = d1Set;
        this.b1Set = b1Set;
        this.edges1 = edges1;
        this.d2Set = d2Set;
        this.b2Set = b2Set;
        this.edges2 = edges2;
        this.pMatrix = pMatrix;
        this.dMatrix = dMatrix;
        this.bMatrix = bMatrix;
        this.ecMatrix = ecMatrix;
        this.pMatrices = pMatrices;
        this.dMatrices = dMatrices;
        this.bMatrices = bMatrices;
        this.pWeights = pWeights;
        this.dWeights = dWeights;
        this.bWeights = bWeights;
        this.ecWeight = ecWeight;
        this.pThresholds = pThresholds;
        this.dThresholds = dThresholds;
        this.bThresholds = bThresholds;
    }

    public void align() throws Exception {
        this.alignment = new Alignment();
        this.alignment.score = 0.0;
        this.alignment.ecScore = 0.0;
        this.ecMatrix.reset();
        this.alignSub();
    }

    public abstract void alignSub() throws Exception;

    protected PriorityQueue<AlignedPair> greedyAlignSub(ArrayList<HashSet<Node>> reorderedRadii) throws Exception {
        PriorityQueue<AlignedPair> toBeAligned = new PriorityQueue<AlignedPair>(1, Collections.reverseOrder());
        int i = 0;
        while (i < reorderedRadii.size()) {
            for (Node node1 : reorderedRadii.get(i)) {
                for (Node node2 : reorderedRadii.get(i + 1)) {
                    if (!this.checkThresholds(node1, node2)) continue;
                    AlignedPair newPair = new AlignedPair(node1, node2, this.calcEdgeScore(node1, node2));
                    toBeAligned.add(newPair);
                }
            }
            i += 2;
        }
        return toBeAligned;
    }

    public double calcEdgeScore(Node node1, Node node2) throws Exception {
        double score = 0.0;
        if (this.pMatrix != null && this.pMatrix.forward.size() > 0) {
            score += this.pMatrix.get(new Node(node1.getProteinName(), node1.species), new Node(node2.getProteinName(), node2.species));
        }
        if (this.dMatrix != null && this.dMatrix.contains(node1, node2)) {
            score += this.dMatrix.get(node1, node2);
        } else if (this.bMatrix != null && this.bMatrix.contains(node1, node2)) {
            score += this.bMatrix.get(node1, node2);
        } else {
            throw new Exception(node1 + ", " + node2 + " not found in either domain or binding site matrices.");
        }
        return score += this.calcEdgeECScore(node1, node2);
    }

    public double calcEdgeECScore(Node node1, Node node2) throws Exception {
        if (this.ecWeight != 0.0) {
            return this.ecWeight * this.ecMatrix.get(node1, node2);
        }
        return 0.0;
    }

    public double calcScore() throws Exception {
        this.alignment.score = 0.0;
        for (Node node1 : this.alignment.forward.keySet()) {
            Node node2 = this.alignment.forward.get(node1);
            this.alignment.score += this.calcEdgeScore(node1, node2);
        }
        return this.alignment.score;
    }

    public int[] calcEdgeCorrectness() throws Exception {
        int counter = 0;
        int right = 0;
        int wrong = 0;
        EdgeList edges1 = this.edges1;
        EdgeList edges2 = this.edges2;
        if (this.edges2.size < this.edges1.size) {
            edges1 = this.edges2;
            edges2 = this.edges1;
        }
        for (Node node1 : edges1.edges.keySet()) {
            for (Node node2 : edges1.edges.get(node1)) {
                if (node1.name.compareTo(node2.name) < 0) continue;
                ++counter;
                if (this.alignment.get(node1) == null || this.alignment.get(node2) == null) continue;
                if (edges2.areAdjacent(this.alignment.get(node1), this.alignment.get(node2))) {
                    ++right;
                    continue;
                }
                ++wrong;
            }
        }
        int[] returnValue = new int[]{right, wrong, counter};
        return returnValue;
    }

    public boolean checkThresholds(Node node1, Node node2) throws Exception {
        return true;
    }

    public String alignmentToString() {
        return "! score = " + this.alignment.score + "\n" + this.alignment.toString();
    }

    protected void addEdgeToAlignment(Node node1, Node node2, boolean seed) throws Exception {
        this.alignment.add(node1, node2, seed);
    }

    public static void main(String[] args) throws Exception {
    }
}

