/*
 * Decompiled with CFR 0.152.
 */
package DomainAlignment;

import DomainAlignment.AlignedPair;
import DomainAlignment.Aligner;
import DomainAlignment.EdgeList;
import DomainAlignment.Node;
import DomainAlignment.ScoringMatrix;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.PriorityQueue;

public class CGraalAligner
extends Aligner {
    private double denom = 0.0;
    private Hashtable<Node, Integer> nds;

    public CGraalAligner(HashSet<Node> d1Set, HashSet<Node> b1Set, EdgeList edges1, HashSet<Node> d2Set, HashSet<Node> b2Set, EdgeList edges2, ScoringMatrix pMatrix, ScoringMatrix dMatrix, ScoringMatrix bMatrix, ScoringMatrix ecMatrix, ArrayList<ScoringMatrix> pMatrices, ArrayList<ScoringMatrix> dMatrices, ArrayList<ScoringMatrix> bMatrices, ArrayList<Double> pWeights, ArrayList<Double> dWeights, ArrayList<Double> bWeights, double ecWeight, ArrayList<Double> pThresholds, ArrayList<Double> dThresholds, ArrayList<Double> bThresholds) throws Exception {
        super(d1Set, b1Set, edges1, d2Set, b2Set, edges2, pMatrix, dMatrix, bMatrix, ecMatrix, pMatrices, dMatrices, bMatrices, pWeights, dWeights, bWeights, ecWeight, pThresholds, dThresholds, bThresholds);
        this.alignerName = "CGraal";
    }

    @Override
    public void alignSub() throws Exception {
        HashSet<Node> neighbours;
        Node node1;
        double cnd;
        this.nds = new Hashtable();
        int maxND1 = this.calcNeighbourhoodDensities(this.nds, this.edges1);
        int maxND2 = this.calcNeighbourhoodDensities(this.nds, this.edges2);
        this.denom = maxND1 + maxND2;
        PriorityQueue<AlignedPair> seedsToBe = new PriorityQueue<AlignedPair>(this.d1Set.size() * this.d2Set.size() + this.b1Set.size() * this.b2Set.size(), Collections.reverseOrder());
        ArrayList nodes1 = new ArrayList(this.d1Set);
        nodes1.addAll(this.b1Set);
        ArrayList nodes2 = new ArrayList(this.d2Set);
        nodes2.addAll(this.b2Set);
        for (Node n1 : this.d1Set) {
            for (Node n2 : this.d2Set) {
                cnd = (double)(this.nds.get(n1) + this.nds.get(n2)) / this.denom;
                seedsToBe.add(new AlignedPair(n1, n2, cnd));
            }
        }
        for (Node n1 : this.b1Set) {
            for (Node n2 : this.b2Set) {
                cnd = (double)(this.nds.get(n1) + this.nds.get(n2)) / this.denom;
                seedsToBe.add(new AlignedPair(n1, n2, cnd));
            }
        }
        LinkedList pseudoSeedsToBe = new LinkedList(seedsToBe);
        Collections.sort(pseudoSeedsToBe, Collections.reverseOrder());
        int i = 0;
        while (i < nodes1.size()) {
            node1 = (Node)nodes1.get(i);
            int j = i + 1;
            while (j < nodes1.size()) {
                Node node2 = (Node)nodes1.get(j);
                neighbours = this.edges1.getAdjacent(node1);
                neighbours.retainAll(this.edges1.getAdjacent(node2));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < nodes2.size()) {
            node1 = (Node)nodes2.get(i);
            int j = i + 1;
            while (j < nodes1.size()) {
                Node node2 = (Node)nodes1.get(j);
                neighbours = this.edges1.getAdjacent(node1);
                neighbours.retainAll(this.edges2.getAdjacent(node2));
                ++j;
            }
            ++i;
        }
        int alignmentIndex = 0;
        do {
            this.step1(seedsToBe);
            this.step2();
        } while (this.checkStep3Condition(alignmentIndex) != -1);
        this.step3();
    }

    private AlignedPair step1(PriorityQueue<AlignedPair> seedsToBe) throws Exception {
        AlignedPair bestPair = null;
        Node node1 = null;
        Node node2 = null;
        while (!seedsToBe.isEmpty()) {
            bestPair = seedsToBe.poll();
            node1 = bestPair.node1;
            node2 = bestPair.node2;
            if (this.alignment.contains(node1) || this.alignment.contains(node2)) continue;
            this.addEdgeToAlignment(node1, node2, true);
            break;
        }
        HashSet<Node> unalignedNeighbourhood1 = new HashSet<Node>();
        for (Node neighbour1 : this.edges1.getAdjacent(node1)) {
            if (this.alignment.contains(neighbour1)) continue;
            unalignedNeighbourhood1.add(neighbour1);
        }
        HashSet<Node> unalignedNeighbourhood2 = new HashSet<Node>();
        for (Node neighbour2 : this.edges2.getAdjacent(node2)) {
            if (this.alignment.contains(neighbour2)) continue;
            unalignedNeighbourhood2.add(neighbour2);
        }
        this.alignNeighbourhoods(unalignedNeighbourhood1, unalignedNeighbourhood2);
        return bestPair;
    }

    /*
     * Unable to fully structure code
     */
    private void step2() throws Exception {
        stage1Done = false;
        ** GOTO lbl53
        {
            stage1Done = true;
            savedNode1 = null;
            savedNode2 = null;
            mostCommonNeighbours = new HashSet<Node>();
            mostCommonNeighboursComplement = new HashSet<Node>();
            alignedNodes1 = new ArrayList<Node>(this.alignment.forward.keySet());
            i = 0;
            while (i < alignedNodes1.size()) {
                node1 = alignedNodes1.get(i);
                j = i + 1;
                while (j < alignedNodes1.size()) {
                    node2 = alignedNodes1.get(j);
                    un1 = this.getUnalignedNeighbours(node1, this.edges1);
                    un2 = this.getUnalignedNeighbours(node2, this.edges1);
                    un1.retainAll(un2);
                    if (un1.size() != 0) {
                        un3 = this.getUnalignedNeighbours(this.alignment.get(node1), this.edges2);
                        un4 = this.getUnalignedNeighbours(this.alignment.get(node2), this.edges2);
                        un3.retainAll(un4);
                        if (un3.size() != 0 && un1.size() > mostCommonNeighbours.size()) {
                            stage1Done = false;
                            mostCommonNeighbours = un1;
                            mostCommonNeighboursComplement = un3;
                            savedNode1 = node1;
                            savedNode2 = node2;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            this.alignNeighbourhoods(mostCommonNeighbours, mostCommonNeighboursComplement);
            do {
                if (!stage1Done) continue block0;
                ntba1 = null;
                ntba2 = null;
                maxCND = -Infinity;
                for (Node node1 : this.alignment.forward.keySet()) {
                    node2 = this.alignment.get(node1);
                    neighbours1 = this.getUnalignedNeighbours(node1, this.edges1);
                    neighbours2 = this.getUnalignedNeighbours(node2, this.edges2);
                    if (neighbours1.size() == 0 || neighbours2.size() == 0 || !((cnd = (double)(this.nds.get(node1) + this.nds.get(node2)) / this.denom) > maxCND)) continue;
                    stage1Done = false;
                    ntba1 = node1;
                    ntba2 = node2;
                    maxCND = cnd;
                }
                neighbours1 = this.getUnalignedNeighbours(ntba1, this.edges1);
                neighbours2 = this.getUnalignedNeighbours(ntba2, this.edges2);
                this.alignNeighbourhoods(neighbours1, neighbours2);
lbl53:
                // 2 sources

            } while (!stage1Done);
        }
    }

    private HashSet<Node> getUnalignedNeighbours(Node node, EdgeList edges) {
        HashSet<Node> neighbours = edges.getAdjacent(node);
        HashSet<Node> unalignedNeighbours = new HashSet<Node>();
        for (Node neighbour : neighbours) {
            if (this.alignment.contains(neighbour)) continue;
            unalignedNeighbours.add(neighbour);
        }
        return unalignedNeighbours;
    }

    private void step3() throws Exception {
        HashSet<Node> unaligned1 = new HashSet<Node>();
        HashSet<Node> unaligned2 = new HashSet<Node>();
        for (Node node : this.d1Set) {
            if (this.alignment.contains(node)) continue;
            unaligned1.add(node);
        }
        for (Node node : this.d2Set) {
            if (this.alignment.contains(node)) continue;
            unaligned2.add(node);
        }
        this.alignNeighbourhoods(unaligned1, unaligned2);
        unaligned1 = new HashSet();
        unaligned2 = new HashSet();
        for (Node node : this.b1Set) {
            if (this.alignment.contains(node)) continue;
            unaligned1.add(node);
        }
        for (Node node : this.b2Set) {
            if (this.alignment.contains(node)) continue;
            unaligned2.add(node);
        }
    }

    private int checkStep3Condition(int alignmentIndex) {
        while (alignmentIndex < this.alignment.order.size()) {
            Node n1 = this.alignment.order.get(alignmentIndex);
            Node n2 = this.alignment.get(n1);
            boolean unalignedNeighbour1 = false;
            boolean unalignedNeighbour2 = false;
            for (Node neighbour : this.edges1.getAdjacent(n1)) {
                if (this.alignment.contains(neighbour)) continue;
                unalignedNeighbour1 = true;
                break;
            }
            for (Node neighbour : this.edges2.getAdjacent(n2)) {
                if (this.alignment.contains(neighbour)) continue;
                unalignedNeighbour2 = true;
                break;
            }
            if (unalignedNeighbour1 && unalignedNeighbour2) {
                return alignmentIndex;
            }
            ++alignmentIndex;
        }
        return -1;
    }

    private int calcNeighbourhoodDensities(Hashtable<Node, Integer> nds, EdgeList el) {
        int maxND = Integer.MIN_VALUE;
        for (Node n : el.edges.keySet()) {
            int nd = el.getDegree(n);
            HashSet<Node> neighbours = el.getAdjacent(n);
            for (Node n2 : neighbours) {
                nd += el.getDegree(n2);
            }
            nds.put(n, nd);
            maxND = Math.max(maxND, nd);
        }
        return maxND;
    }

    private void alignNeighbourhoods(HashSet<Node> neighbourhood1, HashSet<Node> neighbourhood2) throws Exception {
        PriorityQueue toBeAligned2 = new PriorityQueue(1, Collections.reverseOrder());
        for (Node neighbour1 : neighbourhood1) {
            for (Node neighbour2 : neighbourhood2) {
                toBeAligned2.add(new AlignedPair(neighbour1, neighbour2, this.calcEdgeScore(neighbour1, neighbour2)));
            }
        }
        while (toBeAligned2.size() > 0) {
            AlignedPair potentialPair = (AlignedPair)toBeAligned2.poll();
            if (this.alignment.contains(potentialPair.node1) || this.alignment.contains(potentialPair.node2)) continue;
            this.addEdgeToAlignment(potentialPair.node1, potentialPair.node2, false);
        }
    }
}

