/*
 * Decompiled with CFR 0.152.
 */
package DomainAlignment;

import DomainAlignment.AlignedPair;
import DomainAlignment.Aligner;
import DomainAlignment.EdgeList;
import DomainAlignment.Node;
import DomainAlignment.ScoringMatrix;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.PriorityQueue;

public class GraalAligner
extends Aligner {
    public GraalAligner(HashSet<Node> d1Set, HashSet<Node> b1Set, EdgeList edges1, HashSet<Node> d2Set, HashSet<Node> b2Set, EdgeList edges2, ScoringMatrix pMatrix, ScoringMatrix dMatrix, ScoringMatrix bMatrix, ScoringMatrix ecMatrix, ArrayList<ScoringMatrix> pMatrices, ArrayList<ScoringMatrix> dMatrices, ArrayList<ScoringMatrix> bMatrices, ArrayList<Double> pWeights, ArrayList<Double> dWeights, ArrayList<Double> bWeights, double ecWeight, ArrayList<Double> pThresholds, ArrayList<Double> dThresholds, ArrayList<Double> bThresholds) throws Exception {
        super(d1Set, b1Set, edges1, d2Set, b2Set, edges2, pMatrix, dMatrix, bMatrix, ecMatrix, pMatrices, dMatrices, bMatrices, pWeights, dWeights, bWeights, ecWeight, pThresholds, dThresholds, bThresholds);
        this.alignerName = "Graal";
    }

    @Override
    public void alignSub() throws Exception {
        HashSet<Node> alignedNodes = new HashSet<Node>();
        EdgeList newEdges1 = new EdgeList(this.edges1);
        EdgeList newEdges2 = new EdgeList(this.edges2);
        this.graalAlignSub(alignedNodes);
        for (Node node1 : this.edges1.edges.keySet()) {
            for (Node node2 : this.edges1.edges.get(node1)) {
                this.edges1.addEdge(node1, node2);
            }
        }
        for (Node node1 : this.edges2.edges.keySet()) {
            for (Node node2 : this.edges2.edges.get(node1)) {
                this.edges2.addEdge(node1, node2);
            }
        }
        this.graalAlignSub(alignedNodes);
        for (Node node1 : this.edges1.edges.keySet()) {
            for (Node node2 : this.edges1.edges.get(node1)) {
                this.edges1.addEdge(node1, node2);
            }
        }
        for (Node node1 : this.edges2.edges.keySet()) {
            for (Node node2 : this.edges2.edges.get(node1)) {
                this.edges2.addEdge(node1, node2);
            }
        }
        this.graalAlignSub(alignedNodes);
        this.edges1 = newEdges1;
        this.edges2 = newEdges2;
    }

    private void graalAlignSub(HashSet<Node> alignedNodes) throws Exception {
        AlignedPair bestPair = new AlignedPair(null, null, Double.MIN_VALUE);
        for (Node node1 : this.d1Set) {
            for (Node node2 : this.d2Set) {
                if (!this.checkThresholds(node1, node2) || !(this.calcEdgeScore(node1, node2) > bestPair.score) || alignedNodes.contains(node1) || alignedNodes.contains(node2)) continue;
                bestPair = new AlignedPair(node1, node2, this.calcEdgeScore(node1, node2));
            }
        }
        for (Node node1 : this.b1Set) {
            for (Node node2 : this.b2Set) {
                if (!this.checkThresholds(node1, node2) || !(this.calcEdgeScore(node1, node2) > bestPair.score) || alignedNodes.contains(node1) || alignedNodes.contains(node2)) continue;
                bestPair = new AlignedPair(node1, node2, this.calcEdgeScore(node1, node2));
            }
        }
        if (!this.alignment.contains(bestPair.node1) && !this.alignment.contains(bestPair.node2)) {
            this.addEdgeToAlignment(bestPair.node1, bestPair.node2, true);
        }
        ArrayList<HashSet<Node>> radii1 = this.populateRadii(bestPair.node1, this.edges1);
        ArrayList<HashSet<Node>> radii2 = this.populateRadii(bestPair.node2, this.edges2);
        int i = radii1.size();
        while (i < radii2.size()) {
            radii1.add(new HashSet());
            ++i;
        }
        i = radii2.size();
        while (i < radii1.size()) {
            radii2.add(new HashSet());
            ++i;
        }
        ArrayList<HashSet<Node>> reorderedRadii = new ArrayList<HashSet<Node>>();
        int i2 = 0;
        while (i2 < radii1.size()) {
            reorderedRadii.add(radii1.get(i2));
            reorderedRadii.add(radii2.get(i2));
            ++i2;
        }
        PriorityQueue<AlignedPair> toBeAligned = this.greedyAlignSub(reorderedRadii);
        while (!toBeAligned.isEmpty()) {
            AlignedPair newPair = toBeAligned.poll();
            if (alignedNodes.contains(newPair.node1) || alignedNodes.contains(newPair.node2)) continue;
            this.addEdgeToAlignment(newPair.node1, newPair.node2, false);
            alignedNodes.add(newPair.node1);
            alignedNodes.add(newPair.node2);
        }
    }

    private ArrayList<HashSet<Node>> populateRadii(Node seed, EdgeList edges) {
        ArrayList<HashSet<Node>> radii = new ArrayList<HashSet<Node>>();
        HashSet added = new HashSet();
        HashSet<Node> curLevel = new HashSet<Node>();
        curLevel.add(seed);
        while (!curLevel.isEmpty()) {
            radii.add(curLevel);
            added.addAll(curLevel);
            HashSet<Node> nextLevel = new HashSet<Node>();
            for (Node node : curLevel) {
                HashSet<Node> adjNodes = edges.getAdjacent(node);
                for (Node adjNode : adjNodes) {
                    if (added.contains(adjNode)) continue;
                    nextLevel.add(adjNode);
                }
            }
            curLevel = nextLevel;
        }
        radii.remove(0);
        return radii;
    }
}

