/*
 * Decompiled with CFR 0.152.
 */
package DomainAlignment;

import DomainAlignment.Aligner;
import DomainAlignment.EdgeList;
import DomainAlignment.HungarianAlgorithm;
import DomainAlignment.Node;
import DomainAlignment.ScoringMatrix;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;

public class HGraalAligner
extends Aligner {
    public double alpha = 0.5;

    public HGraalAligner(HashSet<Node> d1Set, HashSet<Node> b1Set, EdgeList edges1, HashSet<Node> d2Set, HashSet<Node> b2Set, EdgeList edges2, ScoringMatrix pMatrix, ScoringMatrix dMatrix, ScoringMatrix bMatrix, ScoringMatrix ecMatrix, ArrayList<ScoringMatrix> pMatrices, ArrayList<ScoringMatrix> dMatrices, ArrayList<ScoringMatrix> bMatrices, ArrayList<Double> pWeights, ArrayList<Double> dWeights, ArrayList<Double> bWeights, double ecWeight, ArrayList<Double> pThresholds, ArrayList<Double> dThresholds, ArrayList<Double> bThresholds) throws Exception {
        super(d1Set, b1Set, edges1, d2Set, b2Set, edges2, pMatrix, dMatrix, bMatrix, ecMatrix, pMatrices, dMatrices, bMatrices, pWeights, dWeights, bWeights, ecWeight, pThresholds, dThresholds, bThresholds);
        this.alignerName = "HGraal";
    }

    @Override
    public void alignSub() throws Exception {
        ArrayList<Node> dList1 = new ArrayList<Node>(this.d1Set);
        ArrayList<Node> dList2 = new ArrayList<Node>(this.d2Set);
        ArrayList<Node> bList1 = new ArrayList<Node>(this.b1Set);
        ArrayList<Node> bList2 = new ArrayList<Node>(this.b2Set);
        double[][] dMatrix = this.generateScoringMatrices(dList1, dList2);
        this.hungarianAlgorithm(dMatrix, dList1, dList2);
        double[][] bMatrix = this.generateScoringMatrices(bList1, bList2);
        this.hungarianAlgorithm(bMatrix, bList1, bList2);
    }

    private double[][] generateScoringMatrices(List<Node> xList, List<Node> yList) throws Exception {
        int degree;
        double[][] matrix = new double[xList.size()][yList.size()];
        Hashtable<Node, Integer> degrees = new Hashtable<Node, Integer>();
        int maxDegree1 = Integer.MIN_VALUE;
        int maxDegree2 = Integer.MIN_VALUE;
        for (Node n : xList) {
            degree = this.edges1.getAdjacent(n).size();
            degrees.put(n, degree);
            if (degree <= maxDegree1) continue;
            maxDegree1 = degree;
        }
        for (Node n : yList) {
            degree = this.edges2.getAdjacent(n).size();
            degrees.put(n, degree);
            if (degree <= maxDegree2) continue;
            maxDegree2 = degree;
        }
        double max = Double.NEGATIVE_INFINITY;
        int x = 0;
        while (x < xList.size()) {
            int y = 0;
            while (y < yList.size()) {
                max = Math.max(max, this.calcEdgeScore(xList.get(x), yList.get(y)));
                ++y;
            }
            ++x;
        }
        x = 0;
        while (x < xList.size()) {
            Node n1 = xList.get(x);
            int y = 0;
            while (y < yList.size()) {
                Node n2 = yList.get(y);
                matrix[x][y] = this.calcEdgeScore(n1, n2) / max;
                matrix[x][y] = 2.0 - ((1.0 - this.alpha) * (double)(((Integer)degrees.get(n1) + (Integer)degrees.get(n2)) / (maxDegree1 + maxDegree2)) + this.alpha * matrix[x][y]);
                ++y;
            }
            ++x;
        }
        return matrix;
    }

    private void hungarianAlgorithm(double[][] matrix, List<Node> xList, List<Node> yList) throws Exception {
        HungarianAlgorithm ha = new HungarianAlgorithm(matrix);
        int[] origAlignment = ha.execute();
        double cost = this.calcAlignmentCost(origAlignment, matrix);
        HashSet oaps = new HashSet();
        HashSet coreAlignment = new HashSet();
        int x = 0;
        while (x < matrix.length) {
            Node n1 = xList.get(x);
            if (origAlignment[x] != -1) {
                Node n2 = yList.get(origAlignment[x]);
                this.addEdgeToAlignment(n1, n2, false);
            }
            ++x;
        }
    }

    private double calcAlignmentCost(int[] alignment, double[][] matrix) {
        double cost = 0.0;
        int i = 0;
        while (i < alignment.length) {
            if (alignment[i] != -1) {
                cost += matrix[i][alignment[i]];
            }
            ++i;
        }
        return cost;
    }
}

