/*
 * Decompiled with CFR 0.152.
 */
package DomainAlignment;

import DomainAlignment.Aligner;
import DomainAlignment.AlignerWrapper;
import DomainAlignment.EdgeList;
import DomainAlignment.Node;
import DomainAlignment.ScoringMatrix;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashSet;

public class NetAligner
extends Aligner {
    public NetAligner(HashSet<Node> d1Set, HashSet<Node> b1Set, EdgeList edges1, HashSet<Node> d2Set, HashSet<Node> b2Set, EdgeList edges2, ScoringMatrix pMatrix, ScoringMatrix dMatrix, ScoringMatrix bMatrix, ScoringMatrix ecMatrix, ArrayList<ScoringMatrix> pMatrices, ArrayList<ScoringMatrix> dMatrices, ArrayList<ScoringMatrix> bMatrices, ArrayList<Double> pWeights, ArrayList<Double> dWeights, ArrayList<Double> bWeights, double ecWeight, ArrayList<Double> pThresholds, ArrayList<Double> dThresholds, ArrayList<Double> bThresholds) {
        super(d1Set, b1Set, edges1, d2Set, b2Set, edges2, pMatrix, dMatrix, bMatrix, ecMatrix, pMatrices, dMatrices, bMatrices, pWeights, dWeights, bWeights, ecWeight, pThresholds, dThresholds, bThresholds);
        this.alignerName = "NetAligner";
    }

    public void scoringMatrixToMatlab() throws Exception {
        BufferedWriter out = new BufferedWriter(new FileWriter("Netaligner_scores.txt"));
        for (Node node1 : this.d1Set) {
            for (Node node2 : this.d2Set) {
                out.write(String.valueOf(node1.name) + "\t" + node2.name + "\t" + this.calcEdgeScore(node1, node2) + "\n");
            }
            for (Node node2 : this.b2Set) {
                out.write(String.valueOf(node1.name) + "\t" + node2.name + "\t-100\n");
            }
        }
        for (Node node1 : this.b1Set) {
            for (Node node2 : this.b2Set) {
                out.write(String.valueOf(node1.name) + "\t" + node2.name + "\t" + this.calcEdgeScore(node1, node2) + "\n");
            }
            for (Node node2 : this.d2Set) {
                out.write(String.valueOf(node1.name) + "\t" + node2.name + "\t-100\n");
            }
        }
        out.close();
    }

    @Override
    public void alignSub() throws Exception {
    }

    public static void main(String[] args) throws Exception {
        AlignerWrapper aw = new AlignerWrapper("worm_yeast/base.blast_protein_score_only.params", "NetAlign");
        NetAligner a = (NetAligner)aw.aligner;
        a.scoringMatrixToMatlab();
    }
}

