/*
 * Decompiled with CFR 0.152.
 */
package jsc.descriptive;

import java.util.Arrays;
import java.util.Vector;

public class DoubleTally
implements Cloneable {
    private int N;
    private Vector freq;
    private Vector x;
    private double tolerance;

    public DoubleTally(double[] dArray) {
        this(dArray, 0.0);
    }

    public DoubleTally(double[] dArray, double d) {
        this.tolerance = d;
        this.N = dArray.length;
        Arrays.sort(dArray);
        int n = 1;
        double d2 = dArray[0];
        int n2 = 1;
        while (n2 < this.N) {
            if (Math.abs(dArray[n2] - d2) > d) {
                ++n;
                d2 = dArray[n2];
            }
            ++n2;
        }
        this.x = new Vector(n);
        this.freq = new Vector(n);
        n2 = 0;
        while (n2 < n) {
            this.freq.add(new Integer(0));
            ++n2;
        }
        double d3 = dArray[0];
        this.x.add(new Double(d3));
        this.freq.add(0, new Integer(1));
        int n3 = 0;
        n2 = 1;
        while (n2 < this.N) {
            if (Math.abs(dArray[n2] - d3) > d) {
                ++n3;
                d3 = dArray[n2];
                this.x.add(new Double(d3));
            }
            int n4 = (Integer)this.freq.get(n3);
            this.freq.set(n3, new Integer(++n4));
            ++n2;
        }
    }

    public DoubleTally() {
        this(0.0);
    }

    public DoubleTally(double d) {
        this(10, 0, d);
    }

    public DoubleTally(int n, int n2) {
        this(n, n2, 0.0);
    }

    public DoubleTally(int n, int n2, double d) {
        this.tolerance = d;
        this.N = 0;
        this.x = new Vector(n, n2);
        this.freq = new Vector(n, n2);
    }

    public int addValue(double d) {
        ++this.N;
        int n = this.x.size();
        if (n == 0) {
            this.addEnd(d);
            return 0;
        }
        double d2 = (Double)this.x.firstElement();
        double d3 = (Double)this.x.lastElement();
        if (Math.abs(d - d2) <= this.tolerance) {
            this.addExisting(0);
            return 0;
        }
        if (d < d2) {
            this.addNew(0, d);
            return -1;
        }
        if (Math.abs(d - d3) <= this.tolerance) {
            this.addExisting(n - 1);
            return n - 1;
        }
        if (d > d3) {
            this.addEnd(d);
            return -1;
        }
        int n2 = 0;
        int n3 = n - 1;
        while (n3 - n2 > 1) {
            int n4 = n3 + n2 >> 1;
            double d4 = (Double)this.x.get(n4);
            if (Math.abs(d - d4) <= this.tolerance) {
                this.addExisting(n4);
                return n4;
            }
            if (d < d4) {
                n3 = n4;
                continue;
            }
            n2 = n4;
        }
        double d5 = (Double)this.x.get(n3);
        if (Math.abs(d - d5) <= this.tolerance) {
            this.addExisting(n3);
            return n3;
        }
        this.addNew(n3, d);
        return n3;
    }

    private void addEnd(double d) {
        this.x.add(new Double(d));
        this.freq.add(new Integer(1));
    }

    private void addExisting(int n) {
        int n2 = (Integer)this.freq.get(n);
        this.freq.set(n, new Integer(++n2));
    }

    private void addNew(int n, double d) {
        this.x.add(n, new Double(d));
        this.freq.add(n, new Integer(1));
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("DoubleTally can't clone");
        }
        return object;
    }

    public int getFrequency(int n) {
        return (Integer)this.freq.get(n);
    }

    public double getMax() {
        return (Double)this.x.lastElement();
    }

    public int getMaxFreq() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.freq.size()) {
            int n3 = (Integer)this.freq.get(n2);
            if (n3 > n) {
                n = n3;
            }
            ++n2;
        }
        return n;
    }

    public double getMin() {
        return (Double)this.x.firstElement();
    }

    public int getN() {
        return this.N;
    }

    public double getProportion(int n) {
        return this.N > 0 ? (double)((Integer)this.freq.get(n)).intValue() / (double)this.N : 0.0;
    }

    public double getValue(int n) {
        return (Double)this.x.get(n);
    }

    public int getValueCount() {
        return this.x.size();
    }

    public int indexOf(double d) {
        return this.x.indexOf(new Double(d));
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double[] dArray = new double[]{4.0, 5.0, 8.0, 9.0, 3.0, 2.0, 5.0, 4.0, 6.0, 7.0, 8.0, 9.0, 2.0, 1.0, 0.0, -3.0, -2.0, 0.0, -6.0, -3.0};
            DoubleTally doubleTally = new DoubleTally();
            int n = 0;
            while (n < dArray.length) {
                doubleTally.addValue(dArray[n]);
                ++n;
            }
            System.out.println("DoubleTally " + doubleTally.getN() + " values, " + "Min = " + doubleTally.getMin() + ", Max = " + doubleTally.getMax());
            n = 0;
            while (n < doubleTally.getValueCount()) {
                System.out.println(doubleTally.getValue(n) + ", Freq = " + doubleTally.getFrequency(n) + ", p = " + doubleTally.getProportion(n));
                ++n;
            }
            n = 0;
            while (n < dArray.length) {
                System.out.println("Index of " + dArray[n] + " is " + doubleTally.indexOf(dArray[n]));
                ++n;
            }
        }
    }
}

