/*
 * Decompiled with CFR 0.152.
 */
package jsc.distributions;

import jsc.descriptive.Tally;
import jsc.distributions.AbstractDiscreteDistribution;
import jsc.distributions.AbstractDistribution;
import jsc.distributions.Beta;
import jsc.distributions.Distribution;
import jsc.distributions.Normal;
import jsc.distributions.Poisson;
import jsc.goodnessfit.ChiSquaredFitTest;
import jsc.util.Maths;

public class Binomial
extends AbstractDiscreteDistribution {
    private long n;
    private double p;
    private double plog;
    private double pclog;
    private double oldg;

    public Binomial(long l, double d) {
        super(0L, l);
        this.setN(l);
        this.setP(d);
    }

    public double cdf(double d) {
        if (d < 0.0 || d > (double)this.n) {
            throw new IllegalArgumentException("Invalid variate-value.");
        }
        double d2 = (double)this.n - d;
        if (d == (double)this.n) {
            return 1.0;
        }
        return 1.0 - Beta.incompleteBeta(this.p, d + 1.0, d2, Maths.lnB(d + 1.0, d2));
    }

    public long getN() {
        return this.n;
    }

    public double getP() {
        return this.p;
    }

    public double inverseCdf(double d) {
        AbstractDistribution abstractDistribution;
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Invalid probability.");
        }
        double d2 = 0.0;
        if (d == 1.0) {
            return this.n;
        }
        if (this.n < 26L) {
            while (d2 < (double)this.n && this.cdf(d2) < d - 1.0E-8) {
                d2 += 1.0;
            }
            return d2;
        }
        if (this.p < 0.1) {
            abstractDistribution = new Poisson((double)this.n * this.p);
            d2 = ((Poisson)abstractDistribution).inverseCdf(d);
        } else {
            abstractDistribution = new Normal((double)this.n * this.p, Math.sqrt((double)this.n * this.p * (1.0 - this.p)));
            d2 = Math.floor(((Normal)abstractDistribution).inverseCdf(d) + 0.5);
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        if (d2 > (double)this.n) {
            d2 = this.n;
        }
        double d3 = this.cdf(d2);
        while (d3 > d && d2 > 0.0) {
            d3 = this.cdf(d2 -= 1.0);
        }
        while (d3 < d && d2 < (double)this.n) {
            d3 = this.cdf(d2 += 1.0);
        }
        return d2;
    }

    public double mean() {
        return (double)this.n * this.p;
    }

    public double pdf(double d) {
        if (d < 0.0 || d > (double)this.n) {
            return 0.0;
        }
        return Math.exp(Maths.logBinomialCoefficient(this.n, (long)d) + d * Math.log(this.p) + ((double)this.n - d) * Math.log(1.0 - this.p));
    }

    public double random() {
        double d;
        double d2 = this.p;
        double d3 = d2 <= 0.5 ? d2 : 1.0 - d2;
        double d4 = (double)this.n * d3;
        if (this.n < 25L) {
            d = 0.0;
            int n = 1;
            while ((long)n <= this.n) {
                if (this.rand.nextDouble() < d3) {
                    d += 1.0;
                }
                ++n;
            }
        } else {
            double d5;
            double d6 = 1.0 - d3;
            double d7 = Math.sqrt(2.0 * d4 * d6);
            while (true) {
                double d8;
                double d9;
                if ((d5 = d7 * (d9 = Math.tan(d8 = Math.PI * this.rand.nextDouble())) + d4) < 0.0 || d5 >= (double)this.n + 1.0) {
                    continue;
                }
                d5 = Math.floor(d5);
                double d10 = 1.2 * d7 * (1.0 + d9 * d9) * Math.exp(this.oldg - Maths.logGamma(d5 + 1.0) - Maths.logGamma((double)this.n - d5 + 1.0) + d5 * this.plog + ((double)this.n - d5) * this.pclog);
                if (!(this.rand.nextDouble() > d10)) break;
            }
            d = d5;
        }
        if (d3 != d2) {
            d = (double)this.n - d;
        }
        return d;
    }

    public void setN(long l) {
        if (l < 1L) {
            throw new IllegalArgumentException("Invalid number of trials.");
        }
        this.n = l;
        this.maxValue = l;
        this.oldg = Maths.logFactorial(l);
    }

    public void setP(double d) {
        if (d <= 0.0 || d >= 1.0) {
            throw new IllegalArgumentException("Invalid probability of success.");
        }
        this.p = d;
        double d2 = d;
        double d3 = d2 <= 0.5 ? d2 : 1.0 - d2;
        double d4 = 1.0 - d3;
        this.plog = Math.log(d3);
        this.pclog = Math.log(d4);
    }

    public String toString() {
        return new String("Binomial distribution: n = " + this.n + ", p = " + this.p + ".");
    }

    public double variance() {
        return (double)this.n * this.p * (1.0 - this.p);
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            long l = 1000L;
            double d = 0.99;
            long l2 = 9L;
            double d2 = 0.9;
            Binomial binomial = new Binomial(l, d);
            int n = 1000000;
            binomial = new Binomial(25L, 0.038461538461538464);
            int[] nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = (int)binomial.random();
                ++n2;
            }
            ChiSquaredFitTest chiSquaredFitTest = new ChiSquaredFitTest(new Tally(nArray), (Distribution)binomial, 0);
            System.out.println("All E > 5 " + chiSquaredFitTest.poolBins());
            System.out.println("m = " + n + " Chi-squared = " + chiSquaredFitTest.getTestStatistic() + " SP = " + chiSquaredFitTest.getSP());
        }
    }
}

