/*
 * Decompiled with CFR 0.152.
 */
package jsc.goodnessfit;

import jsc.ci.ConfidenceBand;
import jsc.goodnessfit.SampleDistributionFunction;
import jsc.util.Maths;

public class KolmogorovCB
implements ConfidenceBand {
    static final double TOLERANCE = 5.0E-15;
    private int n;
    private SampleDistributionFunction sdf;
    private boolean approx;
    private double confidenceCoeff;
    private double criticalValue;

    public KolmogorovCB(SampleDistributionFunction sampleDistributionFunction, double d, boolean bl) {
        this.approx = bl;
        this.sdf = sampleDistributionFunction;
        this.n = sampleDistributionFunction.getN();
        this.setConfidenceCoeff(d);
    }

    public KolmogorovCB(double[] dArray, double d, boolean bl) {
        this(new SampleDistributionFunction(dArray), d, bl);
    }

    public KolmogorovCB(double[] dArray) {
        this(dArray, 0.95, dArray.length <= 100);
    }

    public static double approxCriticalValue(int n, double d) {
        double d2;
        double d3;
        if (n < 1) {
            throw new IllegalArgumentException("n < 1.");
        }
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Invalid alpha.");
        }
        if (d == 0.0) {
            return 1.0;
        }
        if (d == 1.0) {
            return 0.0;
        }
        if (n == 1) {
            return 1.0 - d;
        }
        double d4 = Math.sqrt(Math.log(1.0 / d) / (double)(2 * n));
        double d5 = d4 - 0.16693 / (double)n - (d3 = 0.09037 * Math.pow(-(d2 = Maths.log10(d)), 1.5) + 0.01515 * d2 * d2 - 0.11143) / Math.pow(n, 1.5);
        if (d5 < 0.0) {
            return 0.0;
        }
        if (d5 > 1.0) {
            return 1.0;
        }
        return d5;
    }

    public static double exactCriticalValue(int n, double d) {
        double d2;
        double d3 = n;
        if (n < 1) {
            throw new IllegalArgumentException("n < 1.");
        }
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Invalid alpha.");
        }
        if (d == 0.0) {
            return 1.0;
        }
        if (d == 0.0) {
            return 0.0;
        }
        if (n == 1) {
            return 1.0 - d;
        }
        double d4 = Maths.logFactorial(n);
        double d5 = KolmogorovCB.approxCriticalValue(n, d);
        if (d5 == 1.0) {
            d5 = 0.5;
        } else if (d5 == 0.0) {
            d5 = d > 0.99 ? 1.0 - d : 0.5;
        }
        do {
            double d6 = 0.0;
            double d7 = 0.0;
            int n2 = 0;
            while ((double)n2 < (double)n * (1.0 - d5) && n2 < n) {
                double d8 = (double)n2 / d3;
                double d9 = Math.exp(d4 - Maths.logFactorial(n2) - Maths.logFactorial(n - n2) + (double)(n - n2) * Math.log(1.0 - d5 - d8) + (double)(n2 - 1) * Math.log(d5 + d8));
                d6 += d9;
                d7 += (1.0 / d5 + ((double)n2 - 1.0) / (d5 + d8) - (double)(n - n2) / (1.0 - d5 - d8)) * d9;
                ++n2;
            }
            double d10 = d - d5 * d6;
            double d11 = -d5 * d7;
            if (d11 == 0.0) {
                throw new ArithmeticException("Zero derivative.");
            }
            d2 = d5;
            if (!((d5 -= d10 / d11) < 0.0) && !(d5 > 1.0)) continue;
            return d2;
        } while (Math.abs(d5 - d2) >= 5.0E-15);
        if (d5 < 0.0) {
            return 0.0;
        }
        if (d5 > 1.0) {
            return 1.0;
        }
        return d5;
    }

    public double getConfidenceCoeff() {
        return this.confidenceCoeff;
    }

    public void setConfidenceCoeff(double d) {
        if (d <= 0.0 || d >= 1.0) {
            throw new IllegalArgumentException("Invalid confidence coefficient.");
        }
        this.confidenceCoeff = d;
        double d2 = 0.5 - 0.5 * d;
        this.criticalValue = this.approx ? KolmogorovCB.approxCriticalValue(this.n, d2) : KolmogorovCB.exactCriticalValue(this.n, d2);
    }

    public double getCriticalValue() {
        return this.criticalValue;
    }

    public double getLowerLimit(int n) {
        return this.sdf.getOrderedS(n) - this.criticalValue;
    }

    public double getUpperLimit(int n) {
        return this.sdf.getOrderedS(n) + this.criticalValue;
    }

    public int getN() {
        return this.n;
    }

    public SampleDistributionFunction getSdf() {
        return this.sdf;
    }

    public double getX(int n) {
        return this.sdf.getOrderedX(n);
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double[] dArray = new double[]{13.3, 14.6, 13.6, 17.2, 14.1, 10.6, 15.9, 14.7, 14.2, 14.0, 17.4, 15.6, 8.2, 13.8, 15.4, 16.3, 17.7, 15.0, 13.4, 13.4, 16.0, 13.3, 14.9, 12.9, 14.0, 16.2, 11.5, 10.4, 12.6, 18.1};
            KolmogorovCB kolmogorovCB = new KolmogorovCB(dArray);
            int n = 0;
            while (n < kolmogorovCB.getN()) {
                System.out.println("x = " + kolmogorovCB.getX(n) + " [" + kolmogorovCB.getLowerLimit(n) + ", " + kolmogorovCB.getUpperLimit(n) + "]");
                ++n;
            }
            System.out.println("n = " + kolmogorovCB.getN() + " D = " + kolmogorovCB.getCriticalValue());
        }
    }
}

