/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.hypermodules.internal;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.cytoscape.hypermodules.internal.statistics.CoxPh;
import org.cytoscape.hypermodules.internal.statistics.LogRankTest;
import org.cytoscape.hypermodules.internal.statistics.MyFET;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;

public class HypermodulesHeuristicAlgorithm {
    private String statTest;
    private ArrayList<String[]> sampleValues;
    private ArrayList<String[]> clinicalValues;
    private ArrayList<String[]> otherValues;
    private HashMap<String, String> allGeneSamplesMap;
    private CyNetwork network;
    private String[] allPatients;
    private boolean[] status;
    private double[] followupDays;
    private double[] daysFromBirth;
    private double[] age;
    private double[] censor;
    private String[] otherPatients;
    private String[] clinicalVariable;
    private HashSet<String> clinicalVariableHash;
    private HashMap<String, String> clinicalVariableMap;
    private ArrayList<String> hashArray;
    private LogRankTest logRankObject;
    private CoxPh coxModel;
    private ArrayList<String> allGenes;
    private ArrayList<String> allSamples;
    private HashMap<String, String> survivalClassification;
    private HashMap<String, Integer> patientDaysFollowup;
    private HashMap<String, Double> geneAverageSurvival;
    private double highCutoff;
    private double lowCutoff;
    private int numberTests;
    private HashMap<String, Double> repository;
    private String foregroundvariable;

    public HypermodulesHeuristicAlgorithm(String statTest, String foregroundvariable, ArrayList<String[]> sampleValues, ArrayList<String[]> clinicalValues, ArrayList<String[]> otherValues, CyNetwork network) {
        this.statTest = statTest;
        this.foregroundvariable = foregroundvariable;
        this.sampleValues = sampleValues;
        this.otherValues = otherValues;
        this.clinicalValues = clinicalValues;
        this.network = network;
    }

    public void initialize() {
        this.numberTests = 0;
        if (this.statTest.equals("fisher")) {
            this.initOther();
        } else if (this.statTest.equals("logRank")) {
            this.initClinicals();
            this.logRankObject = new LogRankTest(this.followupDays);
        } else {
            this.initClinicals();
            this.logRankObject = new LogRankTest(this.followupDays);
            this.coxModel = new CoxPh(this.followupDays.length, this.followupDays, this.censor, this.age);
            this.coxModel.coxInit();
        }
        this.allGeneSamplesMap = new HashMap();
        for (int i = 0; i < this.sampleValues.size(); ++i) {
            if (this.allGeneSamplesMap.get(this.sampleValues.get(i)[0]) != null) {
                String sti = this.allGeneSamplesMap.get(this.sampleValues.get(i)[0]);
                sti = sti + ":" + this.sampleValues.get(i)[1];
                this.allGeneSamplesMap.put(this.sampleValues.get(i)[0], sti);
                continue;
            }
            this.allGeneSamplesMap.put(this.sampleValues.get(i)[0], this.sampleValues.get(i)[1]);
        }
        for (CyNode cynode : this.network.getNodeList()) {
            if (this.allGeneSamplesMap.get(this.network.getRow((CyIdentifiable)cynode).get("name", String.class)) != null) continue;
            String[] inconsistency = new String[]{(String)this.network.getRow((CyIdentifiable)cynode).get("name", String.class), "no_sample"};
            this.sampleValues.add(inconsistency);
            this.allGeneSamplesMap.put(this.sampleValues.get(this.sampleValues.size() - 1)[0], this.sampleValues.get(this.sampleValues.size() - 1)[1]);
        }
        ArrayListMultimap memoryone = ArrayListMultimap.create();
        HashSet<String> g2sSamples = new HashSet<String>();
        for (String[] s : this.sampleValues) {
            String[] stringArray;
            for (String t : stringArray = s[1].split(":")) {
                if (t.equals("no_sample")) continue;
                g2sSamples.add(t);
                memoryone.put((Object)t, (Object)s[0]);
            }
        }
        HashSet<String> clinicalSamples = new HashSet<String>();
        if (this.statTest.equals("logRank")) {
            for (String[] stringArray : this.clinicalValues) {
                clinicalSamples.add(stringArray[0]);
            }
        } else if (this.statTest.equals("fisher")) {
            for (String[] stringArray : this.otherValues) {
                clinicalSamples.add(stringArray[0]);
            }
        }
        for (String string : g2sSamples) {
            if (clinicalSamples.contains(string)) continue;
            for (String z : memoryone.get((Object)string)) {
                this.allGeneSamplesMap.put(z, "no_sample");
                System.out.println("The sample " + string + " was not found in your clinical table. All genes corresponding to " + string + " are now assumed to have no sample.");
            }
        }
        this.allGenes = new ArrayList();
        this.allSamples = new ArrayList();
        for (String string : this.allGeneSamplesMap.keySet()) {
            this.allGenes.add(string);
            this.allSamples.add(this.allGeneSamplesMap.get(string));
        }
        this.repository = new HashMap();
    }

    public void initializeSurvivalClassification() {
        int i;
        this.patientDaysFollowup = new HashMap();
        for (int i2 = 0; i2 < this.clinicalValues.size(); ++i2) {
            this.patientDaysFollowup.put(this.clinicalValues.get(i2)[0], Integer.valueOf(this.clinicalValues.get(i2)[2]));
        }
        int survivalSum = 0;
        for (int i3 = 0; i3 < this.clinicalValues.size(); ++i3) {
            survivalSum += Integer.valueOf(this.clinicalValues.get(i3)[2]).intValue();
        }
        double mean = (double)survivalSum / (double)this.clinicalValues.size();
        double standardDeviation = 0.0;
        int[] distanceFromMean = new int[this.clinicalValues.size()];
        for (int i4 = 0; i4 < this.clinicalValues.size(); ++i4) {
            standardDeviation += Math.pow((double)Integer.valueOf(this.clinicalValues.get(i4)[2]).intValue() - mean, 2.0);
        }
        standardDeviation = Math.pow(standardDeviation / (double)this.clinicalValues.size(), 0.5);
        this.highCutoff = mean + standardDeviation;
        this.lowCutoff = mean - standardDeviation;
        System.out.println("mean: " + mean);
        System.out.println("standard deviation: " + standardDeviation);
        ArrayList<String> allSeeds = new ArrayList<String>();
        for (i = 0; i < this.allGenes.size(); ++i) {
            if (this.allGeneSamplesMap.get(this.allGenes.get(i)).equals("no_sample")) continue;
            allSeeds.add(this.allGenes.get(i));
        }
        this.survivalClassification = new HashMap();
        this.geneAverageSurvival = new HashMap();
        for (i = 0; i < allSeeds.size(); ++i) {
            String[] p = this.allGeneSamplesMap.get(allSeeds.get(i)).split(":");
            double survivalAverage = 0.0;
            for (int k = 0; k < p.length; ++k) {
                survivalAverage += (double)this.patientDaysFollowup.get(p[k]).intValue();
            }
            this.geneAverageSurvival.put((String)allSeeds.get(i), survivalAverage /= (double)p.length);
            if (survivalAverage > this.highCutoff) {
                this.survivalClassification.put((String)allSeeds.get(i), "LONG");
                continue;
            }
            if (survivalAverage > this.lowCutoff) {
                this.survivalClassification.put((String)allSeeds.get(i), "MEDIUM");
                continue;
            }
            this.survivalClassification.put((String)allSeeds.get(i), "SHORT");
        }
    }

    public boolean testClassification(String one, String two) {
        String[] a = one.split(":");
        String[] b = two.split(":");
        double oneAverage = 0.0;
        int k = 0;
        for (int i = 0; i < a.length; ++i) {
            if (this.geneAverageSurvival.get(a[i]) == null) continue;
            oneAverage += this.geneAverageSurvival.get(a[i]).doubleValue();
            ++k;
        }
        oneAverage /= (double)k;
        double twoAverage = 0.0;
        k = 0;
        for (int i = 0; i < b.length; ++i) {
            if (this.geneAverageSurvival.get(b[i]) == null) continue;
            twoAverage += this.geneAverageSurvival.get(b[i]).doubleValue();
            ++k;
        }
        twoAverage /= (double)k;
        return !(oneAverage > this.highCutoff && twoAverage < this.lowCutoff) && (!(oneAverage < this.lowCutoff) || !(twoAverage > this.highCutoff));
    }

    public boolean testClassification2(String one, String two) {
        String[] a = one.split(":");
        String[] b = two.split(":");
        double oneAverage = 0.0;
        int k = 0;
        for (int i = 0; i < a.length; ++i) {
            if (this.survivalClassification.get(a[i]) == null) continue;
            ++k;
            if (this.survivalClassification.get(a[i]).equals("LONG")) {
                oneAverage += 2.0;
                continue;
            }
            if (this.survivalClassification.get(a[i]).equals("MEDIUM")) {
                oneAverage += 1.0;
                continue;
            }
            oneAverage += 0.0;
        }
        oneAverage /= (double)k;
        double twoAverage = 0.0;
        int j = 0;
        for (int i = 0; i < b.length; ++i) {
            if (this.survivalClassification.get(b[i]) == null || this.survivalClassification.get(b[i]) == null) continue;
            ++j;
            if (this.survivalClassification.get(b[i]).equals("LONG")) {
                twoAverage += 2.0;
                continue;
            }
            if (this.survivalClassification.get(b[i]).equals("MEDIUM")) {
                twoAverage += 1.0;
                continue;
            }
            twoAverage += 0.0;
        }
        twoAverage /= (double)j;
        int max = 2 * (j + k);
        double first = (double)max / 3.0;
        double second = first * 2.0;
        return !(oneAverage < first && twoAverage > second) && (!(oneAverage > second) || !(twoAverage < first));
    }

    public HashMap<String, Double> mineHublets(ArrayList<String> compressedList) {
        HashMap<String, Double> hubletsTested = new HashMap<String, Double>();
        for (int i = 0; i < compressedList.size(); ++i) {
            String key5 = compressedList.get(i);
            Double value5 = this.testModuleClinical(compressedList.get(i), 1, false);
            if (value5 == null) continue;
            hubletsTested.put(key5, value5);
        }
        if (hubletsTested.isEmpty()) {
            return hubletsTested;
        }
        HashMap<String[], Double[]> pairwise = new HashMap<String[], Double[]>();
        HashMap<String, Double> pairwiseConcat = new HashMap<String, Double>();
        HashMap<String, String[]> pairwiseConcatMemory = new HashMap<String, String[]>();
        while (true) {
            String[] pairwiseKey = new String[2];
            Double[] pairwiseValue = new Double[2];
            ArrayList<String> list = new ArrayList<String>();
            for (String cy1 : hubletsTested.keySet()) {
                list.add(cy1);
            }
            for (int k = 0; k < list.size(); ++k) {
                for (int j = k + 1; j < list.size(); ++j) {
                    pairwiseKey = new String[]{(String)list.get(k), (String)list.get(j)};
                    pairwiseValue = new Double[]{hubletsTested.get(list.get(k)), hubletsTested.get(list.get(j))};
                    pairwise.put(pairwiseKey, pairwiseValue);
                }
            }
            String minKey = null;
            Double minVal = 2.0;
            for (String[] key6 : pairwise.keySet()) {
                Double value7;
                String key7 = key6[0] + ":" + key6[1];
                if (this.repository.get(key7) != null) {
                    value7 = this.repository.get(key7);
                } else {
                    value7 = this.testModuleClinical(key7, 1, false);
                    this.repository.put(key7, value7);
                }
                if (!(value7 < ((Double[])pairwise.get(key6))[0]) || !(value7 < ((Double[])pairwise.get(key6))[1])) continue;
                pairwiseConcat.put(key7, value7);
                pairwiseConcatMemory.put(key7, key6);
                if (!(value7 < minVal)) continue;
                minVal = value7;
                minKey = key7;
            }
            if (pairwiseConcat.isEmpty()) break;
            hubletsTested.remove(((String[])pairwiseConcatMemory.get(minKey))[0]);
            hubletsTested.remove(((String[])pairwiseConcatMemory.get(minKey))[1]);
            hubletsTested.put(minKey, (Double)pairwiseConcat.get(minKey));
            if (hubletsTested.size() < 2) break;
            pairwise.clear();
            pairwiseConcat.clear();
            pairwiseConcatMemory.clear();
        }
        ArrayList<String> toBeRemoved = new ArrayList<String>();
        for (String finalTest : hubletsTested.keySet()) {
            Double finalTestValue = this.testModuleClinical(finalTest, 2, true);
            if (finalTestValue != null) continue;
            toBeRemoved.add(finalTest);
        }
        for (String remove : toBeRemoved) {
            hubletsTested.remove(remove);
        }
        if (hubletsTested.isEmpty()) {
            String emptySet = new String();
            emptySet = "none";
            hubletsTested.put(emptySet, 1.0);
            return hubletsTested;
        }
        HashMap<String, String> hubletPatientSamples = new HashMap<String, String>();
        for (String finalFinalTest : hubletsTested.keySet()) {
            String[] nodes = finalFinalTest.split(":");
            String allSampleString = "";
            for (int j = 0; j < nodes.length; ++j) {
                String thesePatientSamples = this.allGeneSamplesMap.get(nodes[j]);
                if (thesePatientSamples.equals("no_sample")) continue;
                allSampleString = allSampleString + thesePatientSamples + ":";
            }
            if (allSampleString.length() >= 2) {
                allSampleString = allSampleString.substring(0, allSampleString.length() - 1);
            }
            hubletPatientSamples.put(finalFinalTest, allSampleString);
        }
        HashMap<String, Boolean> shouldKeep = new HashMap<String, Boolean>();
        for (String hubs : hubletPatientSamples.keySet()) {
            shouldKeep.put(hubs, true);
        }
        for (String firstSet : hubletPatientSamples.keySet()) {
            for (String secondSet : hubletPatientSamples.keySet()) {
                if (firstSet.equals(secondSet)) continue;
                HashSet<String> compareSet = new HashSet<String>();
                String[] firstCompare = ((String)hubletPatientSamples.get(firstSet)).split(":");
                for (int i = 0; i < firstCompare.length; ++i) {
                    compareSet.add(firstCompare[i]);
                }
                int beforeSize = compareSet.size();
                String[] secondCompare = ((String)hubletPatientSamples.get(secondSet)).split(":");
                for (int i = 0; i < secondCompare.length; ++i) {
                    compareSet.add(secondCompare[i]);
                }
                int afterSize = compareSet.size();
                if (beforeSize != afterSize || !(hubletsTested.get(secondSet) > hubletsTested.get(firstSet))) continue;
                shouldKeep.put(secondSet, false);
            }
        }
        ArrayList<String> toBeRemoved2 = new ArrayList<String>();
        for (String ahh : hubletPatientSamples.keySet()) {
            if (((Boolean)shouldKeep.get(ahh)).booleanValue()) continue;
            toBeRemoved2.add(ahh);
        }
        for (String omg : toBeRemoved2) {
            hubletsTested.remove(omg);
        }
        this.repository.clear();
        return hubletsTested;
    }

    public int getNumberTests() {
        return this.numberTests;
    }

    public String concatenateNetwork(String one, String two) {
        int i;
        String newNetwork = new String();
        newNetwork = "";
        HashSet<String> newHash = new HashSet<String>();
        String[] oneSplit = one.split(":");
        String[] twoSplit = two.split(":");
        for (i = 0; i < oneSplit.length; ++i) {
            newHash.add(oneSplit[i]);
        }
        for (i = 0; i < twoSplit.length; ++i) {
            newHash.add(twoSplit[i]);
        }
        int k = 0;
        for (String addHash : newHash) {
            newNetwork = k == newHash.size() - 1 ? newNetwork + addHash : newNetwork + addHash + ":";
            ++k;
        }
        return newNetwork;
    }

    public Double testModuleFisher(String thisNetwork, int limit) {
        String[] genes = thisNetwork.split(":");
        ArrayList<String> patients = new ArrayList<String>();
        for (int i = 0; i < genes.length; ++i) {
            String[] thesePatients = this.allGeneSamplesMap.get(genes[i]).split(":");
            for (int t = 0; t < thesePatients.length; ++t) {
                patients.add(thesePatients[t]);
            }
        }
        boolean[] var2patients = new boolean[this.otherValues.size()];
        for (int k = 0; k < this.otherValues.size(); ++k) {
            var2patients[k] = false;
            for (int l = 0; l < patients.size(); ++l) {
                if (!((String)patients.get(l)).equals(this.otherValues.get(k)[0])) continue;
                var2patients[k] = true;
            }
        }
        int alpha = 0;
        for (int k = 0; k < var2patients.length; ++k) {
            if (!var2patients[k]) continue;
            ++alpha;
        }
        if (alpha < limit) {
            return null;
        }
        int c = 0;
        int matrix00 = 0;
        for (int k = 0; k < this.otherValues.size(); ++k) {
            if (var2patients[k] && this.otherValues.get(k)[1].equals(this.foregroundvariable)) {
                ++matrix00;
            }
            if (!this.otherValues.get(k)[1].equals(this.foregroundvariable)) continue;
            ++c;
        }
        MyFET fet = new MyFET(this.otherValues.size(), c, alpha, matrix00);
        return fet.getResult();
    }

    public int testModuleBoolean(String thisNetwork) {
        String[] genes = thisNetwork.split(":");
        HashSet<String> truePatients = new HashSet<String>();
        if (genes[0].equals("none")) {
            return 2;
        }
        for (int i = 0; i < genes.length; ++i) {
            String[] thesePatients = this.allGeneSamplesMap.get(genes[i]).split(":");
            for (int t = 0; t < thesePatients.length; ++t) {
                if (thesePatients[t].equals("no_sample")) continue;
                truePatients.add(thesePatients[t]);
            }
        }
        int alpha = truePatients.size();
        ArrayDeque<Double> time1 = new ArrayDeque<Double>();
        ArrayDeque<Double> time2 = new ArrayDeque<Double>();
        ArrayDeque<Double> censor1 = new ArrayDeque<Double>();
        ArrayDeque<Double> censor2 = new ArrayDeque<Double>();
        for (int i = 0; i < this.allPatients.length; ++i) {
            if (truePatients.contains(this.allPatients[i])) {
                time1.add(this.followupDays[i]);
                censor1.add(this.censor[i]);
                continue;
            }
            time2.add(this.followupDays[i]);
            censor2.add(this.censor[i]);
        }
        if (this.logRankObject.logRankSurvivalTest(time1, time2, censor1, censor2)) {
            return 1;
        }
        return 0;
    }

    public Double testModuleClinical(String thisNetwork, int limit, boolean flag) {
        if (this.statTest.equals("fisher")) {
            return this.testModuleFisher(thisNetwork, limit);
        }
        String[] genes = thisNetwork.split(":");
        HashSet<String> truePatients = new HashSet<String>();
        for (int i = 0; i < genes.length; ++i) {
            String[] thesePatients = this.allGeneSamplesMap.get(genes[i]).split(":");
            for (int t = 0; t < thesePatients.length; ++t) {
                if (thesePatients[t].equals("no_sample")) continue;
                truePatients.add(thesePatients[t]);
            }
        }
        int alpha = truePatients.size();
        if (alpha < limit) {
            return null;
        }
        if (flag) {
            return 1.0;
        }
        ArrayDeque<Double> time1 = new ArrayDeque<Double>();
        ArrayDeque<Double> time2 = new ArrayDeque<Double>();
        ArrayDeque<Double> censor1 = new ArrayDeque<Double>();
        ArrayDeque<Double> censor2 = new ArrayDeque<Double>();
        for (int i = 0; i < this.allPatients.length; ++i) {
            if (truePatients.contains(this.allPatients[i])) {
                time1.add(this.followupDays[i]);
                censor1.add(this.censor[i]);
                continue;
            }
            time2.add(this.followupDays[i]);
            censor2.add(this.censor[i]);
        }
        Double pValue = 0.0;
        if (this.statTest.equals("logRank")) {
            Double[] result = this.logRankObject.logRank(time1, time2, censor1, censor2);
            pValue = result[2];
            ++this.numberTests;
        } else if (this.statTest.equals("CoxPh")) {
            double[] group = new double[this.allPatients.length];
            for (int k = 0; k < this.allPatients.length; ++k) {
                group[k] = truePatients.contains(this.allPatients[k]) ? 1.0 : 2.0;
            }
            pValue = this.coxModel.cox(group);
        }
        return pValue;
    }

    public void initOther() {
        int k;
        this.otherPatients = new String[this.otherValues.size()];
        for (k = 0; k < this.otherValues.size(); ++k) {
            this.otherPatients[k] = this.otherValues.get(k)[0];
        }
        this.clinicalVariableMap = new HashMap();
        this.clinicalVariableHash = new HashSet();
        for (k = 0; k < this.otherValues.size(); ++k) {
            this.clinicalVariableMap.put(this.otherValues.get(k)[0], this.otherValues.get(k)[1]);
            this.clinicalVariableHash.add(this.otherValues.get(k)[1]);
        }
        this.hashArray = new ArrayList();
        for (String hashElement : this.clinicalVariableHash) {
            this.hashArray.add(hashElement);
        }
        this.clinicalVariable = new String[this.otherValues.size()];
        for (int k2 = 0; k2 < this.otherValues.size(); ++k2) {
            this.clinicalVariable[k2] = this.otherValues.get(k2)[1];
        }
    }

    public void initClinicals() {
        int k;
        this.allPatients = new String[this.clinicalValues.size()];
        for (k = 0; k < this.clinicalValues.size(); ++k) {
            this.allPatients[k] = this.clinicalValues.get(k)[0];
        }
        this.status = new boolean[this.clinicalValues.size()];
        for (k = 0; k < this.clinicalValues.size(); ++k) {
            this.status[k] = this.clinicalValues.get(k)[1].toUpperCase().equals("DECEASED") || this.clinicalValues.get(k)[1].toUpperCase().equals("NO") || this.clinicalValues.get(k)[1].toUpperCase().equals("N") || this.clinicalValues.get(k)[1].equals("1");
        }
        this.followupDays = new double[this.clinicalValues.size()];
        for (k = 0; k < this.clinicalValues.size(); ++k) {
            this.followupDays[k] = Double.valueOf(this.clinicalValues.get(k)[2]);
        }
        this.censor = new double[this.clinicalValues.size()];
        for (k = 0; k < this.clinicalValues.size(); ++k) {
            this.censor[k] = this.status[k] ? 1.0 : 0.0;
        }
    }

    public ArrayList<String> compressTokens(HashSet<String> allPaths, String seedName) {
        ArrayList<String> compress = new ArrayList<String>();
        HashMap<String, String> allPatients = new HashMap<String, String>();
        for (String network : allPaths) {
            String patients = this.allGeneSamplesMap.get(seedName);
            String[] genes = network.split(":");
            for (int i = 0; i < genes.length; ++i) {
                if (genes[i].equals(seedName) || this.allGeneSamplesMap.get(genes[i]).equals("no_sample")) continue;
                patients = patients + ":" + this.allGeneSamplesMap.get(genes[i]);
            }
            if (allPatients.get(patients) == null) {
                allPatients.put(patients, network);
                continue;
            }
            String[] genes2 = ((String)allPatients.get(patients)).split(":");
            if (genes.length >= genes2.length) continue;
            allPatients.put(patients, network);
        }
        for (String list : allPatients.keySet()) {
            compress.add((String)allPatients.get(list));
        }
        return compress;
    }

    public HashMap<HashSet<String>, Double> expandToHashSet(HashMap<String, Double> original) {
        HashMap<HashSet<String>, Double> returnValue = new HashMap<HashSet<String>, Double>();
        for (String genez : original.keySet()) {
            String[] expanded = genez.split(":");
            HashSet<String> newHashSet = new HashSet<String>();
            for (int i = 0; i < expanded.length; ++i) {
                newHashSet.add(expanded[i]);
            }
            returnValue.put(newHashSet, original.get(genez));
        }
        return returnValue;
    }

    public void shuffleLabels() {
        Collections.shuffle(this.allSamples);
        for (int i = 0; i < this.allGenes.size(); ++i) {
            this.allGeneSamplesMap.put(this.allGenes.get(i), this.allSamples.get(i));
        }
    }
}

