/*
 * Decompiled with CFR 0.152.
 */
package jsc;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;

public class Utilities {
    private Utilities() {
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public static String deleteChar(char c, String string) {
        Character c2 = new Character(c);
        return Utilities.deleteChars(c2.toString(), string);
    }

    public static String deleteChars(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string);
        StringBuffer stringBuffer = new StringBuffer(string2.length());
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
        }
        return stringBuffer.toString();
    }

    public static int keyCodeToDigit(int n) {
        switch (n) {
            case 49: {
                return 1;
            }
            case 50: {
                return 2;
            }
            case 51: {
                return 3;
            }
            case 52: {
                return 4;
            }
            case 53: {
                return 5;
            }
            case 54: {
                return 6;
            }
            case 55: {
                return 7;
            }
            case 56: {
                return 8;
            }
            case 57: {
                return 9;
            }
            case 48: {
                return 0;
            }
        }
        return -1;
    }

    public static File getParentDirectory() {
        FileSystemView fileSystemView = FileSystemView.getFileSystemView();
        File file = fileSystemView.getParentDirectory(fileSystemView.getHomeDirectory());
        return file;
    }

    public static char getSuperscriptChar(int n) {
        switch (n) {
            case 1: {
                return '\u00b9';
            }
            case 2: {
                return '\u00b2';
            }
            case 3: {
                return '\u00b3';
            }
            case 4: {
                return '\u2074';
            }
            case 5: {
                return '\u2075';
            }
            case 6: {
                return '\u2076';
            }
            case 7: {
                return '\u2077';
            }
            case 8: {
                return '\u2078';
            }
            case 9: {
                return '\u2079';
            }
            case 0: {
                return '\u2070';
            }
        }
        throw new IllegalArgumentException("Invalid superscript value " + n);
    }

    public static File getUserDirectory() {
        File file = new File(System.getProperty("user.dir"));
        return file;
    }

    public static boolean isVersionOK() {
        String string = System.getProperty("java.version");
        if (string.compareTo("1.4.0") < 0) {
            System.out.println("WARNING: This program was designed to run with a version 1.4.0 (or higher) Virtual Machine.");
            return false;
        }
        return true;
    }

    public static boolean isVersionOK(Component component) {
        String string = System.getProperty("java.version");
        if (string.compareTo("1.4.0") < 0) {
            JOptionPane.showMessageDialog(component, "WARNING: This program was designed to run with a version 1.4.0 (or higher) Virtual Machine.", "Java version warning", 2);
            return false;
        }
        return true;
    }

    public static int lengthOf(int n) {
        return Integer.toString(n).length();
    }

    public static void setNativeLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {}
    }

    public static void tile(Graphics graphics, Component component, ImageIcon imageIcon) {
        Rectangle rectangle = component.getBounds();
        int n = imageIcon.getIconWidth();
        int n2 = imageIcon.getIconHeight();
        if (n <= 0 || n2 <= 0) {
            return;
        }
        int n3 = 0;
        while (n3 < rectangle.width) {
            int n4 = 0;
            while (n4 < rectangle.height) {
                imageIcon.paintIcon(component, graphics, n3, n4);
                n4 += n2;
            }
            n3 += n;
        }
    }

    public static String toString(String[] stringArray) {
        return Utilities.toString(stringArray, ", ");
    }

    public static String toString(String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer(100);
        int n = 0;
        while (n < stringArray.length - 1) {
            stringBuffer.append(stringArray[n]);
            stringBuffer.append(string);
            ++n;
        }
        stringBuffer.append(stringArray[n]);
        return stringBuffer.toString();
    }

    public static Vector toVector(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            vector.add(stringArray[n]);
            ++n;
        }
        return vector;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            int[] nArray = new int[]{0, 0, 1, 2, -1, 9, 10, -10, 99, 100, -100, 101, 1000, 99999};
            int n = 0;
            while (n < nArray.length) {
                System.out.println("Length of " + nArray[n] + " is " + Utilities.lengthOf(nArray[n]));
                ++n;
            }
        }
    }
}

