/*
 * Decompiled with CFR 0.152.
 */
package jsc.combinatorics;

import java.util.NoSuchElementException;
import java.util.Random;
import jsc.combinatorics.Enumerator;
import jsc.combinatorics.Selection;
import jsc.util.BitVector;

public class GrayCode
implements Enumerator {
    private int k;
    private Random rand;
    private boolean firstCall;
    private boolean finalExit;
    private int n;
    private int[] a;
    private final double subsetCount;

    public GrayCode(int n) {
        this.n = n;
        this.subsetCount = Math.pow(2.0, n);
        if (n < 1) {
            throw new IllegalArgumentException("n < 1.");
        }
        this.a = new int[n + 1];
        this.rand = new Random();
        this.reset();
    }

    public double countSelections() {
        return this.subsetCount;
    }

    private BitVector getBitVector() {
        BitVector bitVector = new BitVector(this.n);
        int n = 1;
        while (n <= this.n) {
            bitVector.set(n - 1, this.a[n] == 1);
            ++n;
        }
        return bitVector;
    }

    public int getN() {
        return this.n;
    }

    public boolean hasNext() {
        return !this.finalExit;
    }

    public Selection nextSelection() {
        return this.nextBitVector();
    }

    public BitVector nextBitVector() {
        if (this.finalExit) {
            throw new NoSuchElementException();
        }
        this.a[0] = 0;
        if (this.firstCall) {
            this.firstCall = false;
            return this.getBitVector();
        }
        int n = this.k % 2;
        int n2 = 1;
        if (n != 0) {
            while (this.a[++n2 - 1] != 1) {
            }
        }
        this.a[n2] = 1 - this.a[n2];
        this.k = this.k + 2 * this.a[n2] - 1;
        if (this.k == this.a[this.n]) {
            this.finalExit = true;
        }
        return this.getBitVector();
    }

    public Selection randomSelection() {
        return this.randomBitVector();
    }

    public BitVector randomBitVector() {
        BitVector bitVector = new BitVector(this.n);
        int n = 0;
        while (n < this.n) {
            bitVector.set(n, this.rand.nextBoolean());
            ++n;
        }
        return bitVector;
    }

    public void reset() {
        int n = 1;
        while (n <= this.n) {
            this.a[n] = 0;
            ++n;
        }
        this.firstCall = true;
        this.finalExit = false;
        this.k = 0;
    }

    public void setSeed(long l) {
        this.rand.setSeed(l);
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            BitVector bitVector;
            int n = 4;
            GrayCode grayCode = new GrayCode(n);
            int n2 = (int)grayCode.countSelections();
            System.out.println("Number of bit vectors = " + n2);
            while (grayCode.hasNext()) {
                bitVector = (BitVector)grayCode.nextSelection();
                System.out.println(bitVector.toString());
            }
            System.out.println("Random Gray codes");
            int n3 = 0;
            while (n3 < 10) {
                bitVector = (BitVector)grayCode.randomSelection();
                System.out.println(bitVector.toString());
                ++n3;
            }
        }
    }
}

