/*
 * Decompiled with CFR 0.152.
 */
package jsc.correlation;

import jsc.datastructures.PairedData;
import jsc.distributions.Normal;
import jsc.tests.H1;
import jsc.tests.SignificanceTest;

public class KendallCorrelation
implements SignificanceTest {
    private final int n;
    private final double r;
    private int T;
    private double SP;

    public KendallCorrelation(PairedData pairedData, H1 h1, double d) {
        int n = 0;
        int n2 = 0;
        this.n = pairedData.getN();
        double[] dArray = pairedData.getX();
        double[] dArray2 = pairedData.getY();
        this.T = 0;
        int n3 = 0;
        while (n3 < this.n - 1) {
            int n4 = n3 + 1;
            while (n4 < this.n) {
                double d2;
                double d3 = dArray[n3] - dArray[n4];
                double d4 = dArray2[n3] - dArray2[n4];
                if (Math.abs(d3) <= d) {
                    d3 = 0.0;
                }
                if (Math.abs(d4) <= d) {
                    d4 = 0.0;
                }
                if ((d2 = d3 * d4) != 0.0) {
                    ++n2;
                    ++n;
                    this.T = d2 > 0.0 ? ++this.T : --this.T;
                } else {
                    if (d3 != 0.0) {
                        ++n2;
                    }
                    if (d4 != 0.0) {
                        ++n;
                    }
                }
                ++n4;
            }
            ++n3;
        }
        this.r = (double)this.T / (Math.sqrt(n2) * Math.sqrt(n));
        this.SP = h1 == H1.LESS_THAN ? KendallCorrelation.lowerTailProb(this.n, this.T) : (h1 == H1.GREATER_THAN ? KendallCorrelation.upperTailProb(this.n, this.T) : (this.r < 0.0 ? 2.0 * KendallCorrelation.lowerTailProb(this.n, this.T) : (this.r > 0.0 ? 2.0 * KendallCorrelation.upperTailProb(this.n, this.T) : 1.0)));
        if (this.SP > 1.0) {
            this.SP = 1.0;
        }
    }

    public KendallCorrelation(PairedData pairedData, H1 h1) {
        this(pairedData, h1, 0.0);
    }

    public KendallCorrelation(PairedData pairedData) {
        this(pairedData, H1.NOT_EQUAL, 0.0);
    }

    public int getN() {
        return this.n;
    }

    public double getR() {
        return this.r;
    }

    public double getSP() {
        return this.SP;
    }

    public int getT() {
        return this.T;
    }

    public double getTestStatistic() {
        return this.r;
    }

    public static double lowerTailProb(int n, int n2) {
        return 1.0 - KendallCorrelation.upperTailProb(n, n2 + 2);
    }

    public static double upperTailProb(int n, int n2) {
        int n3;
        double d = 1.0;
        int[][] nArray = new int[3][16];
        double[] dArray = new double[16];
        if (n < 1) {
            throw new IllegalArgumentException("n < 1.");
        }
        int n4 = n * (n - 1) / 2 - Math.abs(n2);
        if (n4 == 0 && n2 <= 0) {
            return d;
        }
        if (n > 8) {
            double d2;
            dArray[1] = d2 = (double)(n2 - 1) / Math.sqrt((double)(6 + n * (5 - n * (3 + 2 * n))) / -18.0);
            nArray[1][1] = (int)d2;
            dArray[2] = d2 * d2 - 1.0;
            int n5 = 3;
            while (n5 <= 15) {
                dArray[n5] = d2 * dArray[n5 - 1] - (double)(n5 - 1) * dArray[n5 - 2];
                ++n5;
            }
            double d3 = 1.0 / (double)n;
            double d4 = d3 * (dArray[3] * (-0.09 + d3 * (0.045 + d3 * (-0.5325 + d3 * 0.506))) + d3 * (dArray[5] * (0.036735 + d3 * (-0.036735 + d3 * 0.3214)) + dArray[7] * (0.00405 + d3 * (-0.023336 + d3 * 0.07787)) + d3 * (dArray[9] * (-0.0033061 - d3 * 0.0065166) + dArray[11] * (-1.215E-4 + d3 * 0.0025927) + d3 * (dArray[13] * 1.4878E-4 + dArray[15] * 2.7338E-6))));
            d = Normal.standardTailProb(d2, true) + d4 * 0.398942 * Math.exp(-0.5 * d2 * d2);
            if (d < 0.0) {
                d = 0.0;
            }
            if (d > 1.0) {
                d = 1.0;
            }
            return d;
        }
        if (n2 < 0) {
            n4 -= 2;
        }
        int n6 = n4 / 2 + 1;
        nArray[1][1] = 1;
        dArray[1] = 1.0;
        nArray[2][1] = 1;
        if (n6 >= 2) {
            n3 = 2;
            while (n3 <= n6) {
                nArray[1][n3] = 0;
                nArray[2][n3] = 0;
                ++n3;
            }
        }
        int n7 = 1;
        n3 = 1;
        n4 = 1;
        int n8 = 1;
        int n9 = 2;
        block2: while (true) {
            int n10;
            if (n3 == n) {
                n10 = 0;
                n3 = 1;
                while (n3 <= n6) {
                    n10 += nArray[n9][n3];
                    ++n3;
                }
                d = (double)n10 / (double)n4;
                if (n2 < 0) {
                    d = 1.0 - d;
                }
                return d;
            }
            n7 += n3;
            n4 *= ++n3;
            n8 = 3 - n8;
            n9 = 3 - n9;
            int n11 = 1;
            int n12 = 0;
            n10 = Math.min(n6, n7);
            while (true) {
                if (++n11 > n10) continue block2;
                nArray[n9][n11] = nArray[n9][n11 - 1] + nArray[n8][n11];
                if (n11 <= n3) continue;
                int[] nArray2 = nArray[n9];
                int n13 = n11;
                nArray2[n13] = nArray2[n13] - nArray[n8][++n12];
            }
            break;
        }
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double[] dArray = new double[]{6.0, 3.0, 2.0, 5.0, 1.0, 7.0, 4.0};
            double[] dArray2 = new double[]{4.0, 5.0, 1.0, 7.0, 3.0, 6.0, 2.0};
            KendallCorrelation kendallCorrelation = new KendallCorrelation(new PairedData(dArray, dArray2), H1.LESS_THAN, 0.0);
            System.out.println("n = " + kendallCorrelation.getN() + " T = " + kendallCorrelation.getT() + " r = " + kendallCorrelation.getR() + " SP = " + kendallCorrelation.getSP());
            kendallCorrelation = new KendallCorrelation(new PairedData(dArray, dArray2), H1.NOT_EQUAL, 0.0);
            System.out.println("n = " + kendallCorrelation.getN() + " T = " + kendallCorrelation.getT() + " r = " + kendallCorrelation.getR() + " SP = " + kendallCorrelation.getSP());
            kendallCorrelation = new KendallCorrelation(new PairedData(dArray, dArray2), H1.GREATER_THAN, 0.0);
            System.out.println("n = " + kendallCorrelation.getN() + " T = " + kendallCorrelation.getT() + " r = " + kendallCorrelation.getR() + " SP = " + kendallCorrelation.getSP());
            int n = 8;
            int n2 = 0;
            while (n2 <= 28) {
                System.out.println("n = " + n + " S = " + n2 + " p = " + KendallCorrelation.upperTailProb(n, n2));
                ++n2;
            }
        }
    }
}

