/*
 * Decompiled with CFR 0.152.
 */
package jsc.curvefitting;

import jsc.ci.AbstractConfidenceInterval;
import jsc.ci.ConfidenceInterval;
import jsc.curvefitting.StraightLineFit;
import jsc.datastructures.PairedData;
import jsc.distributions.StudentsT;

public class LineFitThruOrigin
implements StraightLineFit {
    private final int n;
    private double b;
    private double chi2;
    private double ax;
    private double ay;
    private final double sxx;
    private final PairedData data;

    public LineFitThruOrigin(PairedData pairedData) {
        double d;
        this.data = pairedData;
        this.n = pairedData.getN();
        double[] dArray = pairedData.getX();
        double[] dArray2 = pairedData.getY();
        this.b = 0.0;
        double d2 = 0.0;
        this.ay = 0.0;
        this.ax = 0.0;
        double d3 = 0.0;
        int n = 0;
        while (n < this.n) {
            this.ax += dArray[n];
            this.ay += dArray2[n];
            ++n;
        }
        this.ax /= (double)this.n;
        this.ay /= (double)this.n;
        n = 0;
        while (n < this.n) {
            double d4 = dArray[n] - this.ax;
            d = dArray2[n] - this.ay;
            d3 += d4 * d4;
            d2 += d4 * d;
            ++n;
        }
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("X data are constant.");
        }
        this.sxx = d3 + (double)this.n * this.ax * this.ax;
        this.b = (d2 + (double)this.n * this.ax * this.ay) / this.sxx;
        this.chi2 = 0.0;
        n = 0;
        while (n < this.n) {
            d = dArray2[n] - this.b * dArray[n];
            this.chi2 += d * d;
            ++n;
        }
    }

    public double getA() {
        return 0.0;
    }

    public double getB() {
        return this.b;
    }

    public ConfidenceInterval getCIB(double d) {
        if (d <= 0.0 || d >= 1.0) {
            throw new IllegalArgumentException("Invalid confidence coefficient.");
        }
        if (this.n < 2) {
            throw new IllegalArgumentException("Insufficient data for CI.");
        }
        double d2 = this.getQuantileOfT(d);
        double d3 = this.chi2 / (double)(this.n - 1);
        double d4 = Math.sqrt(d3 / this.sxx);
        double d5 = d2 * d4;
        return new AbstractConfidenceInterval(d, this.b - d5, this.b + d5);
    }

    public double[][] getIntervals(double d, int n, double d2, double d3) {
        if (d <= 0.0 || d >= 1.0) {
            throw new IllegalArgumentException("Invalid confidence coefficient");
        }
        if (this.n < 2) {
            throw new IllegalArgumentException("Insufficient data for CI.");
        }
        if (d3 <= d2) {
            throw new IllegalArgumentException("Invalid x values.");
        }
        double d4 = this.getQuantileOfT(d);
        double d5 = Math.sqrt(this.chi2 / (double)(this.n - 1));
        double[][] dArray = new double[n][5];
        double d6 = (d3 - d2) / ((double)n - 1.0);
        double d7 = d4 * d5;
        int n2 = 0;
        while (n2 < n) {
            double d8 = d2 + (double)n2 * d6;
            double d9 = this.b * d8;
            double d10 = d8 * d8 / this.sxx;
            double d11 = d7 * Math.sqrt(d10);
            double d12 = d7 * Math.sqrt(d10 + 1.0);
            dArray[n2][0] = d8;
            dArray[n2][1] = d9 - d11;
            dArray[n2][2] = d9 + d11;
            dArray[n2][3] = d9 - d12;
            dArray[n2][4] = d9 + d12;
            ++n2;
        }
        return dArray;
    }

    public double getMeanX() {
        return this.ax;
    }

    public double getMeanY() {
        return this.ay;
    }

    public int getN() {
        return this.n;
    }

    double getQuantileOfT(double d) {
        StudentsT studentsT = new StudentsT(this.n - 1);
        double d2 = 1.0 - d;
        return studentsT.inverseCdf(1.0 - 0.5 * d2);
    }

    public double getSumOfSquares() {
        return this.chi2;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double[] dArray = new double[]{9.5, 9.8, 5.0, 19.0, 23.0, 14.6, 15.2, 8.3, 11.4, 21.6, 11.8, 26.5, 12.1, 4.8, 22.0, 21.7, 28.2, 18.0, 12.1, 28.0};
            double[] dArray2 = new double[]{10.7, 11.7, 6.5, 25.6, 29.4, 16.3, 17.2, 9.5, 18.4, 28.8, 19.7, 31.2, 16.6, 6.5, 29.0, 25.7, 40.5, 26.5, 14.2, 33.1};
            LineFitThruOrigin lineFitThruOrigin = new LineFitThruOrigin(new PairedData(dArray, dArray2));
            System.out.println("n = " + lineFitThruOrigin.getN());
            System.out.println("b = " + lineFitThruOrigin.getB());
            System.out.println("rss = " + lineFitThruOrigin.getSumOfSquares());
            ConfidenceInterval confidenceInterval = lineFitThruOrigin.getCIB(0.9);
            System.out.println("CI for b = [" + confidenceInterval.getLowerLimit() + ", " + confidenceInterval.getUpperLimit() + "]");
        }
    }
}

