/*
 * Decompiled with CFR 0.152.
 */
package jsc.descriptive;

import java.util.Vector;
import jsc.descriptive.AbstractFrequencyTable;
import jsc.util.CaseInsensitiveVector;
import jsc.util.Sort;

public class CategoricalTally
extends AbstractFrequencyTable
implements Cloneable {
    public static final String[] LETTER_LABELS = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    protected Vector labels = new Vector();

    public CategoricalTally(String string, String[] stringArray) {
        super(string);
        this.labels = Sort.getLabels(stringArray);
        this.numberOfBins = this.labels.size();
        this.n = 0;
        this.freq = new int[this.numberOfBins];
        int n = 0;
        while (n < this.numberOfBins) {
            this.freq[n] = 0;
            ++n;
        }
        n = 0;
        while (n < stringArray.length) {
            this.addValue(stringArray[n]);
            ++n;
        }
    }

    public CategoricalTally(String string, String[] stringArray, String[] stringArray2) {
        super(string);
        this.numberOfBins = stringArray.length;
        this.labels = new CaseInsensitiveVector(this.numberOfBins);
        int n = 0;
        while (n < this.numberOfBins) {
            this.labels.add(stringArray[n]);
            ++n;
        }
        this.n = 0;
        this.freq = new int[this.numberOfBins];
        n = 0;
        while (n < this.numberOfBins) {
            this.freq[n] = 0;
            ++n;
        }
        n = 0;
        while (n < stringArray2.length) {
            this.addValue(stringArray2[n]);
            ++n;
        }
    }

    public CategoricalTally(String string, String[] stringArray, int[] nArray) {
        super(string);
        this.numberOfBins = stringArray.length;
        if (this.numberOfBins != nArray.length) {
            throw new IllegalArgumentException("Arrays not same length.");
        }
        this.labels = new CaseInsensitiveVector(this.numberOfBins);
        int n = 0;
        while (n < this.numberOfBins) {
            this.labels.add(stringArray[n]);
            ++n;
        }
        this.n = 0;
        this.freq = new int[this.numberOfBins];
        n = 0;
        while (n < this.numberOfBins) {
            this.freq[n] = nArray[n];
            this.n += nArray[n];
            ++n;
        }
    }

    public boolean addValue(String string) {
        int n = this.labels.indexOf(string);
        if (n < 0) {
            return false;
        }
        ++this.n;
        int n2 = n;
        this.freq[n2] = this.freq[n2] + 1;
        return true;
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("CategoricalTally can't clone");
        }
        return object;
    }

    public String getLabel(int n) {
        return (String)this.labels.elementAt(n);
    }

    public String[] getLabels() {
        String[] stringArray = new String[this.labels.size()];
        return this.labels.toArray(stringArray);
    }

    public int indexOf(String string) {
        return this.labels.indexOf(string);
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            String[] stringArray2 = new String[]{"D", "B", "C", "D", "A", "e", "B", "a", "c", "A", "B", "E", "A", "b", "C", "a", "E", "c", "E"};
            CategoricalTally categoricalTally = new CategoricalTally("Test", stringArray2);
            System.out.println("Tally " + categoricalTally.getN() + " values");
            int n = 0;
            while (n < categoricalTally.getNumberOfBins()) {
                System.out.println(categoricalTally.getLabel(n) + ", Freq = " + categoricalTally.getFrequency(n) + ", % = " + categoricalTally.getPercentage(n));
                ++n;
            }
        }
    }
}

