/*
 * Decompiled with CFR 0.152.
 */
package jsc.descriptive;

public class Tally
implements Cloneable {
    private int n;
    private int min;
    private int max;
    private int k;
    private int[] freq;

    public Tally(int[] nArray) {
        this.min = Integer.MAX_VALUE;
        this.max = Integer.MIN_VALUE;
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] < this.min) {
                this.min = nArray[n];
            }
            if (nArray[n] > this.max) {
                this.max = nArray[n];
            }
            ++n;
        }
        this.k = 1 + this.max - this.min;
        this.freq = new int[this.k];
        this.clearData();
        n = 0;
        while (n < nArray.length) {
            this.addValue(nArray[n]);
            ++n;
        }
    }

    public Tally(int n, int n2) {
        if (n2 <= n) {
            throw new IllegalArgumentException("Invalid bins");
        }
        this.k = 1 + n2 - n;
        this.min = n;
        this.max = n2;
        this.freq = new int[this.k];
        this.clearData();
    }

    public Tally(int n, int n2, int[] nArray) {
        this(n, n2);
        int n3 = 0;
        while (n3 < nArray.length) {
            this.addValue(nArray[n3]);
            ++n3;
        }
    }

    public Tally(int n, int[] nArray) {
        this.k = nArray.length;
        this.min = n;
        this.max = n + this.k - 1;
        this.freq = new int[this.k];
        this.n = 0;
        int n2 = 0;
        while (n2 < this.k) {
            this.freq[n2] = nArray[n2];
            this.n += nArray[n2];
            ++n2;
        }
    }

    public int addValue(int n) {
        if (n >= this.min && n <= this.max) {
            int n2;
            ++this.n;
            int n3 = n2 = n - this.min;
            this.freq[n3] = this.freq[n3] + 1;
            return n2;
        }
        return -1;
    }

    public void clearData() {
        this.n = 0;
        int n = 0;
        while (n < this.k) {
            this.freq[n] = 0;
            ++n;
        }
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("Tally can't clone");
        }
        return object;
    }

    public int getBinValue(int n) {
        return this.min + n;
    }

    public int[] getFrequencies() {
        return this.freq;
    }

    public int getFrequency(int n) {
        return this.freq[n];
    }

    public int getMax() {
        return this.max;
    }

    public int getMaxFreq() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.k) {
            if (this.freq[n2] > n) {
                n = this.freq[n2];
            }
            ++n2;
        }
        return n;
    }

    public int getMin() {
        return this.min;
    }

    public int getNumberOfBins() {
        return this.k;
    }

    public int getN() {
        return this.n;
    }

    public double getPercentage(int n) {
        return this.n > 0 ? 100.0 * ((double)this.freq[n] / (double)this.n) : 0.0;
    }

    public double getProportion(int n) {
        return this.n > 0 ? (double)this.freq[n] / (double)this.n : 0.0;
    }

    public int indexOf(int n) {
        if (n >= this.min && n <= this.max) {
            return n - this.min;
        }
        return -1;
    }

    public void setData(int[] nArray) {
        this.clearData();
        int n = 0;
        while (n < nArray.length) {
            this.addValue(nArray[n]);
            ++n;
        }
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            int[] nArray = new int[]{4, 5, 8, 9, 3, 2, 5, 4, 6, 7, 8, 9, 2, 1, 0, -3, -2, 0, -6, -3};
            Tally tally = new Tally(nArray);
            System.out.println("Tally " + tally.getN() + " values, " + "Min = " + tally.getMin() + ", Max = " + tally.getMax());
            int n = 0;
            while (n < tally.getNumberOfBins()) {
                System.out.println(tally.getBinValue(n) + ", Freq = " + tally.getFrequency(n) + ", % = " + tally.getPercentage(n));
                ++n;
            }
            n = 0;
            while (n < nArray.length) {
                System.out.println("Index of " + nArray[n] + " is " + tally.indexOf(nArray[n]));
                ++n;
            }
        }
    }
}

