/*
 * Decompiled with CFR 0.152.
 */
package jsc.distributions;

import jsc.distributions.AbstractDistribution;

public abstract class AbstractDiscreteDistribution
extends AbstractDistribution {
    protected long minValue;
    protected long maxValue;

    public AbstractDiscreteDistribution(long l, long l2) {
        if (l >= l2) {
            throw new IllegalArgumentException("Invalid variate range: " + l + " to " + l2 + ".");
        }
        this.minValue = l;
        this.maxValue = l2;
    }

    public double cdf(double d) {
        if (d < (double)this.minValue || d > (double)this.maxValue) {
            throw new IllegalArgumentException("Invalid variate-value.");
        }
        double d2 = 0.0;
        long l = this.minValue;
        while ((double)l <= d) {
            d2 += this.pdf(l);
            ++l;
        }
        return d2;
    }

    public double getMaximumPdf() {
        long l = this.minValue;
        double d = 0.0;
        long l2 = 0L;
        while (l2 < this.maxValue - this.minValue + 1L) {
            double d2 = this.pdf(l);
            if (d2 > d) {
                d = d2;
            }
            ++l;
            ++l2;
        }
        return d;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public long getMinValue() {
        return this.minValue;
    }

    public double moment(int n) {
        return this.moment(n, 0.0);
    }

    public double moment(int n, double d) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid moment order.");
        }
        if (n == 0) {
            return 1.0;
        }
        long l = this.minValue;
        double d2 = 0.0;
        long l2 = 0L;
        while (l2 < this.maxValue - this.minValue + 1L) {
            d2 += Math.pow((double)l - d, n) * this.pdf(l);
            ++l;
            ++l2;
        }
        return d2;
    }

    public double inverseCdf(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Invalid probability " + d);
        }
        double d2 = this.cdf(this.minValue);
        if (d2 >= d) {
            return this.minValue;
        }
        double d3 = this.cdf(this.maxValue);
        if (d3 < d) {
            return this.maxValue;
        }
        long l = this.minValue;
        long l2 = this.maxValue;
        while (true) {
            long l3;
            if ((l3 = l2 - l) <= 1L) {
                if (this.cdf(l) >= d) {
                    return l;
                }
                return l2;
            }
            long l4 = l + (l3 /= 2L);
            double d4 = this.cdf(l4);
            if (d4 < d) {
                l = l4;
                continue;
            }
            l2 = l4;
        }
    }

    public boolean isDiscrete() {
        return true;
    }

    public double mean() {
        long l = this.minValue;
        double d = 0.0;
        long l2 = 0L;
        while (l2 < this.maxValue - this.minValue + 1L) {
            d += (double)l * this.pdf(l);
            ++l;
            ++l2;
        }
        return d;
    }

    public abstract double pdf(double var1);

    public double variance() {
        return this.moment(2, this.mean());
    }
}

