/*
 * Decompiled with CFR 0.152.
 */
package jsc.distributions;

import jsc.distributions.Gamma;
import jsc.distributions.Normal;
import jsc.goodnessfit.KolmogorovTest;
import jsc.tests.H1;

public class ChiSquared
extends Gamma {
    private double df;
    private static final int MAXIT = 20;
    private static final double E = 5.0E-17;

    public ChiSquared(double d) {
        super(0.5 * d, 2.0);
        this.df = d;
    }

    public double getDf() {
        return this.df;
    }

    public double inverseCdf(double d) {
        return ChiSquared.inverseCdf(d, this.df, this.logGammaShape);
    }

    public static double inverseCdf(double d, double d2, double d3) {
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        if (d < 0.0) {
            throw new IllegalArgumentException("Invalid probability.");
        }
        if (d > 0.999998) {
            return Double.POSITIVE_INFINITY;
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("Invalid distribution parameter.");
        }
        double d10 = 0.5 * d2;
        double d11 = d10 - 1.0;
        if (d2 >= -(1.24 * Math.log(d))) {
            if (d2 > 0.32) {
                double d12 = Normal.inverseStandardCdf(d);
                d8 = d2 * Math.pow(d12 * Math.sqrt(d9 = 0.222222 / d2) + 1.0 - d9, 3.0);
                if (d8 > 2.2 * d2 + 6.0) {
                    d8 = -2.0 * (Math.log(1.0 - d) - d11 * Math.log(0.5 * d8) + d3);
                }
            } else {
                d8 = 0.4;
                d7 = Math.log(1.0 - d);
                do {
                    d6 = d8;
                    d9 = 1.0 + d8 * (4.67 + d8);
                    d5 = d8 * (6.73 + d8 * (6.66 + d8));
                    d4 = -0.5 + (4.67 + d8 + d8) / d9 - (6.73 + d8 * (13.32 + 3.0 * d8)) / d5;
                } while (Math.abs(d6 / (d8 -= (1.0 - Math.exp(d7 + d3 + 0.5 * d8 + d11 * 0.6931471806) * d5 / d9) / d4) - 1.0) > 0.01);
            }
        } else {
            d8 = Math.pow(d * d10 * Math.exp(d3 + d10 * 0.6931471806), 1.0 / d10);
            if (d8 < 5.0E-17) {
                return d8;
            }
        }
        double d13 = d8;
        int n = 0;
        do {
            double d14;
            double d15;
            double d16;
            double d17;
            double d18;
            double d19;
            double d20;
            d6 = d8;
            if (!Double.isNaN(d8 += (d4 = (d5 = d - Gamma.incompleteGamma(d9 = 0.5 * d8, d10)) * Math.exp(d10 * 0.6931471806 + d3 + d9 - d11 * Math.log(d8))) * (1.0 + 0.5 * d4 * (d20 = (210.0 + (d7 = 0.5 * d4 - (d19 = d4 / d8) * d11) * (140.0 + d7 * (105.0 + d7 * (84.0 + d7 * (70.0 + 60.0 * d7))))) / 420.0) - d19 * d11 * (d20 - d19 * ((d18 = (420.0 + d7 * (735.0 + d7 * (966.0 + d7 * (1141.0 + 1278.0 * d7)))) / 2520.0) - d19 * ((d17 = (210.0 + d7 * (462.0 + d7 * (707.0 + 932.0 * d7))) / 2520.0) - d19 * ((d16 = (252.0 + d7 * (672.0 + 1182.0 * d7) + d11 * (294.0 + d7 * (889.0 + 1740.0 * d7))) / 5040.0) - d19 * ((d15 = (84.0 + 264.0 * d7 + d11 * (175.0 + 606.0 * d7)) / 2520.0) - d19 * (d14 = (120.0 + d11 * (346.0 + 127.0 * d11)) / 5040.0)))))))) && !(d8 < 0.0)) continue;
            return d13;
        } while (Math.abs(d6 / d8 - 1.0) > 5.0E-17 && n++ < 20);
        return d8;
    }

    public String toString() {
        return new String("Chi-squared distribution: df = " + this.df + ".");
    }

    public static double upperTailProb(double d, double d2) {
        return 1.0 - Gamma.incompleteGamma(0.5 * d, 0.5 * d2);
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double d = 50.0;
            ChiSquared chiSquared = new ChiSquared(d);
            int n = 100000;
            chiSquared = new ChiSquared(100.0);
            double[] dArray = new double[n];
            int n2 = 0;
            while (n2 < n) {
                dArray[n2] = chiSquared.random();
                ++n2;
            }
            KolmogorovTest kolmogorovTest = new KolmogorovTest(dArray, chiSquared, H1.NOT_EQUAL, false);
            System.out.println("n = " + n + " D = " + kolmogorovTest.getTestStatistic() + " SP = " + kolmogorovTest.getSP());
        }
    }
}

