/*
 * Decompiled with CFR 0.152.
 */
package jsc.distributions;

import jsc.descriptive.DoubleTally;
import jsc.distributions.AbstractDistribution;
import jsc.distributions.Distribution;
import jsc.goodnessfit.ChiSquaredFitTest;

public class Discrete
extends AbstractDistribution {
    protected double minValue;
    protected double maxValue;
    protected int valueCount;
    protected double[] values;
    protected double[] probs;

    public Discrete() {
        this.valueCount = 0;
        this.values = new double[0];
        this.probs = new double[0];
    }

    public Discrete(double[] dArray, double[] dArray2) {
        this(dArray, dArray2, false, 1.0E-6);
    }

    public Discrete(double[] dArray, double[] dArray2, boolean bl, double d) {
        this.setDistribution(dArray, dArray2, bl, d);
    }

    public Discrete(double[] dArray, double d) {
        this.setDistribution(dArray, d);
    }

    public Discrete(double[] dArray) {
        this.setDistribution(dArray, 0.0);
    }

    public Discrete(DoubleTally doubleTally) {
        this.setDistribution(doubleTally);
    }

    public double cdf(double d) {
        if (d < this.values[0] || d > this.values[this.valueCount - 1]) {
            throw new IllegalArgumentException("Invalid variate-value.");
        }
        double d2 = 0.0;
        int n = 0;
        while (n < this.valueCount) {
            if (!(this.values[n] <= d)) break;
            d2 += this.probs[n];
            ++n;
        }
        if (d2 < 0.0) {
            return 0.0;
        }
        if (d2 > 1.0) {
            return 1.0;
        }
        return d2;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getProb(int n) {
        return this.probs[n];
    }

    public double getValue(int n) {
        return this.values[n];
    }

    public int getValueCount() {
        return this.valueCount;
    }

    public double inverseCdf(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Invalid probability.");
        }
        double d2 = 0.0;
        if (d == 1.0) {
            return this.values[this.valueCount - 1];
        }
        int n = 0;
        while (n < this.valueCount) {
            if ((d2 += this.probs[n]) >= d) break;
            ++n;
        }
        return this.values[n];
    }

    public boolean isDiscrete() {
        return true;
    }

    public double mean() {
        double d = 0.0;
        int n = 0;
        while (n < this.valueCount) {
            d += this.values[n] * this.probs[n];
            ++n;
        }
        return d;
    }

    public double moment(int n) {
        return this.moment(n, 0.0);
    }

    public double moment(int n, double d) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid moment order.");
        }
        double d2 = 0.0;
        int n2 = 0;
        while (n2 < this.valueCount) {
            d2 += Math.pow(this.values[n2] - d, n) * this.probs[n2];
            ++n2;
        }
        return d2;
    }

    public double pdf(double d) {
        int n = 0;
        while (n < this.valueCount) {
            if (d == this.values[n]) {
                return this.probs[n];
            }
            ++n;
        }
        throw new IllegalArgumentException("Invalid variate-value.");
    }

    public double random() {
        double d = 0.0;
        double d2 = this.rand.nextDouble();
        int n = 0;
        while (n < this.valueCount) {
            if (d2 < (d += this.probs[n])) {
                return this.values[n];
            }
            ++n;
        }
        return this.values[this.valueCount - 1];
    }

    public void setDistribution(double[] dArray, double d) {
        this.setDistribution(new DoubleTally(dArray, d));
    }

    public void setDistribution(DoubleTally doubleTally) {
        this.valueCount = doubleTally.getValueCount();
        this.values = new double[this.valueCount];
        this.probs = new double[this.valueCount];
        int n = 0;
        while (n < this.valueCount) {
            this.values[n] = doubleTally.getValue(n);
            this.probs[n] = doubleTally.getProportion(n);
            ++n;
        }
        this.minValue = doubleTally.getMin();
        this.maxValue = doubleTally.getMax();
    }

    public void setDistribution(double[] dArray, double[] dArray2, boolean bl, double d) {
        this.valueCount = dArray.length;
        if (this.valueCount < 1 || this.valueCount != dArray2.length) {
            throw new IllegalArgumentException("Invalid distribution parameter.");
        }
        this.values = new double[this.valueCount];
        this.probs = new double[this.valueCount];
        System.arraycopy(dArray, 0, this.values, 0, this.valueCount);
        System.arraycopy(dArray2, 0, this.probs, 0, this.valueCount);
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = 0.0;
        int n = 0;
        while (n < this.valueCount) {
            if (!(this.values[n] > d2)) {
                throw new IllegalArgumentException("Invalid values value: " + this.values[n]);
            }
            d2 = this.values[n];
            if (this.probs[n] < 0.0 || this.probs[n] > 1.0) {
                throw new IllegalArgumentException("Invalid probability: " + this.probs[n]);
            }
            d3 += this.probs[n];
            ++n;
        }
        if (!bl && Math.abs(1.0 - d3) > d || d3 <= 0.0) {
            throw new IllegalArgumentException("Probabilities sum to " + d3);
        }
        if (bl && Math.abs(1.0 - d3) > d) {
            n = 0;
            while (n < this.valueCount) {
                int n2 = n++;
                this.probs[n2] = this.probs[n2] / d3;
            }
        }
        this.minValue = this.values[0];
        this.maxValue = this.values[this.valueCount - 1];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Discrete distribution\nx\tp");
        int n = 0;
        while (n < this.valueCount) {
            stringBuffer.append("\n" + this.values[n] + "\t" + this.probs[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public double upperTailProb(double d) {
        if (d < this.values[0] || d > this.values[this.valueCount - 1]) {
            throw new IllegalArgumentException("Invalid variate-value.");
        }
        double d2 = 0.0;
        int n = this.valueCount - 1;
        while (n >= 0) {
            if (!(this.values[n] >= d)) break;
            d2 += this.probs[n];
            --n;
        }
        return d2;
    }

    public double variance() {
        return this.moment(2, this.mean());
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double d = 10.0;
            double d2 = 0.5;
            double[] dArray = new double[]{0.1, 0.2, 0.2, 0.3, 0.1, 0.1};
            double[] dArray2 = new double[]{-2.0, -1.0, 0.0, 2.0, 5.0, 10.0};
            Discrete discrete = new Discrete(dArray2, dArray);
            System.out.println(discrete.toString());
            int n = 10000;
            double[] dArray3 = new double[n];
            int n2 = 0;
            while (n2 < n) {
                dArray3[n2] = discrete.random();
                ++n2;
            }
            ChiSquaredFitTest chiSquaredFitTest = new ChiSquaredFitTest(new DoubleTally(dArray3), (Distribution)discrete, 0);
            System.out.println("All E > 5 " + chiSquaredFitTest.poolBins());
            System.out.println("m = " + n + " Chi-squared = " + chiSquaredFitTest.getTestStatistic() + " SP = " + chiSquaredFitTest.getSP());
        }
    }
}

