/*
 * Decompiled with CFR 0.152.
 */
package jsc.distributions;

import jsc.distributions.AbstractDistribution;
import jsc.goodnessfit.KolmogorovTest;
import jsc.tests.H1;

public class Laplace
extends AbstractDistribution {
    private double mean;
    private double scale;

    public Laplace() {
        this(0.0, 1.0);
    }

    public Laplace(double d, double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("Invalid distribution parameter.");
        }
        this.mean = d;
        this.scale = d2;
    }

    public double cdf(double d) {
        if (d >= this.mean) {
            return 0.5 + 0.5 * (1.0 - Math.exp((this.mean - d) / this.scale));
        }
        return 0.5 - 0.5 * (1.0 - Math.exp((d - this.mean) / this.scale));
    }

    public double getScale() {
        return this.scale;
    }

    public double inverseCdf(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Invalid probability.");
        }
        if (d == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (d == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (d > 0.5) {
            return this.mean - this.scale * Math.log(2.0 - d - d);
        }
        return this.mean + this.scale * Math.log(d + d);
    }

    public double mean() {
        return this.mean;
    }

    public double pdf(double d) {
        return 0.5 * Math.exp(-Math.abs(d - this.mean) / this.scale) / this.scale;
    }

    public double random() {
        return this.mean - this.scale * Math.log((1.0 - this.rand.nextDouble()) / (1.0 - this.rand.nextDouble()));
    }

    public String toString() {
        return new String("Laplace distribution: mean = " + this.mean + ", scale = " + this.scale + ".");
    }

    public double variance() {
        return 2.0 * this.scale * this.scale;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double d = 5.0;
            double d2 = 10.0;
            Laplace laplace = new Laplace(d, d2);
            int n = 10000;
            laplace = new Laplace(5.0, 10.0);
            double[] dArray = new double[n];
            int n2 = 0;
            while (n2 < n) {
                dArray[n2] = laplace.random();
                ++n2;
            }
            KolmogorovTest kolmogorovTest = new KolmogorovTest(dArray, laplace, H1.NOT_EQUAL, false);
            System.out.println("n = " + n + " D = " + kolmogorovTest.getTestStatistic() + " SP = " + kolmogorovTest.getSP());
        }
    }
}

