/*
 * Decompiled with CFR 0.152.
 */
package jsc.distributions;

import jsc.distributions.AbstractDistribution;
import jsc.goodnessfit.KolmogorovTest;
import jsc.tests.H1;

public class Logistic
extends AbstractDistribution {
    private double mean;
    private double scale;

    public Logistic() {
        this(0.0, 1.0);
    }

    public Logistic(double d, double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("Invalid distribution parameter.");
        }
        this.mean = d;
        this.scale = d2;
    }

    public double cdf(double d) {
        if (d > this.mean) {
            return 1.0 / (1.0 + Math.exp(-(d - this.mean) / this.scale));
        }
        return 1.0 - 1.0 / (1.0 + Math.exp((d - this.mean) / this.scale));
    }

    public double getScale() {
        return this.scale;
    }

    public double inverseCdf(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Invalid probability.");
        }
        if (d == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (d == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.mean + this.scale * Math.log(d / (1.0 - d));
    }

    public double mean() {
        return this.mean;
    }

    public double pdf(double d) {
        double d2 = 1.0 + (d > this.mean ? Math.exp(-(d - this.mean) / this.scale) : Math.exp((d - this.mean) / this.scale));
        return (d2 - 1.0) / (this.scale * d2 * d2);
    }

    public double random() {
        double d;
        while ((d = this.rand.nextDouble()) == 0.0) {
        }
        return this.mean + this.scale * Math.log(d / (1.0 - d));
    }

    public String toString() {
        return new String("Laplace distribution: mean = " + this.mean + ", scale = " + this.scale + ".");
    }

    public double variance() {
        return Math.PI * Math.PI * this.scale * this.scale / 3.0;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double d = 2.0;
            double d2 = 3.0;
            Logistic logistic = new Logistic(d, d2);
            int n = 10000;
            logistic = new Logistic(2.0, 3.0);
            double[] dArray = new double[n];
            int n2 = 0;
            while (n2 < n) {
                dArray[n2] = logistic.random();
                ++n2;
            }
            KolmogorovTest kolmogorovTest = new KolmogorovTest(dArray, logistic, H1.NOT_EQUAL, false);
            System.out.println("n = " + n + " D = " + kolmogorovTest.getTestStatistic() + " SP = " + kolmogorovTest.getSP());
        }
    }
}

