/*
 * Decompiled with CFR 0.152.
 */
package jsc.distributions;

import jsc.distributions.AbstractDistribution;
import jsc.goodnessfit.KolmogorovTest;
import jsc.tests.H1;

public class Uniform
extends AbstractDistribution {
    private double a;
    private double b;

    public Uniform() {
        this(0.0, 1.0);
    }

    public Uniform(double d, double d2) {
        this.setInterval(d, d2);
    }

    public double cdf(double d) {
        if (d < this.a || d > this.b) {
            throw new IllegalArgumentException("Invalid variate-value.");
        }
        return (d - this.a) / (this.b - this.a);
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public double inverseCdf(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Invalid probability.");
        }
        return this.a + (this.b - this.a) * d;
    }

    public double mean() {
        return 0.5 * (this.a + this.b);
    }

    public double pdf(double d) {
        if (d < this.a || d > this.b) {
            throw new IllegalArgumentException("Invalid variate-value.");
        }
        return 1.0 / (this.b - this.a);
    }

    public double random() {
        return this.a + (this.b - this.a) * this.rand.nextDouble();
    }

    public void setInterval(double d, double d2) {
        if (d2 <= d) {
            throw new IllegalArgumentException("Invalid distribution parameter.");
        }
        this.a = d;
        this.b = d2;
    }

    public String toString() {
        return new String("Uniform distribution: a = " + this.a + ", b = " + this.b + ".");
    }

    public double variance() {
        return (this.b - this.a) * (this.b - this.a) / 12.0;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            int n = 10000;
            Uniform uniform = new Uniform(10.0, 20.0);
            double[] dArray = new double[n];
            int n2 = 0;
            while (n2 < n) {
                dArray[n2] = uniform.random();
                ++n2;
            }
            KolmogorovTest kolmogorovTest = new KolmogorovTest(dArray, uniform, H1.NOT_EQUAL, true);
            System.out.println("m = " + n + " D = " + kolmogorovTest.getTestStatistic() + " SP = " + kolmogorovTest.getSP());
        }
    }
}

