/*
 * Decompiled with CFR 0.152.
 */
package jsc.goodnessfit;

import jsc.distributions.Distribution;
import jsc.distributions.Normal;
import jsc.goodnessfit.KolmogorovTypeTest;
import jsc.tests.H1;
import jsc.util.Maths;

public class KolmogorovTest
extends KolmogorovTypeTest {
    static final int SMALL_SAMPLE_SIZE = 100;
    double SP;

    public KolmogorovTest(double[] dArray, Distribution distribution, H1 h1, boolean bl) {
        super(dArray, distribution, h1);
        this.SP = bl ? KolmogorovTest.approxUpperTailProb(this.n, this.testStatistic) : KolmogorovTest.exactUpperTailProb(this.n, this.testStatistic);
        if (h1 == H1.NOT_EQUAL) {
            if (this.SP > 0.5) {
                this.SP = 1.0 - this.SP;
            }
            this.SP = 2.0 * this.SP;
        }
    }

    public KolmogorovTest(double[] dArray, Distribution distribution, H1 h1) {
        this(dArray, distribution, h1, dArray.length <= 100);
    }

    public KolmogorovTest(double[] dArray, Distribution distribution) {
        this(dArray, distribution, H1.NOT_EQUAL, dArray.length <= 100);
    }

    public static double approxUpperTailProb(int n, double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Invalid D value.");
        }
        if (n < 1) {
            throw new IllegalArgumentException("n < 1.");
        }
        if (n == 1) {
            return 1.0 - d;
        }
        double d2 = Math.sqrt(n);
        double d3 = d * (d2 + 0.12 + 0.11 / d2);
        return Math.exp(-2.0 * d3 * d3);
    }

    public static double exactUpperTailProb(int n, double d) {
        double d2 = 0.0;
        double d3 = n;
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Invalid D value.");
        }
        if (n < 1) {
            throw new IllegalArgumentException("n < 1.");
        }
        if (n == 1 || d == 0.0 || d == 1.0) {
            return 1.0 - d;
        }
        double d4 = Maths.logFactorial(n);
        int n2 = 0;
        while ((double)n2 < (double)n * (1.0 - d) && n2 < n) {
            double d5 = (double)n2 / d3;
            d2 += Math.exp(d4 - Maths.logFactorial(n2) - Maths.logFactorial(n - n2) + (double)(n - n2) * Math.log(1.0 - d - d5) + (double)(n2 - 1) * Math.log(d + d5));
            ++n2;
        }
        return d * d2;
    }

    public double getSP() {
        return this.SP;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double[] dArray = new double[]{72.2, 64.0, 53.4, 76.8, 86.3, 58.1, 63.2, 73.1, 78.0, 44.3, 85.1, 66.6, 80.4, 76.0, 68.8, 76.8, 58.9, 58.1, 74.9, 72.2, 73.1, 39.3, 52.8, 54.2, 65.3, 74.0, 63.2, 64.7, 68.8, 85.1, 62.2, 76.0, 70.5, 48.9, 78.0, 66.6, 58.1, 32.5, 63.2, 64.0, 68.8, 65.3, 71.9, 72.2, 63.2, 72.2, 70.5, 80.4, 45.4, 59.6};
            KolmogorovTest kolmogorovTest = new KolmogorovTest(dArray, new Normal(62.0, 11.0));
            System.out.println("D+ = " + kolmogorovTest.getPositiveD() + " D- = " + kolmogorovTest.getNegativeD() + " D = " + kolmogorovTest.getD() + " Test D = " + kolmogorovTest.getTestStatistic() + " SP = " + kolmogorovTest.getSP());
        }
    }
}

