/*
 * Decompiled with CFR 0.152.
 */
package jsc.independentsamples;

import jsc.combinatorics.MultiSetPermutation;
import jsc.combinatorics.MultiSetPermutations;
import jsc.datastructures.GroupedData;
import jsc.distributions.Beta;
import jsc.distributions.ChiSquared;
import jsc.distributions.Gamma;
import jsc.tests.SignificanceTest;
import jsc.util.Maths;
import jsc.util.Rank;

public class KruskalWallisTest
implements SignificanceTest {
    public static final int MAX_PERMUTATION_COUNT = 17153136;
    final int k;
    final int N;
    final double H;
    final int[] ns;
    final double[] R;
    final double[] z;
    final double SP;
    final double[] originalSample;
    private final double Rbar;
    private final double c;

    public KruskalWallisTest(GroupedData groupedData, double d, boolean bl) {
        double d2 = 0.0;
        this.k = groupedData.getGroupCount();
        if (this.k < 2) {
            throw new IllegalArgumentException("Less than two samples.");
        }
        this.N = groupedData.getN();
        this.ns = new int[this.k];
        this.R = new double[this.k];
        this.z = new double[this.k];
        double[] dArray = groupedData.getData();
        Rank rank = new Rank(dArray, d);
        this.originalSample = rank.getRanks();
        int n = rank.getCorrectionFactor1();
        double d3 = this.N;
        double d4 = n > 0 ? 1.0 - (double)n / (d3 * (d3 * d3 - 1.0)) : 1.0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.k) {
            this.R[n3] = 0.0;
            this.ns[n3] = groupedData.getSize(n3);
            int n4 = 0;
            while (n4 < this.ns[n3]) {
                int n5 = n3;
                this.R[n5] = this.R[n5] + rank.getRank(n2++);
                ++n4;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < this.k) {
            int n6 = n3;
            this.R[n6] = this.R[n6] / (double)this.ns[n3];
            ++n3;
        }
        this.Rbar = 0.5 * (d3 + 1.0);
        this.c = 12.0 / (d3 * (d3 + 1.0));
        n3 = 0;
        while (n3 < this.k) {
            double d5 = this.R[n3] - this.Rbar;
            this.z[n3] = d5 / Math.sqrt((d3 + 1.0) / 12.0 * (d3 / (double)this.ns[n3] - 1.0));
            d2 += (double)this.ns[n3] * d5 * d5;
            ++n3;
        }
        if (d4 <= 0.0) {
            throw new IllegalArgumentException("Cannot calculate Kruskal-Wallis statistic.");
        }
        this.H = this.c * d2 / d4;
        double d6 = Maths.multinomialCoefficient(this.ns);
        this.SP = bl ? KruskalWallisTest.gammaApproxSP(this.ns, this.H) : (d6 <= 1.7153136E7 ? this.exactSP() : KruskalWallisTest.gammaApproxSP(this.ns, this.H));
    }

    public KruskalWallisTest(GroupedData groupedData) {
        this(groupedData, 0.0, false);
    }

    public static double betaApproxSP(int[] nArray, double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Negative H.");
        }
        int n = nArray.length;
        if (n < 2) {
            throw new IllegalArgumentException("Less than 2 samples.");
        }
        int n2 = 0;
        double d2 = n - 1;
        double d3 = 0.0;
        double d4 = 0.0;
        int n3 = 0;
        while (n3 < n) {
            if (nArray[n3] < 1) {
                throw new IllegalArgumentException("Less than one data value in a sample.");
            }
            d3 += 1.0 / (double)nArray[n3];
            d4 += (double)(nArray[n3] * nArray[n3] * nArray[n3]);
            n2 += nArray[n3];
            ++n3;
        }
        double d5 = 2.0 * d2 - 2.0 * (3.0 * (double)n * (double)n - 6.0 * (double)n + (double)n2 * (2.0 * (double)n * (double)n - 6.0 * (double)n + 1.0)) / (5.0 * (double)n2 * ((double)n2 + 1.0)) - 1.2 * d3;
        double d6 = ((double)(n2 * n2 * n2) - d4) / ((double)n2 * ((double)n2 + 1.0));
        if (d5 <= 0.0 || d6 <= 0.0) {
            throw new IllegalArgumentException("Invalid sample sizes.");
        }
        double d7 = d2 * (d2 * (d6 - d2) - d5) / (0.5 * d6 * d5);
        double d8 = (d6 - d2) / d2 * d7;
        double d9 = 0.5 * d7;
        double d10 = 0.5 * d8;
        if (d9 <= 0.0 || d10 <= 0.0) {
            throw new IllegalArgumentException("Invalid sample sizes.");
        }
        double d11 = d / d6;
        if (d11 >= 1.0) {
            return 0.0;
        }
        return 1.0 - Beta.incompleteBeta(d11, d9, d10, Maths.lnB(d9, d10));
    }

    public static double chiSquaredApproxSP(int n, double d) {
        if (n < 2) {
            throw new IllegalArgumentException("Less than two samples.");
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("Negative H.");
        }
        ChiSquared chiSquared = new ChiSquared(n - 1);
        return 1.0 - chiSquared.cdf(d);
    }

    public double exactSP() {
        MultiSetPermutations multiSetPermutations = new MultiSetPermutations(this.ns);
        double d = Maths.multinomialCoefficient(this.ns);
        double[] dArray = new double[this.N];
        int[] nArray = new int[this.k];
        double[] dArray2 = new double[this.k];
        long l = 0L;
        while (multiSetPermutations.hasNext()) {
            double d2 = 0.0;
            MultiSetPermutation multiSetPermutation = multiSetPermutations.nextPermutation();
            int[] nArray2 = multiSetPermutation.toIntArray();
            nArray[0] = 0;
            int n = 1;
            while (n < this.k) {
                nArray[n] = nArray[n - 1] + this.ns[n - 1];
                ++n;
            }
            n = 0;
            while (n < this.N) {
                int n2 = nArray2[n] - 1;
                dArray[nArray[n2]] = this.originalSample[n];
                int n3 = n2;
                nArray[n3] = nArray[n3] + 1;
                ++n;
            }
            int n4 = 0;
            n = 0;
            while (n < this.k) {
                dArray2[n] = 0.0;
                int n5 = 0;
                while (n5 < this.ns[n]) {
                    int n6 = n;
                    dArray2[n6] = dArray2[n6] + dArray[n4++];
                    ++n5;
                }
                ++n;
            }
            n = 0;
            while (n < this.k) {
                int n7 = n;
                dArray2[n7] = dArray2[n7] / (double)this.ns[n];
                ++n;
            }
            n = 0;
            while (n < this.k) {
                double d3 = dArray2[n] - this.Rbar;
                d2 += (double)this.ns[n] * d3 * d3;
                ++n;
            }
            double d4 = this.c * d2;
            if (!(d4 >= this.H)) continue;
            ++l;
        }
        dArray = null;
        nArray = null;
        dArray2 = null;
        return (double)l / d;
    }

    public static double gammaApproxSP(int[] nArray, double d) {
        int n = 0;
        int n2 = nArray.length;
        if (n2 < 2) {
            throw new IllegalArgumentException("Less than 2 samples.");
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("Negative H.");
        }
        double d2 = n2 - 1;
        double d3 = 0.0;
        int n3 = 0;
        while (n3 < n2) {
            n += nArray[n3];
            if (nArray[n3] < 1) {
                throw new IllegalArgumentException("Less than one data value in a sample.");
            }
            d3 += 1.0 / (double)nArray[n3];
            ++n3;
        }
        double d4 = 2.0 * d2 - 2.0 * (3.0 * (double)n2 * (double)n2 - 6.0 * (double)n2 + (double)n * (2.0 * (double)n2 * (double)n2 - 6.0 * (double)n2 + 1.0)) / (5.0 * (double)n * ((double)n + 1.0)) - 1.2 * d3;
        if (d4 <= 0.0) {
            throw new IllegalArgumentException("Invalid sample sizes.");
        }
        return 1.0 - Gamma.incompleteGamma(d * d2 / d4, d2 * d2 / d4);
    }

    public double getMeanRank(int n) {
        return this.R[n];
    }

    public double getPermutationCount() {
        return Maths.multinomialCoefficient(this.ns);
    }

    public int getN() {
        return this.N;
    }

    public int getSize(int n) {
        return this.ns[n];
    }

    public int getK() {
        return this.k;
    }

    public double getSP() {
        return this.SP;
    }

    public double getStatistic() {
        return this.H;
    }

    public double getTestStatistic() {
        return this.H;
    }

    public double getZ(int n) {
        return this.z[n];
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            String[] stringArray2 = new String[]{"1", "1", "3", "1", "1", "3", "2", "2", "2", "1", "3", "2", "3", "2", "3", "3"};
            double[] dArray = new double[]{15.1, 13.0, 16.2, 14.9, 13.2, 13.8, 13.1, 13.0, 12.9, 11.9, 17.0, 12.8, 14.7, 12.0, 15.0, 16.6};
            GroupedData groupedData = new GroupedData(dArray, stringArray2);
            int n = groupedData.getGroupCount();
            int[] nArray = groupedData.getSizes();
            KruskalWallisTest kruskalWallisTest = new KruskalWallisTest(groupedData, 0.0, true);
            int n2 = 0;
            while (n2 < n) {
                System.out.println(groupedData.getLabel(n2) + "\tn = " + groupedData.getSize(n2) + "\tAve.rank = " + kruskalWallisTest.getMeanRank(n2) + "\tz = " + kruskalWallisTest.getZ(n2));
                ++n2;
            }
            double d = kruskalWallisTest.getTestStatistic();
            System.out.println("H = " + d + " " + (long)kruskalWallisTest.getPermutationCount() + " permutations");
            System.out.println("                   SP = " + kruskalWallisTest.getSP());
            System.out.println("       Beta approx SP = " + KruskalWallisTest.betaApproxSP(nArray, d));
            System.out.println("      Gamma approx SP = " + KruskalWallisTest.gammaApproxSP(nArray, d));
            System.out.println("Chi-squared approx SP = " + KruskalWallisTest.chiSquaredApproxSP(n, d));
            long l = System.currentTimeMillis();
            double d2 = kruskalWallisTest.exactSP();
            long l2 = System.currentTimeMillis();
            System.out.println("       Exact(test) SP = " + d2);
            System.out.println("Time = " + (l2 - l) / 1000L + " secs");
        }
    }
}

