/*
 * Decompiled with CFR 0.152.
 */
package jsc.independentsamples;

import jsc.combinatorics.Enumerator;
import jsc.combinatorics.MultiSetPermutations;
import jsc.combinatorics.Selection;
import jsc.distributions.MannWhitneyU;
import jsc.distributions.Normal;
import jsc.distributions.Tail;
import jsc.statistics.PermutableStatistic;
import jsc.tests.H1;
import jsc.tests.PermutationTest;
import jsc.tests.SignificanceTest;
import jsc.util.Arrays;
import jsc.util.Maths;
import jsc.util.Rank;

public class MannWhitneyTest
implements PermutableStatistic,
SignificanceTest {
    static final int SMALL_SAMPLE_SIZE = 20;
    final int N;
    final int nAB;
    final H1 alternative;
    final int nA;
    final int nB;
    double RA;
    double RB;
    final Rank ranks;
    final double U;
    final double SP;
    final double tolerance;
    private final double[] originalRanks;
    private double[] permutedRanksA;

    public MannWhitneyTest(double[] dArray, double[] dArray2, H1 h1, double d, boolean bl) {
        double d2;
        this.alternative = h1;
        this.tolerance = d;
        this.nA = dArray.length;
        this.nB = dArray2.length;
        if (this.nA < 2 || this.nB < 2) {
            throw new IllegalArgumentException("Less than two data values.");
        }
        this.nAB = this.nA * this.nB;
        double[] dArray3 = new double[this.nA];
        double[] dArray4 = new double[this.nB];
        this.permutedRanksA = new double[this.nA];
        this.N = this.nA + this.nB;
        this.ranks = new Rank(Arrays.append(dArray2, dArray), d);
        this.originalRanks = this.ranks.getRanks();
        this.RA = 0.0;
        int n = 0;
        while (n < this.nA) {
            d2 = this.ranks.getRank(n);
            this.RA += d2;
            dArray3[n] = d2;
            ++n;
        }
        this.RB = 0.0;
        int n2 = 0;
        n = this.nA;
        while (n < this.N) {
            d2 = this.ranks.getRank(n);
            this.RB += d2;
            dArray4[n2] = d2;
            ++n2;
            ++n;
        }
        double d3 = this.RA - 0.5 * (double)this.nA * ((double)this.nA + 1.0);
        double d4 = (double)(this.nA * this.nB) - d3;
        this.U = h1 == H1.NOT_EQUAL ? Math.min(d3, d4) : (h1 == H1.LESS_THAN ? d3 : d4);
        this.SP = bl ? this.approxSP() : this.exactSP();
    }

    public MannWhitneyTest(double[] dArray, double[] dArray2, H1 h1) {
        this(dArray, dArray2, h1, 0.0, dArray.length > 20 || dArray2.length > 20);
    }

    public MannWhitneyTest(double[] dArray, double[] dArray2) {
        this(dArray, dArray2, H1.NOT_EQUAL, 0.0, dArray.length > 20 || dArray2.length > 20);
    }

    public double approxSP() {
        double d = this.getZ();
        if (this.alternative == H1.NOT_EQUAL) {
            return 2.0 * Normal.standardTailProb(d, d > 0.0);
        }
        return Normal.standardTailProb(d, false);
    }

    public double exactSP() {
        if (this.ranks.hasTies()) {
            PermutationTest permutationTest = new PermutationTest(this, Tail.LOWER, this.nA * this.nB > 169, 10000, 1.0E-5);
            return permutationTest.getSP();
        }
        MannWhitneyU mannWhitneyU = new MannWhitneyU(this.nA, this.nB);
        double d = mannWhitneyU.cdf(Math.ceil(this.U));
        if (this.alternative == H1.NOT_EQUAL) {
            return d <= 0.5 ? 2.0 * d : 2.0 * (1.0 - d);
        }
        return d;
    }

    public int getCorrectionFactor() {
        return this.ranks.getCorrectionFactor1();
    }

    public Enumerator getEnumerator() {
        int[] nArray = new int[]{this.nA, this.nB};
        return new MultiSetPermutations(nArray);
    }

    public int getN() {
        return this.N;
    }

    public Rank getRanks() {
        return this.ranks;
    }

    public double getRankSumA() {
        return this.RA;
    }

    public double getRankSumB() {
        return this.RB;
    }

    public double getSP() {
        return this.SP;
    }

    public double getStatistic() {
        return this.U;
    }

    public double getTestStatistic() {
        return this.U;
    }

    public double getZ() {
        double d;
        int n = this.ranks.getCorrectionFactor1();
        double d2 = this.N;
        double d3 = (d2 * d2 * d2 - d2 - (double)n) / 12.0;
        double d4 = (d - ((d = this.U - 0.5 * (double)this.nAB) < 0.0 ? -0.5 : 0.5)) / Math.sqrt((double)this.nAB / (d2 * (d2 - 1.0)) * d3);
        return d4;
    }

    public double permuteStatistic(Selection selection) {
        int n = 0;
        int[] nArray = selection.toIntArray();
        int n2 = 0;
        while (n2 < this.N) {
            if (nArray[n2] == 1) {
                this.permutedRanksA[n] = this.originalRanks[n2];
                ++n;
            }
            ++n2;
        }
        double d = this.resampleStatistic(this.permutedRanksA);
        return d;
    }

    public double resampleStatistic(double[] dArray) {
        double d = 0.0;
        int n = 0;
        while (n < this.nA) {
            d += dArray[n];
            ++n;
        }
        double d2 = d - 0.5 * (double)this.nA * ((double)this.nA + 1.0);
        double d3 = (double)(this.nA * this.nB) - d2;
        double d4 = this.alternative == H1.NOT_EQUAL ? Math.min(d2, d3) : (this.alternative == H1.LESS_THAN ? d2 : d3);
        return d4;
    }

    public int sizeA() {
        return this.nA;
    }

    public int sizeB() {
        return this.nB;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double[] dArray = new double[]{90.0, 72.0, 61.0, 66.0, 81.0, 69.0, 59.0, 70.0};
            double[] dArray2 = new double[]{62.0, 85.0, 78.0, 66.0, 80.0, 91.0, 69.0, 77.0, 84.0};
            double[] dArray3 = new double[]{13.0, 12.0, 12.0, 10.0, 10.0, 10.0, 10.0, 9.0, 8.0, 8.0, 7.0, 7.0, 7.0, 7.0, 7.0, 6.0};
            double[] dArray4 = new double[]{17.0, 16.0, 15.0, 15.0, 15.0, 14.0, 14.0, 14.0, 13.0, 13.0, 13.0, 12.0, 12.0, 12.0, 12.0, 11.0, 11.0, 10.0, 10.0, 10.0, 8.0, 8.0, 6.0};
            double[] dArray5 = new double[]{78.0, 64.0, 75.0, 45.0, 82.0};
            double[] dArray6 = new double[]{110.0, 70.0, 53.0, 51.0};
            double[] dArray7 = new double[]{3.0, 7.0, 15.0, 10.0, 4.0, 6.0, 4.0, 7.0};
            double[] dArray8 = new double[]{19.0, 11.0, 36.0, 8.0, 25.0, 23.0, 38.0, 14.0, 17.0, 41.0, 25.0, 21.0};
            double[] dArray9 = new double[]{3.0, 7.0, 15.0, 10.0, 4.0, 6.0, 4.0, 7.0};
            double[] dArray10 = new double[]{19.0, 11.0, 36.0, 7.0, 25.0, 23.0, 38.0, 15.0, 17.0, 41.0, 25.0, 21.0};
            double[] dArray11 = new double[]{13.0, 6.0, 12.0, 7.0, 12.0, 7.0, 10.0, 7.0, 10.0, 7.0, 16.0, 7.0, 10.0, 8.0, 9.0, 8.0};
            double[] dArray12 = new double[]{17.0, 6.0, 10.0, 8.0, 15.0, 8.0, 15.0, 10.0, 15.0, 10.0, 14.0, 10.0, 14.0, 11.0, 14.0, 11.0, 13.0, 12.0, 13.0, 12.0, 13.0, 12.0, 12.0};
            String[] stringArray2 = new String[]{"Minitab Ref. Manual, p.18-9", "Siegel,S.(1956), pp.121-125", "Siegel,S.(1956), pp.118-120.", "Neave & Worthington (1988), pp.109-113.", "Neave & Worthington (1988), p.116.", "NAG"};
            double[][] dArrayArray = new double[][]{dArray, dArray3, dArray5, dArray7, dArray9, dArray11};
            double[][] dArrayArray2 = new double[][]{dArray2, dArray4, dArray6, dArray8, dArray10, dArray12};
            boolean bl = false;
            int n = 0;
            while (n < dArrayArray.length) {
                System.out.println(stringArray2[n]);
                MannWhitneyTest mannWhitneyTest = new MannWhitneyTest(dArrayArray[n], dArrayArray2[n], H1.NOT_EQUAL, 0.0, bl);
                System.out.println("H1:A <> B: U=" + mannWhitneyTest.getTestStatistic() + " z=" + Maths.round(mannWhitneyTest.getZ(), 4) + " SP=" + Maths.round(mannWhitneyTest.getSP(), 4) + " Ra=" + mannWhitneyTest.getRankSumA() + " Rb=" + mannWhitneyTest.getRankSumB() + " t=" + mannWhitneyTest.getCorrectionFactor());
                MannWhitneyTest mannWhitneyTest2 = new MannWhitneyTest(dArrayArray[n], dArrayArray2[n], H1.LESS_THAN, 0.0, bl);
                System.out.println("H1:A < B: U=" + mannWhitneyTest2.getTestStatistic() + " z=" + Maths.round(mannWhitneyTest.getZ(), 4) + " SP=" + Maths.round(mannWhitneyTest2.getSP(), 4) + " Ra=" + mannWhitneyTest2.getRankSumA() + " Rb=" + mannWhitneyTest2.getRankSumB() + " t=" + mannWhitneyTest2.getCorrectionFactor());
                MannWhitneyTest mannWhitneyTest3 = new MannWhitneyTest(dArrayArray[n], dArrayArray2[n], H1.GREATER_THAN, 0.0, bl);
                System.out.println("H1:A > B: U=" + mannWhitneyTest3.getTestStatistic() + " z=" + Maths.round(mannWhitneyTest.getZ(), 4) + " SP=" + Maths.round(mannWhitneyTest3.getSP(), 4) + " Ra=" + mannWhitneyTest3.getRankSumA() + " Rb=" + mannWhitneyTest3.getRankSumB() + " t=" + mannWhitneyTest3.getCorrectionFactor());
                ++n;
            }
        }
    }
}

