/*
 * Decompiled with CFR 0.152.
 */
package jsc.mathfunction;

public class CodeList
implements Cloneable {
    private int nMax;
    int codeListSize = 0;
    CodeListLine[] codeList;

    public CodeList(int n) {
        this.nMax = n;
        this.codeList = new CodeListLine[this.nMax];
        int n2 = 0;
        while (n2 < this.nMax) {
            this.codeList[n2] = new CodeListLine();
            ++n2;
        }
    }

    public Object clone() {
        return this.copy();
    }

    public CodeList copy() {
        CodeList codeList = new CodeList(this.nMax);
        codeList.codeListSize = this.codeListSize;
        int n = 0;
        while (n < this.nMax) {
            codeList.codeList[n].f = this.codeList[n].f;
            codeList.codeList[n].op = this.codeList[n].op;
            codeList.codeList[n].type = this.codeList[n].type;
            codeList.codeList[n].left = this.codeList[n].left;
            codeList.codeList[n].right = this.codeList[n].right;
            ++n;
        }
        return codeList;
    }

    public int decrementSize() {
        return --this.codeListSize;
    }

    public boolean equals(CodeList codeList) {
        if (codeList.size() != this.codeListSize) {
            return false;
        }
        int n = 1;
        while (n <= this.codeListSize) {
            if (codeList.codeList[n].f != this.codeList[n].f) {
                return false;
            }
            if (codeList.codeList[n].op != this.codeList[n].op) {
                return false;
            }
            if (codeList.codeList[n].type != this.codeList[n].type) {
                return false;
            }
            if (codeList.codeList[n].left != this.codeList[n].left) {
                return false;
            }
            if (codeList.codeList[n].right != this.codeList[n].right) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int getCode(int n) {
        return this.codeList[n].op;
    }

    public static int getLabelCode(int n) {
        return -n;
    }

    public int getLabelLine(int n) {
        return n < 0 ? -n : n;
    }

    public int getLeft(int n) {
        return this.codeList[n].left;
    }

    public int getLeftCode(int n) {
        return this.codeList[this.getLabelLine((int)this.codeList[n].left)].op;
    }

    public int getLeftType(int n) {
        return this.codeList[this.getLabelLine((int)this.codeList[n].left)].type;
    }

    public double getLeftValue(int n) {
        return this.codeList[this.getLabelLine((int)this.codeList[n].left)].f;
    }

    public int getRight(int n) {
        return this.codeList[n].right;
    }

    public int getRightCode(int n) {
        return this.codeList[this.getLabelLine((int)this.codeList[n].right)].op;
    }

    public int getRightType(int n) {
        return this.codeList[this.getLabelLine((int)this.codeList[n].right)].type;
    }

    public double getRightValue(int n) {
        return this.codeList[this.getLabelLine((int)this.codeList[n].right)].f;
    }

    public int getType(int n) {
        return this.codeList[n].type;
    }

    public double getValue() {
        return this.codeList[this.codeListSize].f;
    }

    public double getValue(int n) {
        return this.codeList[n].f;
    }

    public int incrementSize() {
        return ++this.codeListSize;
    }

    public void setCode(int n, int n2) {
        this.codeList[n2].op = n;
    }

    public void setLeft(int n, int n2) {
        this.codeList[n2].left = n;
    }

    public void setRight(int n, int n2) {
        this.codeList[n2].right = n;
    }

    public void setType(int n, int n2) {
        this.codeList[n2].type = n;
    }

    public void setSize(int n) {
        this.codeListSize = n;
    }

    public void setValue(double d, int n) {
        this.codeList[n].f = d;
    }

    public int size() {
        return this.codeListSize;
    }

    private class CodeListLine {
        double f;
        int op;
        int type;
        int left;
        int right;

        private CodeListLine() {
        }
    }
}

