/*
 * Decompiled with CFR 0.152.
 */
package jsc.mathfunction;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import jsc.mathfunction.AbstractMathFunction;
import jsc.mathfunction.MathFunctionException;
import jsc.mathfunction.MathFunctionVariables;
import jsc.mathfunction.StandardMathFunction;
import jsc.util.Maths;

public class StatisticalMathFunction
extends AbstractMathFunction {
    static final String IMP_ERROR = "Implementation error";
    static final String TOO_BIG = "Result of a multiplication is too large";
    static final String DIV_ZERO = "Attempted division by zero";
    public static final int PLUS = 190;
    public static final int MINUS = 191;
    public static final int ABS = 102;
    public static final int EXP = 103;
    public static final int INT = 104;
    public static final int NINT = 105;
    public static final int LOG = 106;
    public static final int SQRT = 108;
    public static final int SIN = 109;
    public static final int COS = 110;
    public static final int TAN = 111;
    public static final int ATAN = 112;
    public static final int ASIN = 113;
    public static final int ACOS = 114;
    public static final int SINH = 115;
    public static final int COSH = 116;
    public static final int TANH = 117;
    public static final int SIGN = 118;
    public static final int DEG = 119;
    public static final int RAD = 120;
    public static final int GAMMA = 130;
    public static final int LOG_GAMMA = 131;
    public static final int NOT = 132;
    public static final int ADD = 290;
    public static final int SUBTRACT = 291;
    public static final int MULTIPLY = 202;
    public static final int DIVIDE = 203;
    public static final int POWER = 204;
    public static final int MODULUS = 205;
    public static final int PI_CONST = 300;
    public static final int E_CONST = 301;
    public static final int LT = 210;
    public static final int LE = 211;
    public static final int EQ = 212;
    public static final int GE = 213;
    public static final int GT = 214;
    public static final int NE = 215;
    public static final int AND = 216;
    public static final int OR = 217;
    Token[] defaultTab = new Token[]{new Token("+", 190, 8), new Token("+", 290, 6), new Token("-", 191, 8), new Token("-", 291, 6), new Token("*", 202, 7), new Token("/", 203, 7), new Token("%", 205, 7), new Token("^", 204, 9), new Token("<>", 215, 4), new Token("~=", 215, 4), new Token("~", 132, 8), new Token("<=", 211, 5), new Token(">=", 213, 5), new Token("<", 210, 5), new Token(">", 214, 5), new Token("=", 212, 4), new Token("&", 216, 3), new Token("|", 217, 2), new Token("LGAM", 131, 10), new Token("GAM", 130, 10), new Token("ABS", 102, 10), new Token("SIGN", 118, 10), new Token("EXP", 103, 10), new Token("NINT", 105, 10), new Token("INT", 104, 10), new Token("LOG", 106, 10), new Token("SQRT", 108, 10), new Token("ATAN", 112, 10), new Token("ASIN", 113, 10), new Token("ACOS", 114, 10), new Token("SINH", 115, 10), new Token("COSH", 116, 10), new Token("TANH", 117, 10), new Token("SIN", 109, 10), new Token("COS", 110, 10), new Token("TAN", 111, 10), new Token("DEG", 119, 10), new Token("RAD", 120, 10), new Token("NOT", 132, 8), new Token("AND", 216, 3), new Token("OR", 217, 2), new Token("PI", 300, 0), new Token("E", 301, 0)};

    public StatisticalMathFunction(MathFunctionVariables mathFunctionVariables) {
        super(mathFunctionVariables);
    }

    public StatisticalMathFunction() {
    }

    public int getCode(int n) {
        return this.defaultTab[n].code;
    }

    public double getConstant(int n) {
        return n == 300 ? Math.PI : Math.E;
    }

    public int getImplicitCode() {
        return 202;
    }

    public int getNumberOfTokens() {
        return this.defaultTab.length;
    }

    public int getPrecedence(int n) {
        return this.defaultTab[n].prec;
    }

    public String getToken(int n) {
        return this.defaultTab[n].string;
    }

    public int getType(int n) {
        return n / 100;
    }

    public boolean isAmbiguous(int n) {
        return n >= 190 && n <= 199 || n >= 290 && n <= 299;
    }

    public double unaryOperation(int n, double d) throws MathFunctionException {
        double d2 = 0.0;
        switch (n) {
            case 191: {
                return -d;
            }
            case 102: {
                return Math.abs(d);
            }
            case 103: {
                d2 = Math.exp(d);
                break;
            }
            case 106: {
                d2 = Math.log(d);
                break;
            }
            case 108: {
                d2 = Math.sqrt(d);
                break;
            }
            case 109: {
                return Math.sin(d);
            }
            case 110: {
                return Math.cos(d);
            }
            case 111: {
                d2 = Math.tan(d);
                break;
            }
            case 112: {
                d2 = Math.atan(d);
                break;
            }
            case 113: {
                d2 = Math.asin(d);
                break;
            }
            case 114: {
                d2 = Math.acos(d);
                break;
            }
            case 115: {
                d2 = 0.5 * (Math.exp(d) - Math.exp(-d));
                break;
            }
            case 116: {
                d2 = 0.5 * (Math.exp(d) + Math.exp(-d));
                break;
            }
            case 117: {
                double d3 = Math.exp(-d - d);
                d2 = (1.0 - d3) / (1.0 + d3);
                break;
            }
            case 105: {
                return Math.rint(d);
            }
            case 104: {
                return Maths.truncate(d);
            }
            case 118: {
                return Maths.sign(d);
            }
            case 190: {
                return d;
            }
            case 119: {
                return Math.toDegrees(d);
            }
            case 120: {
                return Math.toRadians(d);
            }
            case 132: {
                return d == 0.0 ? 1.0 : 0.0;
            }
            case 130: {
                try {
                    d2 = Maths.logGamma(d);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    d2 = Double.NaN;
                    break;
                }
                d2 = Math.exp(d2);
                break;
            }
            case 131: {
                try {
                    d2 = Maths.logGamma(d);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    d2 = Double.NaN;
                }
                break;
            }
            default: {
                throw new MathFunctionException(IMP_ERROR);
            }
        }
        this.error_check(d2, n);
        return d2;
    }

    public double binaryOperation(int n, double d, double d2) throws MathFunctionException {
        double d3 = 0.0;
        switch (n) {
            case 290: {
                return d + d2;
            }
            case 291: {
                return d - d2;
            }
            case 202: {
                if (Maths.multOverflow(d, d2)) {
                    throw new MathFunctionException(TOO_BIG);
                }
                return d * d2;
            }
            case 203: {
                if (d2 == 0.0) {
                    throw new MathFunctionException(DIV_ZERO);
                }
                return d / d2;
            }
            case 204: {
                d3 = Math.pow(d, d2);
                break;
            }
            case 216: {
                return d != 0.0 && d2 != 0.0 ? 1.0 : 0.0;
            }
            case 217: {
                return d != 0.0 || d2 != 0.0 ? 1.0 : 0.0;
            }
            case 211: {
                return d <= d2 ? 1.0 : 0.0;
            }
            case 213: {
                return d >= d2 ? 1.0 : 0.0;
            }
            case 215: {
                return d != d2 ? 1.0 : 0.0;
            }
            case 210: {
                return d < d2 ? 1.0 : 0.0;
            }
            case 214: {
                return d > d2 ? 1.0 : 0.0;
            }
            case 212: {
                return d == d2 ? 1.0 : 0.0;
            }
            case 205: {
                if (d2 == 0.0) {
                    throw new MathFunctionException(DIV_ZERO);
                }
                return Maths.fmod(d, d2);
            }
            default: {
                throw new MathFunctionException(IMP_ERROR);
            }
        }
        this.error_check(d3, n);
        return d3;
    }

    private void error_check(double d, int n) throws MathFunctionException {
        if (Double.isNaN(d)) {
            throw new MathFunctionException("Inappropriate argument to " + this.getTokenFromCode(n));
        }
        if (Double.isInfinite(d)) {
            throw new MathFunctionException("Result from " + this.getTokenFromCode(n) + " is infinite");
        }
    }

    public boolean replaceToken(String string, String string2) {
        int n = 0;
        while (n < this.getNumberOfTokens()) {
            if (this.getToken(n).equalsIgnoreCase(string)) {
                this.defaultTab[n].string = string2;
                return true;
            }
            ++n;
        }
        return false;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double d = Double.NaN;
            X x = new X(10);
            StandardMathFunction standardMathFunction = new StandardMathFunction();
            StatisticalMathFunction statisticalMathFunction = new StatisticalMathFunction(x);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            System.out.println(statisticalMathFunction.getSummary());
            while (true) {
                String string;
                System.out.println("Enter expression f(X), or ? for help or Q to quit or Return to re-evaluate f(X).");
                try {
                    string = bufferedReader.readLine();
                }
                catch (IOException iOException) {
                    System.out.println(iOException.getMessage());
                    continue;
                }
                if (string.length() > 0) {
                    if (Character.toUpperCase(string.charAt(0)) == 'Q') {
                        System.exit(0);
                    }
                    if (string.charAt(0) == '?') {
                        System.out.println(statisticalMathFunction.getSummary());
                        continue;
                    }
                    try {
                        d = statisticalMathFunction.parse(string);
                    }
                    catch (MathFunctionException mathFunctionException) {
                        System.out.println(mathFunctionException.getMessage());
                        continue;
                    }
                }
                if (statisticalMathFunction.getNumberOfVariablesUsed() == 0) {
                    System.out.println("Constant value is " + d);
                    continue;
                }
                int n = 0;
                while (n < x.getNumberOfVariables()) {
                    block17: {
                        String string2 = "X" + (n + 1);
                        if (statisticalMathFunction.variableUsed(string2)) {
                            String string3;
                            System.out.println("Enter value of " + string2);
                            try {
                                string3 = bufferedReader.readLine();
                            }
                            catch (IOException iOException) {
                                System.out.println(iOException.getMessage());
                                break block17;
                            }
                            try {
                                x.setVariableValue(n, standardMathFunction.parse(string3));
                            }
                            catch (MathFunctionException mathFunctionException) {
                                System.out.println(mathFunctionException.getMessage());
                            }
                        }
                    }
                    ++n;
                }
                try {
                    d = statisticalMathFunction.eval();
                }
                catch (MathFunctionException mathFunctionException) {
                    System.out.println(mathFunctionException.getMessage());
                    continue;
                }
                System.out.println("f(X) = " + d);
                System.out.println(statisticalMathFunction.getEvalCount() + " evaluations");
            }
        }

        static class X
        implements MathFunctionVariables {
            int n;
            double[] x;

            public X(int n) {
                this.n = n;
                this.x = new double[n];
            }

            public int getNumberOfVariables() {
                return this.n;
            }

            public String getVariableName(int n) {
                return "X" + (n + 1);
            }

            public double getVariableValue(int n) {
                return this.x[n];
            }

            public void setVariableValue(int n, double d) {
                this.x[n] = d;
            }
        }
    }

    class Token {
        String string;
        int code;
        int prec;

        Token(String string, int n, int n2) {
            this.string = string;
            this.code = n;
            this.prec = n2;
        }
    }
}

