/*
 * Decompiled with CFR 0.152.
 */
package jsc.numerical;

import jsc.numerical.Function;
import jsc.numerical.IntegratingFunction;
import jsc.numerical.NumericalException;

public class ExtendedMidpointPosExpRule
implements IntegratingFunction {
    private double s;

    public double getIntegral(Function function, double d, double d2, int n) throws NumericalException {
        d2 = d == 0.0 ? 1.0 : Math.exp(-d);
        d = 0.0;
        if (n == 1) {
            double d3 = 0.5 * (d + d2);
            this.s = (d2 - d) * function.function(-Math.log(d3)) / d3;
            return this.s;
        }
        int n2 = 1;
        int n3 = 1;
        while (n3 < n - 1) {
            n2 *= 3;
            ++n3;
        }
        double d4 = n2;
        double d5 = (d2 - d) / (3.0 * d4);
        double d6 = d5 + d5;
        double d7 = d + 0.5 * d5;
        double d8 = 0.0;
        n3 = 1;
        while (n3 <= n2) {
            if (d7 <= 0.0) {
                throw new NumericalException("+infinity");
            }
            d8 += function.function(-Math.log(d7)) / d7;
            d8 += function.function(-Math.log(d7 += d6)) / d7;
            d7 += d5;
            ++n3;
        }
        this.s = (this.s + (d2 - d) * d8 / d4) / 3.0;
        return this.s;
    }
}

