/*
 * Decompiled with CFR 0.152.
 */
package jsc.onesample;

import jsc.datastructures.PairedData;
import jsc.distributions.Binomial;
import jsc.tests.H1;
import jsc.tests.SignificanceTest;

public class SignTest
implements SignificanceTest {
    private int n1;
    private int S;
    private double SP;

    public SignTest(double[] dArray, double d, H1 h1) {
        int n = dArray.length;
        int n2 = 0;
        this.S = 0;
        this.n1 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (dArray[n3] < d) {
                ++this.S;
            } else if (!(dArray[n3] > d)) {
                ++n2;
            }
            ++n3;
        }
        this.n1 = n - n2;
        if (this.n1 < 1) {
            throw new IllegalArgumentException("No non-zero differences.");
        }
        Binomial binomial = new Binomial((long)this.n1, 0.5);
        if (h1 == H1.NOT_EQUAL) {
            this.S = Math.min(this.S, this.n1 - this.S);
            this.SP = 2.0 * binomial.cdf(this.S);
            if (this.SP > 1.0) {
                this.SP = 1.0;
            }
        } else if (h1 == H1.LESS_THAN) {
            this.SP = 1.0 - binomial.cdf(this.S - 1);
        } else {
            this.S = this.n1 - this.S;
            this.SP = 1.0 - binomial.cdf(this.S - 1);
        }
    }

    public SignTest(double[] dArray, double d) {
        this(dArray, d, H1.NOT_EQUAL);
    }

    public SignTest(PairedData pairedData, H1 h1) {
        this(pairedData.differences(), 0.0, h1);
    }

    public SignTest(PairedData pairedData) {
        this(pairedData.differences(), 0.0, H1.NOT_EQUAL);
    }

    public int getN() {
        return this.n1;
    }

    public double getSP() {
        return this.SP;
    }

    public double getTestStatistic() {
        return this.S;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double[] dArray = new double[]{70.0, 65.0, 75.0, 58.0, 56.0, 60.0, 80.0, 75.0, 71.0, 69.0, 58.0, 75.0};
            double d = 60.0;
            SignTest signTest = new SignTest(dArray, d, H1.NOT_EQUAL);
            System.out.println("H1: median not equal " + d + " N for test = " + signTest.getN() + " S = " + signTest.getTestStatistic() + " SP = " + signTest.getSP());
            signTest = new SignTest(dArray, d, H1.LESS_THAN);
            System.out.println("H1: median < " + d + " N for test = " + signTest.getN() + " S = " + signTest.getTestStatistic() + " SP = " + signTest.getSP());
            double[] dArray2 = new double[]{0.0, 50.0, 56.0, 72.0, 80.0, 80.0, 80.0, 99.0, 101.0, 110.0, 110.0, 110.0, 120.0, 140.0, 144.0, 145.0, 150.0, 180.0, 201.0, 210.0, 220.0, 240.0, 290.0, 309.0, 320.0, 325.0, 400.0, 500.0, 507.0};
            d = 115.0;
            signTest = new SignTest(dArray2, d, H1.GREATER_THAN);
            System.out.println("H1: median > " + d + " N for test = " + signTest.getN() + " S = " + signTest.getTestStatistic() + " SP = " + signTest.getSP());
            double[] dArray3 = new double[]{70.0, 80.0, 62.0, 50.0, 70.0, 30.0, 49.0, 60.0};
            double[] dArray4 = new double[]{75.0, 82.0, 65.0, 58.0, 68.0, 41.0, 55.0, 67.0};
            PairedData pairedData = new PairedData(dArray3, dArray4);
            signTest = new SignTest(pairedData);
            System.out.println("H1: averages not equal: S = " + signTest.getTestStatistic() + " SP = " + signTest.getSP());
            signTest = new SignTest(pairedData, H1.LESS_THAN);
            System.out.println("H1: average A < average B: S = " + signTest.getTestStatistic() + " SP = " + signTest.getSP());
            signTest = new SignTest(pairedData, H1.GREATER_THAN);
            System.out.println("H1: average A > average B: S = " + signTest.getTestStatistic() + " SP = " + signTest.getSP());
            double[] dArray5 = new double[]{17.4, 15.7, 12.9, 9.8, 13.4, 18.7, 13.9, 11.0, 5.4, 10.4, 16.4, 5.6};
            double[] dArray6 = new double[]{13.6, 10.1, 10.3, 9.2, 11.1, 20.4, 10.4, 11.4, 4.9, 8.9, 11.2, 4.8};
            pairedData = new PairedData(dArray5, dArray6);
            signTest = new SignTest(pairedData, H1.GREATER_THAN);
            System.out.println("H1: average A > average B: S = " + signTest.getTestStatistic() + " SP = " + signTest.getSP());
            double[] dArray7 = new double[]{4.0, 4.0, 5.0, 5.0, 3.0, 2.0, 5.0, 3.0, 1.0, 5.0, 5.0, 5.0, 4.0, 5.0, 5.0, 5.0, 5.0};
            double[] dArray8 = new double[]{2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 2.0, 3.0, 2.0, 2.0, 5.0, 2.0, 5.0, 3.0, 1.0};
            pairedData = new PairedData(dArray7, dArray8);
            signTest = new SignTest(pairedData, H1.GREATER_THAN);
            System.out.println("H1: average A < average B: S = " + signTest.getTestStatistic() + " SP = " + signTest.getSP());
        }
    }
}

