/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.control;

import java.text.DecimalFormat;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JSlider;

public class RealSlider
extends JSlider {
    double minVal;
    double maxVal;
    double range;

    public RealSlider(double d, double d2, double d3, double d4, double d5, double d6, double d7, String string) {
        super(0);
        this.rescale(d, d2, d3, d4, d5, d6, d7, string);
    }

    public double getMaximumValue() {
        return this.maxVal;
    }

    public double getMinimumValue() {
        return this.minVal;
    }

    public double getRealValue() {
        return this.minVal + this.range * (double)this.getValue() / (double)this.getMaximum();
    }

    public void rescale(double d, double d2, double d3, double d4, double d5, double d6, double d7, String string) {
        this.minVal = d;
        this.maxVal = d2;
        this.range = d2 - d;
        int n = (int)(this.range / d4);
        this.setMinimum(0);
        this.setMaximum(n);
        this.setValue((int)((d3 - d) / d4));
        this.setMinorTickSpacing((int)(d5 / d4));
        this.setMajorTickSpacing((int)(d6 / d4));
        if (d7 > 0.0) {
            int n2 = (int)(1.0 + this.range / d7);
            int n3 = n / (n2 - 1);
            this.setPaintTicks(true);
            Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>(n2);
            DecimalFormat decimalFormat = new DecimalFormat(string);
            int n4 = 0;
            while (n4 < n2) {
                double d8 = d + (double)n4 * d7;
                hashtable.put(new Integer(n4 * n3), new JLabel(decimalFormat.format(d8)));
                ++n4;
            }
            this.setLabelTable(hashtable);
            this.setPaintLabels(true);
        } else {
            this.setPaintLabels(false);
        }
    }

    int getSliderValue(double d) {
        double d2 = (d - this.minVal) / this.range * (double)this.getMaximum();
        return (int)Math.round(d2);
    }

    public void setLabels(double[] dArray, String string) {
        int n = dArray.length;
        this.setPaintTicks(true);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>(n);
        DecimalFormat decimalFormat = new DecimalFormat(string);
        int n2 = 0;
        while (n2 < n) {
            hashtable.put(new Integer(this.getSliderValue(dArray[n2])), new JLabel(decimalFormat.format(dArray[n2])));
            ++n2;
        }
        this.setLabelTable(hashtable);
        this.setPaintLabels(true);
        this.updateUI();
    }

    public void setRealValue(double d) {
        this.setValue(this.getSliderValue(d));
    }
}

