/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.datatable;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.border.BevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jsc.swt.control.ToolBar;
import jsc.swt.datatable.DataCalculator;
import jsc.swt.datatable.DataFile;
import jsc.swt.datatable.DataMatrix;
import jsc.swt.datatable.DataModel;
import jsc.swt.datatable.DataTable;
import jsc.swt.datatable.RecodeModel;
import jsc.swt.datatable.RecodeTable;
import jsc.swt.datatable.StatisticalCalculator;
import jsc.swt.dialogue.Dialogue;
import jsc.swt.dialogue.NameDialogue;
import jsc.swt.help.HelpAction;
import jsc.swt.menu.DigitsMenu;
import jsc.util.Rank;
import jsc.util.Sort;

public class DataWindow
extends JInternalFrame {
    protected JMenuBar menuBar;
    protected JMenu helpMenu;
    protected ToolBar toolBar;
    protected DataTable dataTable;
    String initialHelpPage = "C:\\java\\jsc\\swt\\datatable\\help\\datatable.htm";
    String browserPath = "C:\\Program Files\\Internet Explorer\\IEXPLORE.EXE";
    CopyAction copyAction;
    CutAction cutAction;
    ClearAction clearAction;
    PasteAction pasteAction;
    PasteClipboardAction pasteClipboardAction;
    JInternalFrame parent = this;
    DataCalculator calculator;
    ImageIcon windowIcon;
    HelpAction helpAction;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Integer;

    public DataWindow(DataMatrix dataMatrix) {
        super(" Data", true, true, true, true);
        DataModel dataModel = new DataModel(dataMatrix);
        this.dataTable = new DataTable(dataModel);
        this.dataTable.setColumnSelectionAllowed(false);
        this.dataTable.setRowSelectionAllowed(false);
        this.dataTable.setCellSelectionEnabled(true);
        ImageIcon imageIcon = null;
        ImageIcon imageIcon2 = null;
        ImageIcon imageIcon3 = null;
        ImageIcon imageIcon4 = null;
        ImageIcon imageIcon5 = null;
        ImageIcon imageIcon6 = null;
        ImageIcon imageIcon7 = null;
        Class<?> clazz = this.getClass();
        URL uRL = clazz.getResource("images/table.gif");
        if (uRL != null) {
            this.windowIcon = new ImageIcon(uRL);
        }
        if ((uRL = clazz.getResource("images/cut.gif")) != null) {
            imageIcon = new ImageIcon(uRL);
        }
        if ((uRL = clazz.getResource("images/copy.gif")) != null) {
            imageIcon2 = new ImageIcon(uRL);
        }
        if ((uRL = clazz.getResource("images/paste.gif")) != null) {
            imageIcon3 = new ImageIcon(uRL);
        }
        if ((uRL = clazz.getResource("images/newrow.gif")) != null) {
            imageIcon4 = new ImageIcon(uRL);
        }
        if ((uRL = clazz.getResource("images/newcol.gif")) != null) {
            imageIcon5 = new ImageIcon(uRL);
        }
        if ((uRL = clazz.getResource("images/calculator.gif")) != null) {
            imageIcon6 = new ImageIcon(uRL);
        }
        if ((uRL = clazz.getResource("images/help.gif")) != null) {
            imageIcon7 = new ImageIcon(uRL);
        }
        this.setFrameIcon(this.windowIcon);
        this.setClosable(false);
        this.menuBar = new JMenuBar();
        this.menuBar.setBorder(new BevelBorder(0));
        JMenu jMenu = new JMenu("Edit");
        jMenu.setMnemonic('E');
        this.menuBar.add(jMenu);
        this.cutAction = new CutAction("Cut", imageIcon);
        this.clearAction = new ClearAction("Delete");
        this.copyAction = new CopyAction("Copy", imageIcon2);
        this.pasteAction = new PasteAction("Paste", imageIcon3);
        this.pasteClipboardAction = new PasteClipboardAction("Paste from system");
        SelectAllAction selectAllAction = new SelectAllAction("Select all");
        SelectNoneAction selectNoneAction = new SelectNoneAction("Select none");
        InsertRowAction insertRowAction = new InsertRowAction("Insert row", imageIcon4);
        InsertColumnAction insertColumnAction = new InsertColumnAction("Add column", imageIcon5);
        ResetColumnAction resetColumnAction = new ResetColumnAction("Reset column order");
        JMenuItem jMenuItem = jMenu.add(this.cutAction);
        jMenuItem.setMnemonic('T');
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2, false));
        jMenuItem = jMenu.add(this.copyAction);
        jMenuItem.setMnemonic('C');
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2, false));
        jMenuItem = jMenu.add(this.pasteAction);
        jMenuItem.setMnemonic('P');
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2, false));
        jMenuItem = jMenu.add(this.pasteClipboardAction);
        jMenuItem.setMnemonic('Y');
        jMenuItem = jMenu.add(this.clearAction);
        jMenuItem.setMnemonic('L');
        jMenu.addSeparator();
        jMenuItem = jMenu.add(selectAllAction);
        jMenuItem.setMnemonic('S');
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2, false));
        jMenuItem = jMenu.add(selectNoneAction);
        jMenuItem.setMnemonic('N');
        jMenu.addSeparator();
        jMenuItem = jMenu.add(insertRowAction);
        jMenuItem.setMnemonic('I');
        jMenuItem = jMenu.add(insertColumnAction);
        jMenuItem.setMnemonic('A');
        jMenuItem = jMenu.add(resetColumnAction);
        jMenuItem.setMnemonic('O');
        jMenu.addSeparator();
        RenameColumnAction renameColumnAction = new RenameColumnAction("Rename column");
        jMenuItem = jMenu.add(renameColumnAction);
        jMenuItem.setMnemonic('R');
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, 2, false));
        ChangeColumnTypeAction changeColumnTypeAction = new ChangeColumnTypeAction("Change column type");
        jMenuItem = jMenu.add(changeColumnTypeAction);
        jMenuItem.setMnemonic('H');
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(72, 2, false));
        JMenu jMenu2 = new JMenu("Manipulate");
        jMenu2.setMnemonic('M');
        this.menuBar.add(jMenu2);
        SortRowsAction sortRowsAction = new SortRowsAction("Sort rows...");
        jMenuItem = jMenu2.add(sortRowsAction);
        jMenuItem.setMnemonic('S');
        RecodeAction recodeAction = new RecodeAction("Recode...");
        jMenuItem = jMenu2.add(recodeAction);
        jMenuItem.setMnemonic('R');
        SubsetAction subsetAction = new SubsetAction("Subset...");
        jMenuItem = jMenu2.add(subsetAction);
        jMenuItem.setMnemonic('U');
        JMenu jMenu3 = new JMenu("Calculate");
        jMenu3.setMnemonic('C');
        this.menuBar.add(jMenu3);
        CalculatorAction calculatorAction = new CalculatorAction("Calculator...", imageIcon6);
        jMenuItem = jMenu3.add(calculatorAction);
        jMenuItem.setMnemonic('C');
        jMenu3.addSeparator();
        CalculateListener calculateListener = new CalculateListener();
        jMenuItem = jMenu3.add("Square...");
        jMenuItem.setMnemonic('S');
        jMenuItem.addActionListener(calculateListener);
        jMenuItem = jMenu3.add("Square root...");
        jMenuItem.setMnemonic('Q');
        jMenuItem.addActionListener(calculateListener);
        jMenuItem = jMenu3.add("Log...");
        jMenuItem.setMnemonic('L');
        jMenuItem.addActionListener(calculateListener);
        jMenuItem = jMenu3.add("Reciprocal root...");
        jMenuItem.setMnemonic('R');
        jMenuItem.addActionListener(calculateListener);
        jMenuItem = jMenu3.add("Reciprocal...");
        jMenuItem.setMnemonic('E');
        jMenuItem.addActionListener(calculateListener);
        jMenu3.addSeparator();
        jMenuItem = jMenu3.add("Rank...");
        jMenuItem.setMnemonic('K');
        jMenuItem.addActionListener(calculateListener);
        jMenuItem = jMenu3.add("Normal scores...");
        jMenuItem.setMnemonic('N');
        jMenuItem.addActionListener(calculateListener);
        JMenu jMenu4 = new JMenu("Options");
        jMenu4.setMnemonic('O');
        this.menuBar.add(jMenu4);
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Show toolbar", true);
        jCheckBoxMenuItem.setMnemonic('T');
        jCheckBoxMenuItem.addActionListener(new ShowToolBarListener());
        jMenu4.add(jCheckBoxMenuItem);
        JMenu jMenu5 = new JMenu("Selection");
        jMenu5.setMnemonic('S');
        jMenu4.add(jMenu5);
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("Columns");
        jRadioButtonMenuItem.setMnemonic('C');
        JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem("Rows");
        jRadioButtonMenuItem2.setMnemonic('R');
        JRadioButtonMenuItem jRadioButtonMenuItem3 = new JRadioButtonMenuItem("Any cells", true);
        jRadioButtonMenuItem3.setMnemonic('A');
        jRadioButtonMenuItem.addActionListener(new SelectionColumnsListener());
        jRadioButtonMenuItem2.addActionListener(new SelectionRowsListener());
        jRadioButtonMenuItem3.addActionListener(new SelectionCellsListener());
        buttonGroup.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem2);
        buttonGroup.add(jRadioButtonMenuItem3);
        jMenu5.add(jRadioButtonMenuItem);
        jMenu5.add(jRadioButtonMenuItem2);
        jMenu5.add(jRadioButtonMenuItem3);
        DigitsMenu digitsMenu = new DigitsMenu("Significant figures", 16, this.dataTable.getSignificantDigits(), new DigitsListener());
        digitsMenu.setMnemonic('I');
        jMenu4.add(digitsMenu);
        JMenu jMenu6 = new JMenu("Default column type");
        jMenu6.setMnemonic('D');
        ButtonGroup buttonGroup2 = new ButtonGroup();
        Class clazz2 = dataMatrix.getDefaultColumnClass();
        JRadioButtonMenuItem jRadioButtonMenuItem4 = new JRadioButtonMenuItem("Categorical", clazz2 == (class$java$lang$String == null ? (class$java$lang$String = DataWindow.class$("java.lang.String")) : class$java$lang$String));
        jRadioButtonMenuItem4.setMnemonic('C');
        JRadioButtonMenuItem jRadioButtonMenuItem5 = new JRadioButtonMenuItem("Continuous", clazz2 == (class$java$lang$Double == null ? (class$java$lang$Double = DataWindow.class$("java.lang.Double")) : class$java$lang$Double));
        jRadioButtonMenuItem5.setMnemonic('O');
        JRadioButtonMenuItem jRadioButtonMenuItem6 = new JRadioButtonMenuItem("Integer", clazz2 == (class$java$lang$Integer == null ? (class$java$lang$Integer = DataWindow.class$("java.lang.Integer")) : class$java$lang$Integer));
        jRadioButtonMenuItem6.setMnemonic('I');
        jRadioButtonMenuItem4.addActionListener(new CategoricalListener());
        jRadioButtonMenuItem5.addActionListener(new ContinuousListener());
        jRadioButtonMenuItem6.addActionListener(new IntegerListener());
        buttonGroup2.add(jRadioButtonMenuItem4);
        buttonGroup2.add(jRadioButtonMenuItem5);
        buttonGroup2.add(jRadioButtonMenuItem6);
        jMenu6.add(jRadioButtonMenuItem4);
        jMenu6.add(jRadioButtonMenuItem5);
        jMenu6.add(jRadioButtonMenuItem6);
        jMenu4.add(jMenu6);
        this.helpMenu = new JMenu("Help");
        this.helpMenu.setMnemonic('H');
        this.menuBar.add(this.helpMenu);
        this.helpAction = new HelpAction(this.parent, "Help topics...", imageIcon7, this.browserPath, this.initialHelpPage);
        jMenuItem = this.helpMenu.add(this.helpAction);
        jMenuItem.setMnemonic('H');
        AboutAction aboutAction = new AboutAction("About...");
        jMenuItem = this.helpMenu.add(aboutAction);
        jMenuItem.setMnemonic('A');
        this.toolBar = new ToolBar("Data tool bar", new Dimension(30, 30));
        this.toolBar.setFloatable(true);
        this.copyAction.setEnabled(false);
        this.cutAction.setEnabled(false);
        this.clearAction.setEnabled(false);
        this.pasteAction.setEnabled(DataTable.copiedData.hasData());
        if (this.getToolkit().getSystemClipboard().getContents(this) == null) {
            this.pasteClipboardAction.setEnabled(false);
        }
        this.toolBar.add(this.cutAction, "Cut selected cells");
        this.toolBar.add(this.copyAction, "Copy selected cells");
        this.toolBar.add(this.pasteAction, "Paste data into cells");
        this.toolBar.addSeparator();
        this.toolBar.add(insertRowAction, "Insert new row");
        this.toolBar.add(insertColumnAction, "Add new column");
        this.toolBar.addSeparator();
        this.toolBar.add(calculatorAction, "Calculate function of columns");
        this.toolBar.addSeparator();
        this.toolBar.add(this.helpAction, "Help");
        this.setJMenuBar(this.menuBar);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout(1, 1));
        container.add((Component)this.toolBar, "North");
        ListSelectionModel listSelectionModel = this.dataTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectionDebugger(listSelectionModel));
        JScrollPane jScrollPane = new JScrollPane(this.dataTable);
        container.add((Component)jScrollPane, "Center");
        this.setCalculator(new StatisticalCalculator(this.parent, this.dataTable));
    }

    public String[] getCategoricalData(String string) {
        return this.dataTable.getCategoricalData(string);
    }

    public int getColumnCount() {
        return this.dataTable.getColumnCount();
    }

    public Vector getColumnNames(boolean bl, boolean bl2, boolean bl3, int n) {
        return this.dataTable.getColumnNames(bl, bl2, bl3, n);
    }

    public StringBuffer getDataAsStringBuffer(boolean bl, String string) {
        return this.dataTable.getDataAsStringBuffer(true, bl, string);
    }

    public DataMatrix getDataMatrix() {
        return this.dataTable.dataModel.dataMatrix;
    }

    public DataModel getDataModel() {
        return this.dataTable.dataModel;
    }

    public DataTable getDataTable() {
        return this.dataTable;
    }

    public int getNumberOfPages() {
        return 2;
    }

    public double[] getNumericalData(String string) {
        return this.dataTable.getNumericalData(string);
    }

    public double[][] getNumericalData(String[] stringArray) {
        return this.dataTable.getNumericalData(stringArray);
    }

    public int getRowCount() {
        return this.dataTable.getRowCount();
    }

    public boolean isChanged() {
        return this.dataTable.isChanged();
    }

    public static DataMatrix read(File file) {
        return DataFile.read(file);
    }

    public static DataMatrix readTextFile(File file, boolean bl, String string, String string2) {
        return DataFile.readTextFile(file, bl, string, string2);
    }

    public void setBrowserPath(String string) {
        this.helpAction.setBrowserPath(string);
    }

    public void setCalculator(DataCalculator dataCalculator) {
        this.calculator = dataCalculator;
    }

    public void setChanged(boolean bl) {
        this.dataTable.setChanged(bl);
    }

    public void setInitialHelpPage(String string) {
        this.helpAction.setInitialHelpPage(string);
    }

    public boolean write(File file) {
        return DataFile.write(file, this.dataTable);
    }

    public boolean writeTextFile(File file, boolean bl, String string) {
        return DataFile.writeTextFile(file, this.dataTable, bl, string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class SubsetAction
    extends AbstractAction {
        public SubsetAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Vector vector = DataWindow.this.getColumnNames(false, true, true, 2);
            if (vector.isEmpty()) {
                return;
            }
            NameDialogue nameDialogue = new NameDialogue((Component)DataWindow.this.parent, "Subset dialogue", "Select column to choose subset with", vector, 0);
            String[] stringArray = nameDialogue.showNames();
            if (stringArray == null) {
                return;
            }
            String[] stringArray2 = DataWindow.this.getCategoricalData(stringArray[0]);
            if (stringArray2.length < 1) {
                return;
            }
            Vector vector2 = Sort.getLabels(stringArray2);
            JList jList = new JList(vector2);
            JScrollPane jScrollPane = new JScrollPane(jList);
            Dialogue dialogue = new Dialogue(DataWindow.this.parent, "Subset using " + stringArray[0], "Select values that define subset", -1, 2);
            dialogue.add(jScrollPane, "Center");
            ButtonGroup buttonGroup = new ButtonGroup();
            JRadioButton jRadioButton = new JRadioButton("Include", true);
            JRadioButton jRadioButton2 = new JRadioButton("Exclude");
            buttonGroup.add(jRadioButton);
            buttonGroup.add(jRadioButton2);
            JPanel jPanel = new JPanel();
            jPanel.add(jRadioButton);
            jPanel.add(jRadioButton2);
            dialogue.add(jPanel, "South");
            if (dialogue.show() == null) {
                return;
            }
            DataWindow.this.dataTable.subset(stringArray[0], jList, jRadioButton.isSelected());
        }
    }

    class SortRowsAction
    extends AbstractAction {
        public SortRowsAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Vector vector = DataWindow.this.getColumnNames(true, true, true, 2);
            if (vector.isEmpty()) {
                return;
            }
            NameDialogue nameDialogue = new NameDialogue((Component)DataWindow.this.parent, "Sort dialogue", "Select column to sort with", vector, 0);
            ButtonGroup buttonGroup = new ButtonGroup();
            JRadioButton jRadioButton = new JRadioButton("Ascending", true);
            JRadioButton jRadioButton2 = new JRadioButton("Descending");
            buttonGroup.add(jRadioButton);
            buttonGroup.add(jRadioButton2);
            JPanel jPanel = new JPanel();
            jPanel.add(jRadioButton);
            jPanel.add(jRadioButton2);
            nameDialogue.add(jPanel, "South");
            String[] stringArray = nameDialogue.showNames();
            if (stringArray == null) {
                return;
            }
            DataWindow.this.dataTable.sortRows(stringArray[0], jRadioButton.isSelected());
        }
    }

    class ShowToolBarListener
    implements ActionListener {
        ShowToolBarListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DataWindow.this.toolBar.setVisible(!DataWindow.this.toolBar.isVisible());
        }
    }

    class SelectNoneAction
    extends AbstractAction {
        public SelectNoneAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DataWindow.this.dataTable.clearSelection();
        }
    }

    class SelectionRowsListener
    implements ActionListener {
        SelectionRowsListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DataWindow.this.dataTable.setColumnSelectionAllowed(false);
            DataWindow.this.dataTable.setRowSelectionAllowed(true);
            DataWindow.this.dataTable.clearSelection();
        }
    }

    public class SelectionDebugger
    implements ListSelectionListener {
        ListSelectionModel model;

        public SelectionDebugger(ListSelectionModel listSelectionModel) {
            this.model = listSelectionModel;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            boolean bl = !this.model.isSelectionEmpty();
            DataWindow.this.copyAction.setEnabled(bl);
            DataWindow.this.cutAction.setEnabled(bl);
            DataWindow.this.clearAction.setEnabled(bl);
        }
    }

    class SelectionColumnsListener
    implements ActionListener {
        SelectionColumnsListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DataWindow.this.dataTable.setColumnSelectionAllowed(true);
            DataWindow.this.dataTable.setRowSelectionAllowed(false);
            DataWindow.this.dataTable.clearSelection();
        }
    }

    class SelectionCellsListener
    implements ActionListener {
        SelectionCellsListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DataWindow.this.dataTable.setColumnSelectionAllowed(false);
            DataWindow.this.dataTable.setRowSelectionAllowed(false);
            DataWindow.this.dataTable.setCellSelectionEnabled(true);
            DataWindow.this.dataTable.clearSelection();
        }
    }

    class SelectAllAction
    extends AbstractAction {
        public SelectAllAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DataWindow.this.dataTable.selectAll();
        }
    }

    class ResetColumnAction
    extends AbstractAction {
        public ResetColumnAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DataWindow.this.dataTable.resetColumnOrder();
        }
    }

    class RenameColumnAction
    extends AbstractAction {
        public RenameColumnAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DataWindow.this.dataTable.editColumnName();
        }
    }

    class RecodeAction
    extends AbstractAction {
        public RecodeAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Vector vector = DataWindow.this.getColumnNames(true, true, true, 1);
            if (vector.isEmpty()) {
                return;
            }
            NameDialogue nameDialogue = new NameDialogue((Component)DataWindow.this.parent, "Recode dialogue", "Select column to recode", vector, 0);
            String[] stringArray = nameDialogue.showNames();
            if (stringArray == null) {
                return;
            }
            String[] stringArray2 = DataWindow.this.getCategoricalData(stringArray[0]);
            if (stringArray2.length < 1) {
                return;
            }
            Vector vector2 = Sort.getLabels(stringArray2);
            RecodeModel recodeModel = new RecodeModel(vector2);
            RecodeTable recodeTable = new RecodeTable(recodeModel);
            JScrollPane jScrollPane = new JScrollPane(recodeTable);
            Dialogue dialogue = new Dialogue(DataWindow.this.parent, "Recode values of " + stringArray[0], "Type new values into 2nd column. Select (drag down) rows to duplicate new values.", -1, 2);
            dialogue.add(jScrollPane, "Center");
            dialogue.setSize(300, 400);
            if (dialogue.show() == null) {
                return;
            }
            int n = DataWindow.this.dataTable.recode(stringArray[0], recodeTable);
            DataWindow.this.dataTable.setColumnName(n, stringArray[0] + " recoded");
            DataWindow.this.dataTable.promoteColumnClass(n);
        }
    }

    class PasteClipboardAction
    extends AbstractAction {
        public PasteClipboardAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DataWindow.this.dataTable.pasteFromSystemClipboard();
        }
    }

    class PasteAction
    extends AbstractAction {
        public PasteAction(String string, Icon icon) {
            super(string, icon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DataWindow.this.dataTable.paste();
        }
    }

    class IntegerListener
    implements ActionListener {
        IntegerListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DataWindow.this.dataTable.setDefaultColumnClass(class$java$lang$Integer == null ? (class$java$lang$Integer = DataWindow.class$("java.lang.Integer")) : class$java$lang$Integer);
        }
    }

    class InsertRowAction
    extends AbstractAction {
        public InsertRowAction(String string, Icon icon) {
            super(string, icon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DataWindow.this.dataTable.insertRow();
        }
    }

    class InsertColumnAction
    extends AbstractAction {
        public InsertColumnAction(String string, Icon icon) {
            super(string, icon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DataWindow.this.dataTable.addColumn();
        }
    }

    class DigitsListener
    implements ActionListener {
        DigitsListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = Integer.parseInt(actionEvent.getActionCommand());
            DataWindow.this.dataTable.setSignificantDigits(n);
        }
    }

    class CutAction
    extends AbstractAction {
        public CutAction(String string, Icon icon) {
            super(string, icon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DataWindow.this.dataTable.copy();
            DataWindow.this.dataTable.clear();
            DataWindow.this.pasteAction.setEnabled(true);
            DataWindow.this.pasteClipboardAction.setEnabled(true);
        }
    }

    class CopyAction
    extends AbstractAction {
        public CopyAction(String string, Icon icon) {
            super(string, icon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DataWindow.this.dataTable.copy();
            DataWindow.this.pasteAction.setEnabled(true);
            DataWindow.this.pasteClipboardAction.setEnabled(true);
        }
    }

    class ContinuousListener
    implements ActionListener {
        ContinuousListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DataWindow.this.dataTable.setDefaultColumnClass(class$java$lang$Double == null ? (class$java$lang$Double = DataWindow.class$("java.lang.Double")) : class$java$lang$Double);
        }
    }

    class ClearAction
    extends AbstractAction {
        public ClearAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DataWindow.this.dataTable.clear();
        }
    }

    class ChangeColumnTypeAction
    extends AbstractAction {
        public ChangeColumnTypeAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DataWindow.this.dataTable.changeColumnType();
        }
    }

    class CategoricalListener
    implements ActionListener {
        CategoricalListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DataWindow.this.dataTable.setDefaultColumnClass(class$java$lang$String == null ? (class$java$lang$String = DataWindow.class$("java.lang.String")) : class$java$lang$String);
        }
    }

    class CalculatorAction
    extends AbstractAction {
        public CalculatorAction(String string, Icon icon) {
            super(string, icon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DataWindow.this.calculator.updateNames();
            DataWindow.this.calculator.show();
        }
    }

    class CalculateListener
    implements ActionListener {
        CalculateListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Vector vector = DataWindow.this.getColumnNames(true, true, false, 2);
            if (vector.isEmpty()) {
                return;
            }
            NameDialogue nameDialogue = new NameDialogue((Component)DataWindow.this.parent, "Calculation dialogue", "Select column to do calculation on", vector, 0);
            String[] stringArray = nameDialogue.showNames();
            if (stringArray == null) {
                return;
            }
            String string = actionEvent.getActionCommand();
            int n = -1;
            if (string.equals("Rank...")) {
                double[] dArray = DataWindow.this.getNumericalData(stringArray[0]);
                Rank rank = new Rank(dArray, 0.0);
                n = DataWindow.this.dataTable.addColumn();
                DataWindow.this.dataTable.setData(rank.getRanks(), n, stringArray[0]);
            } else if (string.equals("Normal scores...")) {
                double[] dArray = DataWindow.this.getNumericalData(stringArray[0]);
                Rank rank = new Rank(dArray, 0.0);
                n = DataWindow.this.dataTable.addColumn();
                double[] dArray2 = rank.getRanks();
                int n2 = rank.getN();
                double[] dArray3 = new double[n2];
                int n3 = 0;
                while (n3 < n2) {
                    double d = (dArray2[n3] - 0.375) / ((double)n2 + 0.25);
                    dArray3[n3] = 4.91 * (Math.pow(d, 0.14) - Math.pow(1.0 - d, 0.14));
                    ++n3;
                }
                DataWindow.this.dataTable.setData(dArray3, n, stringArray[0]);
            } else if (string.equals("Square...")) {
                DataTable cfr_ignored_0 = DataWindow.this.dataTable;
                n = DataWindow.this.dataTable.transform(stringArray[0], 1);
            } else if (string.equals("Square root...")) {
                DataTable cfr_ignored_1 = DataWindow.this.dataTable;
                n = DataWindow.this.dataTable.transform(stringArray[0], 2);
            } else if (string.equals("Log...")) {
                DataTable cfr_ignored_2 = DataWindow.this.dataTable;
                n = DataWindow.this.dataTable.transform(stringArray[0], 3);
            } else if (string.equals("Reciprocal root...")) {
                DataTable cfr_ignored_3 = DataWindow.this.dataTable;
                n = DataWindow.this.dataTable.transform(stringArray[0], 4);
            } else if (string.equals("Reciprocal...")) {
                DataTable cfr_ignored_4 = DataWindow.this.dataTable;
                n = DataWindow.this.dataTable.transform(stringArray[0], 5);
            }
            DataWindow.this.dataTable.setColumnName(n, string.substring(0, string.length() - 3) + " of  " + stringArray[0]);
            DataWindow.this.calculator.updateNames();
        }
    }

    class AboutAction
    extends AbstractAction {
        public AboutAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JPanel jPanel = new JPanel(new GridLayout(2, 1));
            jPanel.add(new JLabel("Data Window V2.5", 0));
            jPanel.add(new JLabel("Copyright \u00a9 2004  A. J. Bertie", 0));
            JOptionPane.showMessageDialog(DataWindow.this.parent, jPanel, "About Data Window", -1, null);
        }
    }
}

