/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.plot2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import jsc.swt.plot.AxisModel;
import jsc.swt.plot.LinearAxisModel;
import jsc.swt.plot2d.PlotObject;
import jsc.swt.plot2d.PlotShape;
import jsc.swt.plot2d.PlotText;
import jsc.swt.plot2d.TickMark;
import jsc.swt.virtualgraphics.VirtualTransform;

public class Axis
implements PlotObject {
    static final Font DEFAULT_AXIS_LABEL_FONT = new Font("SansSerif", 0, 14);
    static final Color DEFAULT_COLOUR = Color.black;
    static final Stroke DEFAULT_STROKE = new BasicStroke();
    static final Font DEFAULT_TICK_LABEL_FONT = new Font("Monospaced", 0, 12);
    protected AxisModel axisModel;
    protected int tickCount;
    protected boolean paintLabels = true;
    protected PlotText axisLabel;
    protected PlotShape axisLine;
    protected PlotText[] tickLabels;
    protected TickMark[] tickMarks;

    public Axis() {
        this(new LinearAxisModel());
    }

    public Axis(AxisModel axisModel) {
        this.tickCount = axisModel.getTickCount();
        this.axisModel = (AxisModel)axisModel.clone();
        this.tickLabels = new PlotText[this.tickCount];
        this.tickMarks = new TickMark[this.tickCount];
    }

    public boolean contains(Point2D point2D, VirtualTransform virtualTransform) {
        return false;
    }

    public void draw(Graphics2D graphics2D, VirtualTransform virtualTransform) {
        this.axisLine.draw(graphics2D, virtualTransform);
        int n = 0;
        while (n < this.tickCount) {
            this.tickMarks[n].draw(graphics2D, virtualTransform);
            if (this.paintLabels) {
                this.tickLabels[n].draw(graphics2D, virtualTransform);
            }
            ++n;
        }
        this.axisLabel.draw(graphics2D, virtualTransform);
    }

    public Color getAxisColour() {
        return this.axisLine.colour;
    }

    public PlotText getAxisLabel() {
        return this.axisLabel;
    }

    public Color getAxisLabelColour() {
        return this.axisLabel.colour;
    }

    public Font getAxisLabelFont() {
        return this.axisLabel.font;
    }

    public PlotShape getAxisLine() {
        return this.axisLine;
    }

    public Stroke getAxisStroke() {
        return this.axisLine.stroke;
    }

    public double getMin() {
        return this.axisModel.getMin();
    }

    public double getMax() {
        return this.axisModel.getMax();
    }

    public AxisModel getModel() {
        return this.axisModel;
    }

    public int getTickCount() {
        return this.tickCount;
    }

    public PlotText getTickLabel(int n) {
        return this.tickLabels[n];
    }

    public Color getTickLabelColour() {
        return this.tickLabels[0].colour;
    }

    public Font getTickLabelFont() {
        return this.tickLabels[0].font;
    }

    public TickMark getTickMark(int n) {
        return this.tickMarks[n];
    }

    public int getTickSize() {
        return this.tickMarks[0].size;
    }

    public Stroke getTickStroke() {
        return this.tickMarks[0].stroke;
    }

    public void setPaintLabels(boolean bl) {
        this.paintLabels = bl;
    }
}

