/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.plot2d;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import javax.swing.JFrame;
import jsc.swt.plot2d.PlotObject;
import jsc.swt.plot2d.PlotPanel;
import jsc.swt.plot2d.StandardMarker;
import jsc.swt.virtualgraphics.VPoint;
import jsc.swt.virtualgraphics.VRectangle;
import jsc.swt.virtualgraphics.VirtualTransform;

public class PlotText
implements PlotObject {
    public static final int CENTER = 0;
    public static final int ABOVE = 1;
    public static final int BELOW = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    static Color defaultColour = Color.black;
    static Font defaultFont = new Font("SansSerif", 0, 12);
    static int defaultGap = 1;
    String string;
    VPoint anchorPoint;
    Font font;
    Color colour;
    int orientation;
    int gap;
    double angrad;

    public PlotText(String string, VPoint vPoint) {
        this(string, vPoint, 0, defaultGap, defaultColour, defaultFont, 0.0);
    }

    public PlotText(String string, VPoint vPoint, int n) {
        this(string, vPoint, n, defaultGap, defaultColour, defaultFont, 0.0);
    }

    public PlotText(String string, VPoint vPoint, int n, int n2) {
        this(string, vPoint, n, n2, defaultColour, defaultFont, 0.0);
    }

    public PlotText(String string, VPoint vPoint, int n, int n2, double d) {
        this(string, vPoint, n, n2, defaultColour, defaultFont, d);
    }

    public PlotText(String string, VPoint vPoint, int n, int n2, Color color) {
        this(string, vPoint, n, n2, color, defaultFont, 0.0);
    }

    public PlotText(String string, VPoint vPoint, int n, int n2, Color color, Font font) {
        this(string, vPoint, n, n2, color, font, 0.0);
    }

    public PlotText(String string, VPoint vPoint, int n, int n2, Color color, Font font, double d) {
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("Invalid orientation.");
        }
        this.string = string;
        this.anchorPoint = vPoint;
        this.orientation = n;
        this.angrad = -Math.toRadians(d);
        this.gap = n2;
        this.colour = color;
        this.font = font;
    }

    public boolean contains(Point2D point2D, VirtualTransform virtualTransform) {
        return false;
    }

    public void draw(Graphics2D graphics2D, VirtualTransform virtualTransform) {
        graphics2D.setColor(this.colour);
        graphics2D.setFont(this.font);
        Point point = new Point();
        virtualTransform.transform(this.anchorPoint, point);
        AffineTransform affineTransform = graphics2D.getTransform();
        AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(point.x, point.y);
        if (this.angrad != 0.0) {
            affineTransform2.rotate(this.angrad);
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        switch (this.orientation) {
            case 1: {
                affineTransform2.translate(-fontMetrics.stringWidth(this.string) / 2, -this.gap);
                break;
            }
            case 4: {
                affineTransform2.translate(this.gap, (fontMetrics.getAscent() - fontMetrics.getDescent()) / 2);
                break;
            }
            case 2: {
                affineTransform2.translate(-fontMetrics.stringWidth(this.string) / 2, fontMetrics.getAscent() + this.gap);
                break;
            }
            case 3: {
                affineTransform2.translate(-fontMetrics.stringWidth(this.string) - this.gap, (fontMetrics.getAscent() - fontMetrics.getDescent()) / 2);
                break;
            }
            default: {
                affineTransform2.translate(-fontMetrics.stringWidth(this.string) / 2, (fontMetrics.getAscent() - fontMetrics.getDescent()) / 2);
            }
        }
        graphics2D.transform(affineTransform2);
        graphics2D.drawString(this.string, 0, 0);
        graphics2D.setTransform(affineTransform);
    }

    public VPoint getAnchorPoint() {
        return this.anchorPoint;
    }

    public void setAnchorPoint(VPoint vPoint) {
        this.anchorPoint = vPoint;
    }

    public double getAngle() {
        return -Math.toDegrees(this.angrad);
    }

    public void setAngle(double d) {
        this.angrad = -Math.toRadians(d);
    }

    public Color getColour() {
        return this.colour;
    }

    public void setColour(Color color) {
        this.colour = color;
    }

    public int getGap() {
        return this.gap;
    }

    public void setGap(int n) {
        this.gap = n;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("Invalid orientation.");
        }
        this.orientation = n;
    }

    public String getString() {
        return this.string;
    }

    public void setString(String string) {
        this.string = string;
    }

    public void setDefaultColour(Color color) {
        defaultColour = color;
    }

    public void setDefaultFont(Font font) {
        defaultFont = font;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            JFrame jFrame = new JFrame("PlotText Test");
            PlotPanel plotPanel = new PlotPanel(new Dimension(500, 400), new VRectangle(-50.0, -50.0, 100.0, 100.0));
            plotPanel.setZoomable(true);
            plotPanel.setFocusable(true);
            int n = 5;
            VPoint vPoint = new VPoint(-20.0, -10.0);
            Font font = new Font("SansSerif", 0, 24);
            plotPanel.addObject(new StandardMarker(vPoint, 0, 10, Color.red, new BasicStroke(1.0f)));
            plotPanel.addObject(new PlotText("North horizontal text", vPoint, 1, n, Color.black, font));
            plotPanel.addObject(new PlotText("South horizontal text", vPoint, 2, n, Color.black, font));
            plotPanel.addObject(new PlotText("East horizontal text", vPoint, 4, n, Color.black, font));
            plotPanel.addObject(new PlotText("West horizontal text", vPoint, 3, n, Color.black, font));
            vPoint = new VPoint(20.0, 0.0);
            plotPanel.addObject(new StandardMarker(vPoint, 6, 10, Color.red, new BasicStroke(1.0f)));
            plotPanel.addObject(new PlotText("North vertical text", vPoint, 1, n, Color.black, font, 90.0));
            plotPanel.addObject(new PlotText("South vertical text", vPoint, 2, n, Color.black, font, 90.0));
            plotPanel.addObject(new PlotText("East vertical text", vPoint, 4, n, Color.black, font, 90.0));
            plotPanel.addObject(new PlotText("West vertical text", vPoint, 3, n, Color.black, font, 90.0));
            vPoint = new VPoint(-25.0, 25.0);
            plotPanel.addObject(new StandardMarker(vPoint, 4, 6, Color.red));
            int n2 = 0;
            while (n2 < 360) {
                PlotText plotText = new PlotText("Rotated text " + n2, vPoint, 4, 7, n2);
                plotPanel.addObject(plotText);
                n2 += 30;
            }
            Container container = jFrame.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)plotPanel, "Center");
            jFrame.setVisible(true);
            jFrame.setDefaultCloseOperation(3);
            jFrame.pack();
        }
    }
}

